/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.ListListSetting;
import org.openstreetmap.josm.data.preferences.ListSetting;
import org.openstreetmap.josm.data.preferences.MapListSetting;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.data.preferences.SettingVisitor;
import org.openstreetmap.josm.data.preferences.StringSetting;
import org.openstreetmap.josm.io.XmlWriter;

public class PreferencesWriter
extends XmlWriter
implements SettingVisitor {
    private final boolean noPassword;
    private final boolean defaults;
    private String key;

    public PreferencesWriter(PrintWriter printWriter, boolean bl, boolean bl2) {
        super(printWriter);
        this.noPassword = bl;
        this.defaults = bl2;
    }

    public void write(Collection<Map.Entry<String, Setting<?>>> collection) {
        this.write(collection.stream());
    }

    public void write(Stream<Map.Entry<String, Setting<?>>> stream) {
        this.out.write(String.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n", new Object[0]));
        String string = this.defaults ? "preferences-defaults" : "preferences";
        this.out.write(String.format("<%s xmlns='%s/preferences-1.0'", string, Main.getXMLBase()));
        if (this.defaults) {
            this.out.write(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
        }
        this.out.write(String.format(" version='%d'>%n", Version.getInstance().getVersion()));
        stream.forEachOrdered(entry -> {
            this.setKey((String)entry.getKey());
            ((Setting)entry.getValue()).visit(this);
        });
        this.out.write(String.format("</%s>%n", string));
    }

    private void setKey(String string) {
        this.key = string;
    }

    private void addTime(Setting<?> setting) {
        if (this.defaults) {
            this.out.write("' time='" + Optional.ofNullable(setting.getTime()).orElseThrow(IllegalStateException::new));
        }
    }

    private void addDefaults() {
        this.out.write(String.format("' xsi:nil='true'/>%n", new Object[0]));
    }

    @Override
    public void visit(StringSetting stringSetting) {
        if (this.noPassword && "osm-server.password".equals(this.key)) {
            return;
        }
        this.out.write("  <tag key='" + XmlWriter.encode(this.key));
        this.addTime(stringSetting);
        if (stringSetting.getValue() != null) {
            this.out.write(String.format("' value='%s'/>%n", XmlWriter.encode((String)stringSetting.getValue())));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public void visit(ListSetting listSetting) {
        this.out.write("  <list key='" + XmlWriter.encode(this.key));
        this.addTime(listSetting);
        if (listSetting.getValue() != null) {
            this.out.write(String.format("'>%n", new Object[0]));
            for (String string : (List)listSetting.getValue()) {
                this.out.write(String.format("    <entry value='%s'/>%n", XmlWriter.encode(string)));
            }
            this.out.write(String.format("  </list>%n", new Object[0]));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public void visit(ListListSetting listListSetting) {
        this.out.write("  <lists key='" + XmlWriter.encode(this.key));
        this.addTime(listListSetting);
        if (listListSetting.getValue() != null) {
            this.out.write(String.format("'>%n", new Object[0]));
            for (List list : (List)listListSetting.getValue()) {
                this.out.write(String.format("    <list>%n", new Object[0]));
                for (String string : list) {
                    this.out.write(String.format("      <entry value='%s'/>%n", PreferencesWriter.encode(string)));
                }
                this.out.write(String.format("    </list>%n", new Object[0]));
            }
            this.out.write(String.format("  </lists>%n", new Object[0]));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new NullPointerException();
        }
    }

    @Override
    public void visit(MapListSetting mapListSetting) {
        this.out.write("  <maps key='" + PreferencesWriter.encode(this.key));
        this.addTime(mapListSetting);
        if (mapListSetting.getValue() != null) {
            this.out.write(String.format("'>%n", new Object[0]));
            for (Map map : (List)mapListSetting.getValue()) {
                this.out.write(String.format("    <map>%n", new Object[0]));
                for (Map.Entry entry : map.entrySet()) {
                    this.out.write(String.format("      <tag key='%s' value='%s'/>%n", PreferencesWriter.encode((String)entry.getKey()), PreferencesWriter.encode((String)entry.getValue())));
                }
                this.out.write(String.format("    </map>%n", new Object[0]));
            }
            this.out.write(String.format("  </maps>%n", new Object[0]));
        } else if (this.defaults) {
            this.addDefaults();
        } else {
            throw new NullPointerException();
        }
    }
}

