/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.AbstractLightClass;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.LightMemberOriginForDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightFieldImpl;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImpl;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

public abstract class KtLightClassBase
extends AbstractLightClass
implements PsiExtensibleClass,
KtLightClass {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    protected KtLightClassBase(PsiManager manager) {
        super(manager, KotlinLanguage.INSTANCE);
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        PsiClass psiClass = (PsiClass)this.getClsDelegate();
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getDelegate"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getAllFields"));
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getAllInnerClasses"));
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name2, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name2, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    @Override
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiField> list2 = ContainerUtil.map(this.getDelegate().getFields(), new Function<PsiField, PsiField>(){

            @Override
            public PsiField fun(PsiField field) {
                LightMemberOriginForDeclaration origin = ClsWrapperStubPsiFactory.getMemberOrigin(field);
                return KtLightFieldImpl.Factory.create(origin, field, KtLightClassBase.this);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getOwnFields"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiMethod> list2 = ArraysKt.map(this.getDelegate().getMethods(), new Function1<PsiMethod, PsiMethod>(){

            @Override
            public PsiMethod invoke(PsiMethod method) {
                KtDeclaration originalElement;
                LightMemberOriginForDeclaration origin = ClsWrapperStubPsiFactory.getMemberOrigin(method);
                KtDeclaration ktDeclaration = originalElement = origin != null ? origin.getOriginalElement() : null;
                if (originalElement instanceof KtPropertyAccessor) {
                    origin = origin.copy(PsiTreeUtil.getParentOfType((PsiElement)originalElement, KtProperty.class), origin.getOriginKind());
                }
                return KtLightMethodImpl.Factory.create(method, origin, KtLightClassBase.this);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getOwnMethods"));
        }
        return list2;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "processDeclarations"));
        }
        if (this.isEnum() && !PsiClassImplUtil.processDeclarationsInEnum(processor, state2, this.myInnersCache)) {
            return false;
        }
        return super.processDeclarations(processor, state2, lastParent, place);
    }

    @Override
    public String getText() {
        KtClassOrObject origin = (KtClassOrObject)this.getKotlinOrigin();
        return origin == null ? "" : origin.getText();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        if (kotlinLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/classes/KtLightClassBase", "getLanguage"));
        }
        return kotlinLanguage;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public PsiElement getContext() {
        return this.getParent();
    }
}

