// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _ATKMM_COMPONENT_H
#define _ATKMM_COMPONENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: component.hg,v 1.5 2004/03/12 20:35:53 murrayc Exp $ */

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/interface.h>
#include <glibmm/value.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C"
{
  typedef struct _AtkComponentIface AtkComponentIface;
  typedef struct _AtkObject         AtkObject;
  typedef void (* AtkFocusHandler) (AtkObject*, gboolean);
}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkComponent = struct _AtkComponent;
using AtkComponentClass = struct _AtkComponentClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class Component_Class; } // namespace Atk
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var CoordType XY_SCREEN
 * Specifies xy coordinates relative to the screen.
 * 
 *  @var CoordType XY_WINDOW
 * Specifies xy coordinates relative to the widget's 
 * top-level window.
 * 
 *  @enum CoordType
 * 
 * Specifies how xy coordinates are to be interpreted. Used by functions such
 * as Atk::Component::get_position() and Atk::Text::get_character_extents()
 *
 * @ingroup atkmmEnums
 */
enum CoordType
{
  XY_SCREEN,
  XY_WINDOW
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::CoordType> : public Glib::Value_Enum<Atk::CoordType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{

/** 
 *  @var Layer LAYER_INVALID
 * The object does not have a layer.
 * 
 *  @var Layer LAYER_BACKGROUND
 * This layer is reserved for the desktop background.
 * 
 *  @var Layer LAYER_CANVAS
 * This layer is used for Canvas components.
 * 
 *  @var Layer LAYER_WIDGET
 * This layer is normally used for components.
 * 
 *  @var Layer LAYER_MDI
 * This layer is used for layered components.
 * 
 *  @var Layer LAYER_POPUP
 * This layer is used for popup components, such as menus.
 * 
 *  @var Layer LAYER_OVERLAY
 * This layer is reserved for future use.
 * 
 *  @var Layer LAYER_WINDOW
 * This layer is used for toplevel windows.
 * 
 *  @enum Layer
 * 
 * Describes the layer of a component
 * 
 * These enumerated "layer values" are used when determining which UI
 * rendering layer a component is drawn into, which can help in making
 * determinations of when components occlude one another.
 *
 * @ingroup atkmmEnums
 */
enum Layer
{
  LAYER_INVALID,
  LAYER_BACKGROUND,
  LAYER_CANVAS,
  LAYER_WIDGET,
  LAYER_MDI,
  LAYER_POPUP,
  LAYER_OVERLAY,
  LAYER_WINDOW
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::Layer> : public Glib::Value_Enum<Atk::Layer>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


class Object;


/** The ATK interface provided by UI components which occupy a physical area on the screen.
 * This should be implemented by most if not all UI elements with an actual on-screen presence, i.e. components which
 * can be said to have a screen-coordinate bounding box. Virtually all widgets will need to have Atk::Component
 * implementations provided for their corresponding Atk::Object class. In short, only UI elements which are *not* GUI
 * elements will omit this ATK interface.
 * 
 * A possible exception might be textual information with a transparent background, in which case text glyph bounding
 * box information is provided by Atk::Text.
 */

class Component : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Component;
  using CppClassType = Component_Class;
  using BaseObjectType = AtkComponent;
  using BaseClassType = AtkComponentIface;

  // noncopyable
  Component(const Component&) = delete;
  Component& operator=(const Component&) = delete;

private:
  friend class Component_Class;
  static CppClassType component_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Component();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit Component(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit Component(AtkComponent* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Component(Component&& src) noexcept;
  Component& operator=(Component&& src) noexcept;

  ~Component() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkComponent*       gobj()       { return reinterpret_cast<AtkComponent*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkComponent* gobj() const { return reinterpret_cast<AtkComponent*>(gobject_); }

private:

  
public:
  
#ifndef ATKMM_DISABLE_DEPRECATED

  /** Add the specified handler to the set of functions to be called 
   * when this object receives focus events (in or out). If the handler is
   * already added it is not added again
   * 
   * Deprecated: 2.9.4: If you need to track when an object gains or
   * lose the focus, use the Atk::Object::signal_state_change() "focused" notification instead.
   * 
   * @deprecated If you need to track when an object gains or lose the focus, use Atk::Object::signal_state_change() and check for focused notification instead.
   * 
   * @param handler The Atk::FocusHandler to be attached to @a component.
   * @return A handler id which can be used in remove_focus_handler()
   * or zero if the handler was already added.
   */
  guint add_focus_handler(AtkFocusHandler handler);
#endif // ATKMM_DISABLE_DEPRECATED


  /** Checks whether the specified point is within the extent of the @a component.
   * 
   * Toolkit implementor note: ATK provides a default implementation for
   * this virtual method. In general there are little reason to
   * re-implement it.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return <tt>true</tt> or <tt>false</tt> indicating whether the specified point is within
   * the extent of the @a component or not.
   */
  bool contains(int x, int y, CoordType coord_type) const;
  
  /** Gets a reference to the accessible child, if one exists, at the
   * coordinate point specified by @a x and @a y.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return A reference to the accessible
   * child, if one exists.
   */
  Glib::RefPtr<Atk::Object> get_accessible_at_point(int x, int y, CoordType coord_type);
  
  /** Gets the rectangle which gives the extent of the @a component.
   * 
   * @param x Address of <tt>int</tt> to put x coordinate.
   * @param y Address of <tt>int</tt> to put y coordinate.
   * @param width Address of <tt>int</tt> to put width.
   * @param height Address of <tt>int</tt> to put height.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   */
  void get_extents(int& x, int& y, int& width, int& height, CoordType coord_type) const;
  
#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets the position of @a component in the form of 
   * a point specifying @a component's top-left corner.
   * 
   * Deprecated: Since 2.12. Use get_extents() instead.
   * 
   * @deprecated Use get_extents() instead.
   * 
   * @param x Address of <tt>int</tt> to put x coordinate position.
   * @param y Address of <tt>int</tt> to put y coordinate position.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   */
  void get_position(int& x, int& y, CoordType coord_type) const;
#endif // ATKMM_DISABLE_DEPRECATED


#ifndef ATKMM_DISABLE_DEPRECATED

  /** Gets the size of the @a component in terms of width and height.
   * 
   * Deprecated: Since 2.12. Use get_extents() instead.
   * 
   * @deprecated Use get_extents() instead.
   * 
   * @param width Address of <tt>int</tt> to put width of @a component.
   * @param height Address of <tt>int</tt> to put height of @a component.
   */
  void get_size(int& width, int& height) const;
#endif // ATKMM_DISABLE_DEPRECATED


  /** Gets the layer of the component.
   * 
   * @return An Atk::Layer which is the layer of the component.
   */
  Layer get_layer() const;
  
  /** Gets the zorder of the component. The value G_MININT will be returned 
   * if the layer of the component is not ATK_LAYER_MDI or ATK_LAYER_WINDOW.
   * 
   * @return A <tt>int</tt> which is the zorder of the component, i.e. the depth at 
   * which the component is shown in relation to other components in the same 
   * container.
   */
  int get_mdi_zorder() const;
  
  /** Grabs focus for this @a component.
   * 
   * @return <tt>true</tt> if successful, <tt>false</tt> otherwise.
   */
  bool grab_focus();
  
#ifndef ATKMM_DISABLE_DEPRECATED

  /** Remove the handler specified by @a handler_id from the list of
   * functions to be executed when this object receives focus events 
   * (in or out).
   * 
   * Deprecated: 2.9.4: If you need to track when an object gains or
   * lose the focus, use the Atk::Object::signal_state_change() "focused" notification instead.
   * 
   * @deprecated If you need to track when an object gains or lose the focus, use Atk::Object::signal_state_change() and check for focused notification instead.
   * 
   * @param handler_id The handler id of the focus handler to be removed
   * from @a component.
   */
  void remove_focus_handler(guint handler_id);
#endif // ATKMM_DISABLE_DEPRECATED


  /** Sets the extents of @a component.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param width Width to set for @a component.
   * @param height Height to set for @a component.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return <tt>true</tt> or <tt>false</tt> whether the extents were set or not.
   */
  bool set_extents(int x, int y, int width, int height, CoordType coord_type);
  
  /** Sets the postition of @a component.
   * 
   * @param x X coordinate.
   * @param y Y coordinate.
   * @param coord_type Specifies whether the coordinates are relative to the screen
   * or to the components top level window.
   * @return <tt>true</tt> or <tt>false</tt> whether or not the position was set or not.
   */
  bool set_position(int x, int y, CoordType coord_type);
  
  /** Set the size of the @a component in terms of width and height.
   * 
   * @param width Width to set for @a component.
   * @param height Height to set for @a component.
   * @return <tt>true</tt> or <tt>false</tt> whether the size was set or not.
   */
  bool set_size(int width, int height);

protected:
    virtual guint add_focus_handler_vfunc(AtkFocusHandler handler);

    virtual bool contains_vfunc(int x, int y, CoordType coord_type) const;


    virtual Glib::RefPtr<Atk::Object> get_accessible_at_point_vfunc(int x, int y, CoordType coord_type);


    virtual void get_extents_vfunc(int& x, int& y, int& width, int& height, CoordType coord_type) const;


  //deprecated:
    virtual void get_position_vfunc(int& x, int& y, CoordType coord_type) const;


  //deprecated:
    virtual void get_size_vfunc(int& width, int& height) const;


    virtual Layer get_layer_vfunc() const;

    virtual int get_mdi_zorder_vfunc() const;

    virtual bool grab_focus_vfunc();


  //deprecated:
    virtual void remove_focus_handler_vfunc(guint handler_id);


    virtual bool set_extents_vfunc(int x, int y, int width, int height, CoordType coord_type);

    virtual bool set_position_vfunc(int x, int y, CoordType coord_type);

    virtual bool set_size_vfunc(int width, int height);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Component
   */
  Glib::RefPtr<Atk::Component> wrap(AtkComponent* object, bool take_copy = false);

} // namespace Glib


#endif /* _ATKMM_COMPONENT_H */

