/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.WeakList;

public class Resource {
    private static final WeakList<Resource> resources = new WeakList();
    private final WeakList<ResourceTracker> trackers = new WeakList();
    private final URL location;
    private URL downloadLocation;
    private File localFile;
    private final Version requestVersion;
    private Version downloadVersion;
    private volatile long transferred = 0L;
    private volatile long size = -1L;
    private final EnumSet<Status> status = EnumSet.noneOf(Status.class);
    private final UpdatePolicy updatePolicy;
    private DownloadOptions downloadOptions;

    private Resource(URL location, Version requestVersion, UpdatePolicy updatePolicy) {
        this.location = location;
        this.downloadLocation = location;
        this.requestVersion = requestVersion;
        this.updatePolicy = updatePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResource(URL location, Version requestVersion, UpdatePolicy updatePolicy) {
        WeakList<Resource> weakList = resources;
        synchronized (weakList) {
            Resource result;
            Resource resource = new Resource(location, requestVersion, updatePolicy);
            int index = resources.indexOf(resource);
            if (index >= 0 && (result = resources.get(index)) != null) {
                return result;
            }
            resources.add(resource);
            resources.trimToSize();
            return resource;
        }
    }

    public URL getLocation() {
        return this.location;
    }

    public URL getDownloadLocation() {
        return this.downloadLocation;
    }

    public void setDownloadLocation(URL downloadLocation) {
        this.downloadLocation = downloadLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceTracker getTracker() {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            List<ResourceTracker> t = this.trackers.hardList();
            if (t.size() > 0) {
                return t.get(0);
            }
            return null;
        }
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    public Version getRequestVersion() {
        return this.requestVersion;
    }

    public Version getDownloadVersion() {
        return this.downloadVersion;
    }

    public void setDownloadVersion(Version downloadVersion) {
        this.downloadVersion = downloadVersion;
    }

    public long getTransferred() {
        return this.transferred;
    }

    public void setTransferred(long transferred) {
        this.transferred = transferred;
    }

    public void incrementTransferred(long incTrans) {
        this.transferred += incTrans;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Set<Status> getCopyOfStatus() {
        return EnumSet.copyOf(this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet(Status flag) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            return this.status.contains((Object)flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFlags(Collection<Status> flags) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            return this.status.containsAll(flags);
        }
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatusString() {
        StringBuilder result = new StringBuilder();
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            if (this.status.isEmpty()) {
                return "<>";
            }
            for (Status stat : this.status) {
                result.append(stat.toString()).append(" ");
            }
        }
        return result.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus(Collection<Status> clear, Collection<Status> add) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            if (clear != null) {
                this.status.removeAll(clear);
            }
            if (add != null) {
                this.status.addAll(add);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusFlag(Status flag) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            this.status.add(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusFlags(Collection<Status> flags) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            this.status.addAll(flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetStatusFlag(Collection<Status> flags) {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            this.status.removeAll(flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatus() {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            this.status.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        EnumSet<Status> enumSet = this.status;
        synchronized (enumSet) {
            return !this.status.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTracker(ResourceTracker tracker) {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            this.trackers.remove(tracker);
            this.trackers.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTracker(ResourceTracker tracker) {
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            List<ResourceTracker> t = this.trackers.hardList();
            if (!t.contains(tracker)) {
                this.trackers.add(tracker);
            }
            this.trackers.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDownloadEvent() {
        List<ResourceTracker> send;
        WeakList<ResourceTracker> weakList = this.trackers;
        synchronized (weakList) {
            send = this.trackers.hardList();
        }
        for (ResourceTracker rt : send) {
            rt.fireDownloadEvent(this);
        }
    }

    public void setDownloadOptions(DownloadOptions downloadOptions) {
        this.downloadOptions = downloadOptions;
    }

    public DownloadOptions getDownloadOptions() {
        return this.downloadOptions;
    }

    public boolean isConnectable() {
        return JNLPRuntime.isConnectable(this.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Resource) {
            return UrlUtils.urlEquals(this.location, ((Resource)other).location);
        }
        return false;
    }

    public String toString() {
        return "location=" + this.location.toString() + " state=" + this.getStatusString();
    }

    public static enum Status {
        PRECONNECT,
        CONNECTING,
        CONNECTED,
        PREDOWNLOAD,
        DOWNLOADING,
        DOWNLOADED,
        ERROR,
        PROCESSING;

    }
}

