/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.providers;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.internal.CachedRowSetReader;
import com.sun.rowset.internal.CachedRowSetWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;

public final class RIOptimisticProvider
extends SyncProvider
implements Serializable {
    private CachedRowSetReader reader;
    private CachedRowSetWriter writer;
    private String providerID = this.getClass().getName();
    private String vendorName = "Oracle Corporation";
    private String versionNumber = "1.0";
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = -3143367176751761936L;

    public RIOptimisticProvider() {
        this.reader = new CachedRowSetReader();
        this.writer = new CachedRowSetWriter();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public RowSetWriter getRowSetWriter() {
        try {
            this.writer.setReader(this.reader);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.writer;
    }

    @Override
    public RowSetReader getRowSetReader() {
        return this.reader;
    }

    @Override
    public int getProviderGrade() {
        return 2;
    }

    @Override
    public void setDataSourceLock(int datasource_lock) throws SyncProviderException {
        if (datasource_lock != 1) {
            throw new SyncProviderException(this.resBundle.handleGetObject("riop.locking").toString());
        }
    }

    @Override
    public int getDataSourceLock() throws SyncProviderException {
        return 1;
    }

    @Override
    public int supportsUpdatableView() {
        return 6;
    }

    @Override
    public String getVersion() {
        return this.versionNumber;
    }

    @Override
    public String getVendor() {
        return this.vendorName;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

