/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.data.CachingReportDataFactory;
import org.jfree.report.data.ExpressionDataRow;
import org.jfree.report.data.ExpressionSlot;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.ImportedVariablesDataRow;
import org.jfree.report.data.ParameterDataRow;
import org.jfree.report.data.PrecomputedValueRegistry;
import org.jfree.report.data.PrecomputedValueRegistryBuilder;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ParameterMapping;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.util.IntegerCache;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class DefaultFlowController
implements FlowController {
    private CachingReportDataFactory reportDataFactory;
    private GlobalMasterRow dataRow;
    private boolean advanceRequested;
    private FastStack reportStack;
    private FastStack markStack;
    private FastStack expressionsStack;
    private String exportDescriptor;
    private ReportContext reportContext;
    private ReportJob job;
    private PrecomputedValueRegistry precomputedValueRegistry;

    public DefaultFlowController(ReportContext reportContext, ReportJob reportJob) throws DataSourceException {
        if (reportJob == null) {
            throw new NullPointerException();
        }
        if (reportContext == null) {
            throw new NullPointerException();
        }
        this.reportContext = reportContext;
        this.job = reportJob;
        this.exportDescriptor = reportContext.getExportDescriptor();
        this.reportDataFactory = new CachingReportDataFactory(reportJob.getDataFactory());
        this.reportStack = new FastStack();
        this.markStack = new FastStack();
        this.expressionsStack = new FastStack();
        this.advanceRequested = false;
        this.dataRow = GlobalMasterRow.createReportRow(reportContext);
        this.dataRow.setParameterDataRow(new ParameterDataRow(reportJob.getParameters()));
        this.precomputedValueRegistry = new PrecomputedValueRegistryBuilder();
    }

    protected DefaultFlowController(DefaultFlowController defaultFlowController, GlobalMasterRow globalMasterRow) {
        this.reportContext = defaultFlowController.reportContext;
        this.job = defaultFlowController.job;
        this.exportDescriptor = defaultFlowController.exportDescriptor;
        this.reportDataFactory = defaultFlowController.reportDataFactory;
        this.reportStack = (FastStack)defaultFlowController.reportStack.clone();
        this.markStack = (FastStack)defaultFlowController.markStack.clone();
        this.expressionsStack = (FastStack)defaultFlowController.expressionsStack.clone();
        this.advanceRequested = defaultFlowController.advanceRequested;
        this.dataRow = globalMasterRow;
        this.precomputedValueRegistry = defaultFlowController.precomputedValueRegistry;
    }

    public FlowController performOperation(FlowControlOperation flowControlOperation) throws DataSourceException {
        if (flowControlOperation == FlowControlOperation.ADVANCE) {
            if (this.dataRow.isAdvanceable() && !this.advanceRequested) {
                DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
                defaultFlowController.advanceRequested = true;
                return defaultFlowController;
            }
        } else {
            if (flowControlOperation == FlowControlOperation.MARK) {
                DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
                defaultFlowController.markStack.push((Object)this.dataRow);
                return defaultFlowController;
            }
            if (flowControlOperation == FlowControlOperation.RECALL) {
                if (this.markStack.isEmpty()) {
                    return this;
                }
                DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
                defaultFlowController.dataRow = (GlobalMasterRow)defaultFlowController.markStack.pop();
                defaultFlowController.advanceRequested = false;
                return defaultFlowController;
            }
            if (flowControlOperation == FlowControlOperation.DONE) {
                DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
                defaultFlowController.markStack.pop();
                return defaultFlowController;
            }
            if (flowControlOperation == FlowControlOperation.COMMIT && this.isAdvanceRequested()) {
                DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
                defaultFlowController.dataRow = this.dataRow.advance();
                defaultFlowController.advanceRequested = false;
                return defaultFlowController;
            }
        }
        return this;
    }

    public GlobalMasterRow getMasterRow() {
        return this.dataRow;
    }

    public boolean isAdvanceRequested() {
        return this.advanceRequested;
    }

    public FlowController performQuery(String string) throws ReportDataFactoryException, DataSourceException {
        GlobalMasterRow globalMasterRow = GlobalMasterRow.createReportRow(this.dataRow, this.reportContext);
        globalMasterRow.setParameterDataRow(new ParameterDataRow(this.getReportJob().getParameters()));
        globalMasterRow.setReportDataRow(ReportDataRow.createDataRow(this.reportDataFactory, string, this.dataRow.getGlobalView()));
        DefaultFlowController defaultFlowController = new DefaultFlowController(this, globalMasterRow);
        defaultFlowController.reportStack.push((Object)new ReportDataContext(defaultFlowController.markStack, this.advanceRequested));
        defaultFlowController.markStack = new FastStack();
        defaultFlowController.dataRow = globalMasterRow;
        return defaultFlowController;
    }

    public FlowController performSubReportQuery(String string, ParameterMapping[] parameterMappingArray, ParameterMapping[] parameterMappingArray2) throws ReportDataFactoryException, DataSourceException {
        GlobalMasterRow globalMasterRow = this.dataRow.derive();
        GlobalMasterRow globalMasterRow2 = GlobalMasterRow.createReportRow(globalMasterRow, this.reportContext);
        globalMasterRow2.setParameterDataRow(new ParameterDataRow(parameterMappingArray, globalMasterRow.getGlobalView()));
        globalMasterRow2.setReportDataRow(ReportDataRow.createDataRow(this.reportDataFactory, string, globalMasterRow2.getGlobalView()));
        if (parameterMappingArray2 == null) {
            globalMasterRow.setExportedDataRow(new ImportedVariablesDataRow(globalMasterRow2));
        } else {
            globalMasterRow.setExportedDataRow(new ImportedVariablesDataRow(globalMasterRow2, parameterMappingArray2));
        }
        DefaultFlowController defaultFlowController = new DefaultFlowController(this, globalMasterRow2);
        defaultFlowController.reportStack.push((Object)new ReportDataContext(defaultFlowController.markStack, this.advanceRequested));
        defaultFlowController.markStack = new FastStack();
        defaultFlowController.dataRow = globalMasterRow2;
        return defaultFlowController;
    }

    public FlowController activateExpressions(ExpressionSlot[] expressionSlotArray) throws DataSourceException {
        if (expressionSlotArray.length == 0) {
            DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
            defaultFlowController.expressionsStack.push((Object)IntegerCache.getInteger(0));
            return defaultFlowController;
        }
        GlobalMasterRow globalMasterRow = this.dataRow.derive();
        ExpressionDataRow expressionDataRow = globalMasterRow.getExpressionDataRow();
        expressionDataRow.pushExpressions(expressionSlotArray);
        DefaultFlowController defaultFlowController = new DefaultFlowController(this, globalMasterRow);
        Integer n = IntegerCache.getInteger(expressionSlotArray.length);
        defaultFlowController.expressionsStack.push((Object)n);
        return defaultFlowController;
    }

    public FlowController deactivateExpressions() throws DataSourceException {
        Integer n = (Integer)this.expressionsStack.peek();
        int n2 = n;
        if (n2 == 0) {
            DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
            defaultFlowController.expressionsStack.pop();
            return defaultFlowController;
        }
        GlobalMasterRow globalMasterRow = this.dataRow.derive();
        ExpressionDataRow expressionDataRow = globalMasterRow.getExpressionDataRow();
        DefaultFlowController defaultFlowController = new DefaultFlowController(this, globalMasterRow);
        defaultFlowController.expressionsStack.pop();
        expressionDataRow.popExpressions(n2);
        return defaultFlowController;
    }

    public FlowController performReturnFromQuery() throws DataSourceException {
        DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow);
        ReportDataRow reportDataRow = this.dataRow.getReportDataRow();
        if (reportDataRow == null) {
            return this;
        }
        ReportDataContext reportDataContext = (ReportDataContext)defaultFlowController.reportStack.pop();
        defaultFlowController.dataRow = this.dataRow.getParentDataRow();
        defaultFlowController.dataRow = defaultFlowController.dataRow.derive();
        defaultFlowController.dataRow.setExportedDataRow(null);
        defaultFlowController.markStack = reportDataContext.getMarkStack();
        defaultFlowController.advanceRequested = reportDataContext.isAdvanceRequested();
        return defaultFlowController;
    }

    public ReportJob getReportJob() {
        return this.job;
    }

    public String getExportDescriptor() {
        return this.exportDescriptor;
    }

    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public ExpressionSlot[] getActiveExpressions() throws DataSourceException {
        return this.dataRow.getExpressionDataRow().getSlots();
    }

    public FlowController createPrecomputeInstance() throws DataSourceException {
        DefaultFlowController defaultFlowController = new DefaultFlowController(this, this.dataRow.derive());
        defaultFlowController.precomputedValueRegistry = new PrecomputedValueRegistryBuilder();
        return defaultFlowController;
    }

    public PrecomputedValueRegistry getPrecomputedValueRegistry() {
        return this.precomputedValueRegistry;
    }

    private static class ReportDataContext {
        private FastStack markStack;
        private boolean advanceRequested;

        public ReportDataContext(FastStack fastStack, boolean bl) {
            this.advanceRequested = bl;
            this.markStack = fastStack;
        }

        public boolean isAdvanceRequested() {
            return this.advanceRequested;
        }

        public FastStack getMarkStack() {
            return this.markStack;
        }
    }
}

