/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.io.FileReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class LoadFile
implements Runnable {
    Scriptable scope;
    String fileName;
    Main db;
    Reader reader = null;
    Object result = null;
    Exception exception = null;
    int lineNum = -1;
    boolean sfExecute = false;

    LoadFile(Main db, Scriptable scope, String fileName) {
        this.scope = scope;
        this.fileName = fileName;
        this.db = db;
    }

    LoadFile(Main db, Scriptable scope, String fileName, Reader reader) {
        this(db, scope, fileName);
        this.reader = reader;
    }

    LoadFile(Main db, Scriptable scope, String fileName, Reader reader, boolean sfExecute) {
        this(db, scope, fileName);
        this.reader = reader;
        this.sfExecute = sfExecute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.db.officeScripts.isScriptRunning(this.fileName)) {
            this.exception = new Exception("The script is already executing");
            if (!this.sfExecute) {
                MessageDialogWrapper.showMessageDialog(this.db, "Script already executing", "Run", 0);
            }
            return;
        }
        this.db.officeScripts.setScriptRunning(this.fileName, true);
        Context cx = Context.enter();
        ContextData contextData = ContextData.get(cx);
        contextData.breakNextLine = !this.sfExecute;
        try {
            this.result = cx.evaluateReader(this.scope, this.reader == null ? new FileReader(this.fileName) : this.reader, this.fileName, 1, null);
        }
        catch (Exception exc) {
            this.exception = exc;
            String msg = exc.getMessage();
            if (exc instanceof EcmaError) {
                EcmaError err = (EcmaError)exc;
                msg = err.getSourceName() + ", line " + err.getLineNumber() + ": " + msg;
                int lineNum = err.getLineNumber();
                if (!this.sfExecute) {
                    MessageDialogWrapper.showMessageDialog(this.db, msg, "Run", 0);
                }
            }
        }
        finally {
            this.db.officeScripts.setScriptRunning(this.fileName, false);
            cx.exit();
        }
    }
}

