/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.openide.util.lookup.NamedServiceDefinition;
import org.openide.util.lookup.implspi.AbstractServiceProviderProcessor;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public final class NamedServiceProcessor
extends AbstractServiceProviderProcessor {
    private static final String PATH = "META-INF/namedservices.index";
    private static Pattern reference = Pattern.compile("@([^/]+)\\(\\)");

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NamedServiceDefinition.class.getName());
        NamedServiceProcessor.searchAnnotations(hashSet, true);
        return hashSet;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Object object;
        TypeMirror typeMirror;
        Object object2;
        Object object3;
        for (Element object42 : roundEnvironment.getElementsAnnotatedWith(NamedServiceDefinition.class)) {
            Target target;
            Object classNotFoundException;
            object3 = object42.getAnnotation(NamedServiceDefinition.class);
            object2 = reference.matcher(object3.path());
            while (((Matcher)object2).find()) {
                classNotFoundException = NamedServiceProcessor.findAttribute(object42, ((Matcher)object2).group(1));
                if (classNotFoundException == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The path attribute contains '" + ((Matcher)object2).group(0) + "' reference, but there is no attribute named '" + ((Matcher)object2).group(1) + "'", object42);
                    continue;
                }
                TypeMirror typeMirror2 = classNotFoundException.getReturnType();
                typeMirror = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
                if (this.processingEnv.getTypeUtils().isAssignable(typeMirror2, typeMirror)) continue;
                object = this.processingEnv.getTypeUtils().getArrayType(typeMirror);
                if (this.processingEnv.getTypeUtils().isAssignable(typeMirror2, (TypeMirror)object)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The path attribute contains '" + ((Matcher)object2).group(0) + "' reference, but attribute '" + ((Matcher)object2).group(1) + "' does not return String or String[]", object42);
            }
            if (!object3.position().equals("-")) {
                classNotFoundException = NamedServiceProcessor.findAttribute(object42, object3.position());
                if (classNotFoundException == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The position attribute contains '" + object3.position() + "' but no such attribute found.", object42);
                } else if (!this.processingEnv.getTypeUtils().isSameType(this.processingEnv.getTypeUtils().getPrimitiveType(TypeKind.INT), classNotFoundException.getReturnType())) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The position attribute contains '" + object3.position() + "' but the attribute does not return int.", object42);
                }
            }
            if ((classNotFoundException = object42.getAnnotation(Retention.class)) == null || classNotFoundException.value() != RetentionPolicy.SOURCE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Please specify @Retention(RetentionPolicy.SOURCE) on this annotation", object42);
            }
            if ((target = object42.getAnnotation(Target.class)) == null || target.value().length != 1 || target.value()[0] != ElementType.TYPE) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Please specify @Target(ElementType.TYPE) on this annotation", object42);
            }
            this.register(object42, PATH);
        }
        HashSet hashSet = new HashSet();
        NamedServiceProcessor.searchAnnotations(hashSet, false);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            try {
                object2 = Class.forName((String)object3).asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
            for (Element element : roundEnvironment.getElementsAnnotatedWith((Class<? extends Annotation>)object2)) {
                typeMirror = element.getAnnotation(object2);
                object = ((Class)object2).getAnnotation(NamedServiceDefinition.class);
                int n = 0;
                for (Class<?> clazz : object.serviceType()) {
                    TypeMirror typeMirror3 = this.processingEnv.getTypeUtils().erasure(this.asType(clazz));
                    if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), typeMirror3)) continue;
                    ++n;
                    for (String string : this.findPath(object.path(), (Annotation)((Object)typeMirror))) {
                        this.register(element, (Class<? extends Annotation>)object2, typeMirror3, string, (int)this.findPosition(object.position(), (Annotation)((Object)typeMirror)), new String[0]);
                    }
                }
                if (n != 0) continue;
                StringBuilder stringBuilder = new StringBuilder();
                String string = "The type does not ";
                for (Class<?> clazz : object.serviceType()) {
                    stringBuilder.append(string);
                    if (clazz.isInterface()) {
                        stringBuilder.append("implement ").append(clazz.getCanonicalName());
                    } else {
                        stringBuilder.append("subclass ").append(clazz.getCanonicalName());
                    }
                    string = ", neither it does ";
                }
                stringBuilder.append('.');
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, stringBuilder.toString(), element);
            }
        }
        return true;
    }

    private TypeMirror asType(Class<?> clazz) {
        return this.processingEnv.getElementUtils().getTypeElement(clazz.getName()).asType();
    }

    /*
     * Unable to fully structure code
     */
    private List<String> findPath(String var1_1, Annotation var2_2) {
        var3_3 = new ArrayList<String>();
        var3_3.add(var1_1);
        while (true) {
            block3: for (var4_4 = 0; var4_4 < var3_3.size(); ++var4_4) {
                var5_5 = NamedServiceProcessor.reference.matcher((CharSequence)var3_3.get(var4_4));
                if (!var5_5.find()) continue;
                var6_6 = var5_5.group(1);
                try {
                    var7_7 = var2_2.getClass().getMethod(var6_6, new Class[0]).invoke((Object)var2_2, new Object[0]);
                }
                catch (Exception var8_9) {
                    throw new IllegalStateException(var6_6, var8_9);
                }
                if (var7_7 instanceof String) {
                    var3_3.set(var4_4, NamedServiceProcessor.substitute(var1_1, var5_5, (String)var7_7));
                    continue;
                }
                if (var7_7 instanceof String[]) {
                    var8_8 = (String[])var7_7;
                    var3_3.set(var4_4, NamedServiceProcessor.substitute(var1_1, var5_5, var8_8[0]));
                    var9_10 = 1;
                    while (true) {
                        if (var9_10 < var8_8.length) ** break;
                        continue block3;
                        var3_3.add(NamedServiceProcessor.substitute(var1_1, var5_5, var8_8[var9_10]));
                        ++var9_10;
                    }
                }
                throw new IllegalStateException("Wrong return value " + var7_7);
            }
            break;
        }
        return var3_3;
    }

    private Integer findPosition(String string, Annotation annotation) {
        if (string.length() == 1 && string.charAt(0) == '-') {
            try {
                return (Integer)annotation.getClass().getMethod("position", new Class[0]).invoke((Object)annotation, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return Integer.MAX_VALUE;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        try {
            return (Integer)annotation.getClass().getMethod(string, new Class[0]).invoke((Object)annotation, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static void searchAnnotations(Set<String> set, boolean bl) {
        try {
            Enumeration<URL> enumeration = NamedServiceProcessor.class.getClassLoader().getResources(PATH);
            while (enumeration.hasMoreElements()) {
                String string;
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).startsWith("#")) continue;
                    if (bl) {
                        string = string.replace('$', '.');
                    }
                    set.add(string);
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private static String substitute(String string, Matcher matcher, String string2) {
        return string.substring(0, matcher.start(0)) + string2 + string.substring(matcher.end(0));
    }

    private static ExecutableElement findAttribute(Element element, String string) {
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD || !element2.getSimpleName().contentEquals(string)) continue;
            return (ExecutableElement)element2;
        }
        return null;
    }
}

