/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.env.Environment;

final class Spawner
implements Closeable {
    private static final String PROGRAM_NAME = Constants.WINDOWS ? "controller.exe" : "controller";
    private static final String PLATFORM_NAME = Spawner.makePlatformName(Constants.OS_NAME, Constants.OS_ARCH);
    private static final String TMP_ENVVAR = "TMPDIR";
    private final List<Process> processes = new ArrayList<Process>();

    Spawner() {
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(() -> this.processes.stream().map(s -> s::destroy).iterator());
        }
        finally {
            this.processes.clear();
        }
    }

    void spawnNativePluginControllers(Environment environment) throws IOException {
        if (Files.exists(environment.pluginsFile(), new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(environment.pluginsFile());){
                for (Path plugin : stream) {
                    Path spawnPath = Spawner.makeSpawnPath(plugin);
                    if (!Files.isRegularFile(spawnPath, new LinkOption[0])) continue;
                    this.spawnNativePluginController(spawnPath, environment.tmpFile());
                }
            }
        }
    }

    private void spawnNativePluginController(Path spawnPath, Path tmpPath) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(spawnPath.toString());
        pb.environment().clear();
        pb.environment().put(TMP_ENVVAR, tmpPath.toString());
        this.processes.add(pb.start());
    }

    List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }

    static Path makeSpawnPath(Path plugin) {
        return plugin.resolve("platform").resolve(PLATFORM_NAME).resolve("bin").resolve(PROGRAM_NAME);
    }

    static String makePlatformName(String osName, String osArch) {
        String os = osName.toLowerCase(Locale.ROOT);
        if (os.startsWith("windows")) {
            os = "windows";
        } else if (os.equals("mac os x")) {
            os = "darwin";
        }
        String cpu = osArch.toLowerCase(Locale.ROOT);
        if (cpu.equals("amd64")) {
            cpu = "x86_64";
        } else if (cpu.equals("i386")) {
            cpu = "x86";
        }
        return os + "-" + cpu;
    }
}

