/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.locks.Lock;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.engine.EngineException;

public class ReleasableLock
implements Releasable {
    private final Lock lock;
    private final ThreadLocal<Boolean> holdingThreads;

    public ReleasableLock(Lock lock) {
        this.lock = lock;
        boolean useHoldingThreads = false;
        if (!$assertionsDisabled) {
            useHoldingThreads = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.holdingThreads = useHoldingThreads ? new ThreadLocal() : null;
    }

    @Override
    public void close() {
        this.lock.unlock();
        assert (this.removeCurrentThread());
    }

    public ReleasableLock acquire() throws EngineException {
        this.lock.lock();
        assert (this.addCurrentThread());
        return this;
    }

    private boolean addCurrentThread() {
        this.holdingThreads.set(true);
        return true;
    }

    private boolean removeCurrentThread() {
        this.holdingThreads.remove();
        return true;
    }

    public Boolean isHeldByCurrentThread() {
        if (this.holdingThreads == null) {
            throw new UnsupportedOperationException("asserts must be enabled");
        }
        Boolean b = this.holdingThreads.get();
        return b != null && b != false;
    }
}

