/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion2x.Completion090PostingsFormat;
import org.elasticsearch.search.suggest.completion2x.CompletionSuggestion;

public class CompletionSuggester
extends Suggester<CompletionSuggestionContext> {
    public static final CompletionSuggester INSTANCE = new CompletionSuggester();
    private static final ScoreComparator scoreComparator = new ScoreComparator();

    private CompletionSuggester() {
    }

    @Override
    protected Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CompletionSuggestionContext suggestionContext, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        if (suggestionContext.getFieldType() != null) {
            CompletionFieldMapper.CompletionFieldType fieldType = suggestionContext.getFieldType();
            CompletionSuggestion completionSuggestion = new CompletionSuggestion(name, suggestionContext.getSize());
            spare.copyUTF8Bytes(suggestionContext.getText());
            CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new Text(spare.toString()), 0, spare.length());
            completionSuggestion.addTerm(completionSuggestEntry);
            TopDocumentsCollector collector = new TopDocumentsCollector(suggestionContext.getSize());
            CompletionSuggester.suggest(searcher, suggestionContext.toQuery(), collector);
            int numResult = 0;
            for (TopSuggestDocs.SuggestScoreDoc suggestScoreDoc : collector.get().scoreLookupDocs()) {
                TopDocumentsCollector.SuggestDoc suggestDoc = (TopDocumentsCollector.SuggestDoc)suggestScoreDoc;
                Map<String, Set<CharSequence>> contexts = Collections.emptyMap();
                if (fieldType.hasContextMappings() && !suggestDoc.getContexts().isEmpty()) {
                    contexts = fieldType.getContextMappings().getNamedContexts(suggestDoc.getContexts());
                }
                if (numResult++ >= suggestionContext.getSize()) break;
                CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option(suggestDoc.doc, new Text(suggestDoc.key.toString()), suggestDoc.score, contexts);
                completionSuggestEntry.addOption(option);
            }
            return completionSuggestion;
        }
        if (suggestionContext.getFieldType2x() != null) {
            IndexReader indexReader = searcher.getIndexReader();
            org.elasticsearch.search.suggest.completion2x.CompletionSuggestion completionSuggestion = new org.elasticsearch.search.suggest.completion2x.CompletionSuggestion(name, suggestionContext.getSize());
            spare.copyUTF8Bytes(suggestionContext.getText());
            CompletionSuggestion.Entry completionSuggestEntry = new CompletionSuggestion.Entry(new Text(spare.toString()), 0, spare.length());
            completionSuggestion.addTerm(completionSuggestEntry);
            String fieldName = suggestionContext.getField();
            HashMap<String, CompletionSuggestion.Entry.Option> results = new HashMap<String, CompletionSuggestion.Entry.Option>(indexReader.leaves().size() * suggestionContext.getSize());
            for (LeafReaderContext atomicReaderContext : indexReader.leaves()) {
                Completion090PostingsFormat.CompletionTerms lookupTerms;
                Lookup lookup;
                LeafReader atomicReader = atomicReaderContext.reader();
                Terms terms = atomicReader.fields().terms(fieldName);
                if (!(terms instanceof Completion090PostingsFormat.CompletionTerms) || (lookup = (lookupTerms = (Completion090PostingsFormat.CompletionTerms)terms).getLookup(suggestionContext.getFieldType2x(), suggestionContext)) == null) continue;
                List lookupResults = lookup.lookup((CharSequence)spare.get(), false, suggestionContext.getSize());
                for (Lookup.LookupResult res : lookupResults) {
                    String key = res.key.toString();
                    float score = res.value;
                    CompletionSuggestion.Entry.Option value = (CompletionSuggestion.Entry.Option)results.get(key);
                    if (value == null) {
                        CompletionSuggestion.Entry.Option option = new CompletionSuggestion.Entry.Option(new Text(key), score, res.payload == null ? null : new BytesArray(res.payload));
                        results.put(key, option);
                        continue;
                    }
                    if (!(value.getScore() < score)) continue;
                    value.setScore(score);
                    value.setPayload(res.payload == null ? null : new BytesArray(res.payload));
                }
            }
            ArrayList options = new ArrayList(results.values());
            CollectionUtil.introSort(options, (Comparator)scoreComparator);
            int optionCount = Math.min(suggestionContext.getSize(), options.size());
            for (int i = 0; i < optionCount; ++i) {
                completionSuggestEntry.addOption((Suggest.Suggestion.Entry.Option)options.get(i));
            }
            return completionSuggestion;
        }
        return null;
    }

    private static void suggest(IndexSearcher searcher, CompletionQuery query, TopSuggestDocsCollector collector) throws IOException {
        query = (CompletionQuery)query.rewrite(searcher.getIndexReader());
        Weight weight = query.createWeight(searcher, collector.needsScores());
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            BulkScorer scorer = weight.bulkScorer(context);
            if (scorer == null) continue;
            try {
                scorer.score(collector.getLeafCollector(context), context.reader().getLiveDocs());
            }
            catch (CollectionTerminatedException collectionTerminatedException) {}
        }
    }

    private static final class TopDocumentsCollector
    extends TopSuggestDocsCollector {
        private final int num;
        private final SuggestDocPriorityQueue pq;
        private final Map<Integer, SuggestDoc> scoreDocMap;

        TopDocumentsCollector(int num) {
            super(1);
            this.num = num;
            this.scoreDocMap = new LinkedHashMap<Integer, SuggestDoc>(num);
            this.pq = new SuggestDocPriorityQueue(num);
        }

        public int getCountToCollect() {
            return this.num;
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.updateResults();
        }

        private void updateResults() {
            for (SuggestDoc suggestDoc : this.scoreDocMap.values()) {
                if (this.pq.insertWithOverflow((Object)suggestDoc) == suggestDoc) break;
            }
            this.scoreDocMap.clear();
        }

        public void collect(int docID, CharSequence key, CharSequence context, float score) throws IOException {
            if (this.scoreDocMap.containsKey(docID)) {
                SuggestDoc suggestDoc = this.scoreDocMap.get(docID);
                suggestDoc.add(key, context, score);
            } else if (this.scoreDocMap.size() <= this.num) {
                this.scoreDocMap.put(docID, new SuggestDoc(this.docBase + docID, key, context, score));
            } else {
                throw new CollectionTerminatedException();
            }
        }

        public TopSuggestDocs get() throws IOException {
            this.updateResults();
            TopSuggestDocs.SuggestScoreDoc[] suggestScoreDocs = this.pq.getResults();
            if (suggestScoreDocs.length > 0) {
                return new TopSuggestDocs(suggestScoreDocs.length, suggestScoreDocs, suggestScoreDocs[0].score);
            }
            return TopSuggestDocs.EMPTY;
        }

        private static final class SuggestDocPriorityQueue
        extends PriorityQueue<SuggestDoc> {
            SuggestDocPriorityQueue(int maxSize) {
                super(maxSize);
            }

            protected boolean lessThan(SuggestDoc a, SuggestDoc b) {
                if (a.score == b.score) {
                    int cmp = Lookup.CHARSEQUENCE_COMPARATOR.compare(a.key, b.key);
                    if (cmp == 0) {
                        return a.doc > b.doc;
                    }
                    return cmp > 0;
                }
                return a.score < b.score;
            }

            public SuggestDoc[] getResults() {
                int size = this.size();
                SuggestDoc[] res = new SuggestDoc[size];
                for (int i = size - 1; i >= 0; --i) {
                    res[i] = (SuggestDoc)((Object)this.pop());
                }
                return res;
            }
        }

        private static final class SuggestDoc
        extends TopSuggestDocs.SuggestScoreDoc {
            private List<TopSuggestDocs.SuggestScoreDoc> suggestScoreDocs;

            SuggestDoc(int doc, CharSequence key, CharSequence context, float score) {
                super(doc, key, context, score);
            }

            void add(CharSequence key, CharSequence context, float score) {
                if (this.suggestScoreDocs == null) {
                    this.suggestScoreDocs = new ArrayList<TopSuggestDocs.SuggestScoreDoc>(1);
                }
                this.suggestScoreDocs.add(new TopSuggestDocs.SuggestScoreDoc(this.doc, key, context, score));
            }

            public List<CharSequence> getKeys() {
                if (this.suggestScoreDocs == null) {
                    return Collections.singletonList(this.key);
                }
                ArrayList<CharSequence> keys = new ArrayList<CharSequence>(this.suggestScoreDocs.size() + 1);
                keys.add(this.key);
                for (TopSuggestDocs.SuggestScoreDoc scoreDoc : this.suggestScoreDocs) {
                    keys.add(scoreDoc.key);
                }
                return keys;
            }

            public List<CharSequence> getContexts() {
                if (this.suggestScoreDocs == null) {
                    if (this.context != null) {
                        return Collections.singletonList(this.context);
                    }
                    return Collections.emptyList();
                }
                ArrayList<CharSequence> contexts = new ArrayList<CharSequence>(this.suggestScoreDocs.size() + 1);
                contexts.add(this.context);
                for (TopSuggestDocs.SuggestScoreDoc scoreDoc : this.suggestScoreDocs) {
                    contexts.add(scoreDoc.context);
                }
                return contexts;
            }
        }
    }

    public static class ScoreComparator
    implements Comparator<CompletionSuggestion.Entry.Option> {
        @Override
        public int compare(CompletionSuggestion.Entry.Option o1, CompletionSuggestion.Entry.Option o2) {
            return Float.compare(o2.getScore(), o1.getScore());
        }
    }
}

