/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.VariableInitializer;

public class VariableDeclaration
extends AstNode {
    private List<VariableInitializer> variables = new ArrayList<VariableInitializer>();
    private boolean isStatement;

    public VariableDeclaration() {
        this.type = 122;
    }

    public VariableDeclaration(int n) {
        super(n);
        this.type = 122;
    }

    public VariableDeclaration(int n, int n2) {
        super(n, n2);
        this.type = 122;
    }

    public List<VariableInitializer> getVariables() {
        return this.variables;
    }

    public void setVariables(List<VariableInitializer> list) {
        this.assertNotNull(list);
        this.variables.clear();
        for (VariableInitializer variableInitializer : list) {
            this.addVariable(variableInitializer);
        }
    }

    public void addVariable(VariableInitializer variableInitializer) {
        this.assertNotNull(variableInitializer);
        this.variables.add(variableInitializer);
        variableInitializer.setParent(this);
    }

    @Override
    public Node setType(int n) {
        if (n != 122 && n != 154 && n != 153) {
            throw new IllegalArgumentException("invalid decl type: " + n);
        }
        return super.setType(n);
    }

    public boolean isVar() {
        return this.type == 122;
    }

    public boolean isConst() {
        return this.type == 154;
    }

    public boolean isLet() {
        return this.type == 153;
    }

    public boolean isStatement() {
        return this.isStatement;
    }

    public void setIsStatement(boolean bl) {
        this.isStatement = bl;
    }

    private String declTypeName() {
        return Token.typeToName(this.type).toLowerCase();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.declTypeName());
        stringBuilder.append(" ");
        this.printList(this.variables, stringBuilder);
        if (this.isStatement()) {
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (AstNode astNode : this.variables) {
                astNode.visit(nodeVisitor);
            }
        }
    }
}

