/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.json;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class JsonParser {
    private Context cx;
    private Scriptable scope;
    private int pos;
    private int length;
    private String src;

    public JsonParser(Context context, Scriptable scriptable) {
        this.cx = context;
        this.scope = scriptable;
    }

    public synchronized Object parseValue(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Input string may not be null");
        }
        this.pos = 0;
        this.length = string.length();
        this.src = string;
        Object object = this.readValue();
        this.consumeWhitespace();
        if (this.pos < this.length) {
            throw new ParseException("Expected end of stream at char " + this.pos);
        }
        return object;
    }

    private Object readValue() throws ParseException {
        this.consumeWhitespace();
        if (this.pos < this.length) {
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case 't': {
                    return this.readTrue();
                }
                case 'f': {
                    return this.readFalse();
                }
                case '\"': {
                    return this.readString();
                }
                case 'n': {
                    return this.readNull();
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber(c);
                }
            }
            throw new ParseException("Unexpected token: " + c);
        }
        throw new ParseException("Empty JSON string");
    }

    private Object readObject() throws ParseException {
        this.consumeWhitespace();
        Scriptable scriptable = this.cx.newObject(this.scope);
        if (this.pos < this.length && this.src.charAt(this.pos) == '}') {
            ++this.pos;
            return scriptable;
        }
        boolean bl = false;
        while (this.pos < this.length) {
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '}': {
                    if (!bl) {
                        throw new ParseException("Unexpected comma in object literal");
                    }
                    return scriptable;
                }
                case ',': {
                    if (!bl) {
                        throw new ParseException("Unexpected comma in object literal");
                    }
                    bl = false;
                    break;
                }
                case '\"': {
                    if (bl) {
                        throw new ParseException("Missing comma in object literal");
                    }
                    String string = this.readString();
                    this.consume(':');
                    Object object = this.readValue();
                    long l = ScriptRuntime.indexFromString(string);
                    if (l < 0L) {
                        scriptable.put(string, scriptable, object);
                    } else {
                        scriptable.put((int)l, scriptable, object);
                    }
                    bl = true;
                    break;
                }
                default: {
                    throw new ParseException("Unexpected token in object literal");
                }
            }
            this.consumeWhitespace();
        }
        throw new ParseException("Unterminated object literal");
    }

    private Object readArray() throws ParseException {
        this.consumeWhitespace();
        if (this.pos < this.length && this.src.charAt(this.pos) == ']') {
            ++this.pos;
            return this.cx.newArray(this.scope, 0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        while (this.pos < this.length) {
            char c = this.src.charAt(this.pos);
            switch (c) {
                case ']': {
                    if (!bl) {
                        throw new ParseException("Unexpected comma in array literal");
                    }
                    ++this.pos;
                    return this.cx.newArray(this.scope, arrayList.toArray());
                }
                case ',': {
                    if (!bl) {
                        throw new ParseException("Unexpected comma in array literal");
                    }
                    bl = false;
                    ++this.pos;
                    break;
                }
                default: {
                    if (bl) {
                        throw new ParseException("Missing comma in array literal");
                    }
                    arrayList.add(this.readValue());
                    bl = true;
                }
            }
            this.consumeWhitespace();
        }
        throw new ParseException("Unterminated array literal");
    }

    private String readString() throws ParseException {
        int n = this.pos;
        while (this.pos < this.length) {
            char c;
            if ((c = this.src.charAt(this.pos++)) <= '\u001f') {
                throw new ParseException("String contains control character");
            }
            if (c == '\\') break;
            if (c != '\"') continue;
            return this.src.substring(n, this.pos - 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        block12: while (this.pos < this.length) {
            assert (this.src.charAt(this.pos - 1) == '\\');
            stringBuilder.append(this.src, n, this.pos - 1);
            if (this.pos >= this.length) {
                throw new ParseException("Unterminated string");
            }
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '\"': {
                    stringBuilder.append('\"');
                    break;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    break;
                }
                case '/': {
                    stringBuilder.append('/');
                    break;
                }
                case 'b': {
                    stringBuilder.append('\b');
                    break;
                }
                case 'f': {
                    stringBuilder.append('\f');
                    break;
                }
                case 'n': {
                    stringBuilder.append('\n');
                    break;
                }
                case 'r': {
                    stringBuilder.append('\r');
                    break;
                }
                case 't': {
                    stringBuilder.append('\t');
                    break;
                }
                case 'u': {
                    if (this.length - this.pos < 5) {
                        throw new ParseException("Invalid character code: \\u" + this.src.substring(this.pos));
                    }
                    int n2 = this.fromHex(this.src.charAt(this.pos + 0)) << 12 | this.fromHex(this.src.charAt(this.pos + 1)) << 8 | this.fromHex(this.src.charAt(this.pos + 2)) << 4 | this.fromHex(this.src.charAt(this.pos + 3));
                    if (n2 < 0) {
                        throw new ParseException("Invalid character code: " + this.src.substring(this.pos, this.pos + 4));
                    }
                    this.pos += 4;
                    stringBuilder.append((char)n2);
                    break;
                }
                default: {
                    throw new ParseException("Unexpected character in string: '\\" + c + "'");
                }
            }
            n = this.pos;
            while (this.pos < this.length) {
                if ((c = this.src.charAt(this.pos++)) <= '\u001f') {
                    throw new ParseException("String contains control character");
                }
                if (c == '\\') continue block12;
                if (c != '\"') continue;
                stringBuilder.append(this.src, n, this.pos - 1);
                return stringBuilder.toString();
            }
        }
        throw new ParseException("Unterminated string literal");
    }

    private int fromHex(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'A' && c <= 'F' ? c - 65 + 10 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : -1));
    }

    private Number readNumber(char c) throws ParseException {
        String string;
        double d;
        int n;
        assert (c == '-' || c >= '0' && c <= '9');
        int n2 = this.pos - 1;
        if (c == '-' && ((c = this.nextOrNumberError(n2)) < '0' || c > '9')) {
            throw this.numberError(n2, this.pos);
        }
        if (c != '0') {
            this.readDigits();
        }
        if (this.pos < this.length && (c = this.src.charAt(this.pos)) == '.') {
            ++this.pos;
            c = this.nextOrNumberError(n2);
            if (c < '0' || c > '9') {
                throw this.numberError(n2, this.pos);
            }
            this.readDigits();
        }
        if (this.pos < this.length && ((c = this.src.charAt(this.pos)) == 'e' || c == 'E')) {
            ++this.pos;
            c = this.nextOrNumberError(n2);
            if (c == '-' || c == '+') {
                c = this.nextOrNumberError(n2);
            }
            if (c < '0' || c > '9') {
                throw this.numberError(n2, this.pos);
            }
            this.readDigits();
        }
        if ((double)(n = (int)(d = Double.parseDouble(string = this.src.substring(n2, this.pos)))) == d) {
            return n;
        }
        return d;
    }

    private ParseException numberError(int n, int n2) {
        return new ParseException("Unsupported number format: " + this.src.substring(n, n2));
    }

    private char nextOrNumberError(int n) throws ParseException {
        if (this.pos >= this.length) {
            throw this.numberError(n, this.length);
        }
        return this.src.charAt(this.pos++);
    }

    private void readDigits() {
        char c;
        while (this.pos < this.length && (c = this.src.charAt(this.pos)) >= '0' && c <= '9') {
            ++this.pos;
        }
    }

    private Boolean readTrue() throws ParseException {
        if (this.length - this.pos < 3 || this.src.charAt(this.pos) != 'r' || this.src.charAt(this.pos + 1) != 'u' || this.src.charAt(this.pos + 2) != 'e') {
            throw new ParseException("Unexpected token: t");
        }
        this.pos += 3;
        return Boolean.TRUE;
    }

    private Boolean readFalse() throws ParseException {
        if (this.length - this.pos < 4 || this.src.charAt(this.pos) != 'a' || this.src.charAt(this.pos + 1) != 'l' || this.src.charAt(this.pos + 2) != 's' || this.src.charAt(this.pos + 3) != 'e') {
            throw new ParseException("Unexpected token: f");
        }
        this.pos += 4;
        return Boolean.FALSE;
    }

    private Object readNull() throws ParseException {
        if (this.length - this.pos < 3 || this.src.charAt(this.pos) != 'u' || this.src.charAt(this.pos + 1) != 'l' || this.src.charAt(this.pos + 2) != 'l') {
            throw new ParseException("Unexpected token: n");
        }
        this.pos += 3;
        return null;
    }

    private void consumeWhitespace() {
        block3: while (this.pos < this.length) {
            char c = this.src.charAt(this.pos);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private void consume(char c) throws ParseException {
        char c2;
        this.consumeWhitespace();
        if (this.pos >= this.length) {
            throw new ParseException("Expected " + c + " but reached end of stream");
        }
        if ((c2 = this.src.charAt(this.pos++)) == c) {
            return;
        }
        throw new ParseException("Expected " + c + " found " + c2);
    }

    public static class ParseException
    extends Exception {
        static final long serialVersionUID = 4804542791749920772L;

        ParseException(String string) {
            super(string);
        }

        ParseException(Exception exception) {
            super(exception);
        }
    }
}

