/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionUtil;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jogamp.common.os.AndroidUtils;

public class JogampVersion {
    public static final Attributes.Name IMPLEMENTATION_BUILD = new Attributes.Name("Implementation-Build");
    public static final Attributes.Name IMPLEMENTATION_BRANCH = new Attributes.Name("Implementation-Branch");
    public static final Attributes.Name IMPLEMENTATION_COMMIT = new Attributes.Name("Implementation-Commit");
    private String packageName;
    private Manifest mf;
    private int hash;
    private Attributes mainAttributes;
    private Set<?> mainAttributeNames;
    private final String androidPackageVersionName;

    protected JogampVersion(String string, Manifest manifest) {
        this.packageName = string;
        this.mf = null != manifest ? manifest : new Manifest();
        this.hash = this.mf.hashCode();
        this.mainAttributes = this.mf.getMainAttributes();
        this.mainAttributeNames = this.mainAttributes.keySet();
        this.androidPackageVersionName = AndroidUtils.getPackageInfoVersionName(string);
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object object) {
        if (object instanceof JogampVersion) {
            return this.mf.equals(((JogampVersion)object).getManifest());
        }
        return false;
    }

    public final Manifest getManifest() {
        return this.mf;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getAttribute(Attributes.Name name) {
        return null != name ? (String)this.mainAttributes.get(name) : null;
    }

    public final String getAttribute(String string) {
        return this.getAttribute(this.getAttributeName(string));
    }

    public final Attributes.Name getAttributeName(String string) {
        for (Attributes.Name name : this.mainAttributeNames) {
            if (!name.toString().equals(string)) continue;
            return name;
        }
        return null;
    }

    public final Set<?> getAttributeNames() {
        return this.mainAttributeNames;
    }

    public final String getExtensionName() {
        if (null != this.androidPackageVersionName) {
            return this.packageName;
        }
        return this.getAttribute(Attributes.Name.EXTENSION_NAME);
    }

    public final String getImplementationBuild() {
        return this.getAttribute(GlueGenVersion.IMPLEMENTATION_BUILD);
    }

    public final String getImplementationBranch() {
        return this.getAttribute(GlueGenVersion.IMPLEMENTATION_BRANCH);
    }

    public final String getImplementationCommit() {
        return this.getAttribute(GlueGenVersion.IMPLEMENTATION_COMMIT);
    }

    public final String getImplementationTitle() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_TITLE);
    }

    public final String getImplementationVendor() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR);
    }

    public final String getImplementationVendorID() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
    }

    public final String getImplementationURL() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_URL);
    }

    public final String getImplementationVersion() {
        return this.getAttribute(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public final String getAndroidPackageVersionName() {
        return this.androidPackageVersionName;
    }

    public final String getSpecificationTitle() {
        return this.getAttribute(Attributes.Name.SPECIFICATION_TITLE);
    }

    public final String getSpecificationVendor() {
        return this.getAttribute(Attributes.Name.SPECIFICATION_VENDOR);
    }

    public final String getSpecificationVersion() {
        return this.getAttribute(Attributes.Name.SPECIFICATION_VERSION);
    }

    public final StringBuilder getFullManifestInfo(StringBuilder stringBuilder) {
        return VersionUtil.getFullManifestInfo(this.getManifest(), stringBuilder);
    }

    public StringBuilder getManifestInfo(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        String string = Platform.getNewline();
        stringBuilder.append("Package: ").append(this.getPackageName()).append(string);
        stringBuilder.append("Extension Name: ").append(this.getExtensionName()).append(string);
        stringBuilder.append("Specification Title: ").append(this.getSpecificationTitle()).append(string);
        stringBuilder.append("Specification Vendor: ").append(this.getSpecificationVendor()).append(string);
        stringBuilder.append("Specification Version: ").append(this.getSpecificationVersion()).append(string);
        stringBuilder.append("Implementation Title: ").append(this.getImplementationTitle()).append(string);
        stringBuilder.append("Implementation Vendor: ").append(this.getImplementationVendor()).append(string);
        stringBuilder.append("Implementation Vendor ID: ").append(this.getImplementationVendorID()).append(string);
        stringBuilder.append("Implementation URL: ").append(this.getImplementationURL()).append(string);
        stringBuilder.append("Implementation Version: ").append(this.getImplementationVersion()).append(string);
        stringBuilder.append("Implementation Build: ").append(this.getImplementationBuild()).append(string);
        stringBuilder.append("Implementation Branch: ").append(this.getImplementationBranch()).append(string);
        stringBuilder.append("Implementation Commit: ").append(this.getImplementationCommit()).append(string);
        if (null != this.getAndroidPackageVersionName()) {
            stringBuilder.append("Android Package Version: ").append(this.getAndroidPackageVersionName()).append(string);
        }
        return stringBuilder;
    }

    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("-----------------------------------------------------------------------------------------------------").append(Platform.getNewline());
        this.getManifestInfo(stringBuilder);
        stringBuilder.append("-----------------------------------------------------------------------------------------------------");
        return stringBuilder;
    }

    public String toString() {
        return this.toString(null).toString();
    }
}

