/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.arguments;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.DefaultValues;
import org.jetbrains.kotlin.cli.common.arguments.GradleOption;
import org.jetbrains.kotlin.cli.common.arguments.ValueDescription;
import org.jetbrains.kotlin.com.sampullara.cli.Argument;

public class K2JSCompilerArguments
extends CommonCompilerArguments {
    @GradleOption(value=DefaultValues.StringNullDefault.class)
    @Argument(value="output", description="Output file path")
    @ValueDescription(value="<path>")
    public String outputFile;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="no-stdlib", description="Don't use bundled Kotlin stdlib")
    public boolean noStdlib;
    @Argument(value="library-files", description="Path to zipped library sources or kotlin files separated by commas")
    @ValueDescription(value="<path[,]>")
    public String[] libraryFiles;
    @GradleOption(value=DefaultValues.BooleanFalseDefault.class)
    @Argument(value="source-map", description="Generate source map")
    public boolean sourceMap;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="meta-info", description="Generate metadata")
    public boolean metaInfo;
    @GradleOption(value=DefaultValues.BooleanTrueDefault.class)
    @Argument(value="kjsm", description="Generate kjsm-files (for creating libraries)")
    public boolean kjsm;
    @GradleOption(value=DefaultValues.JsEcmaVersions.class)
    @Argument(value="target", description="Generate JS files for specific ECMA version")
    @ValueDescription(value="{ v5 }")
    public String target;
    @GradleOption(value=DefaultValues.JsModuleKinds.class)
    @Argument(value="module-kind", description="Kind of a module generated by compiler")
    @ValueDescription(value="{ plain, amd, commonjs, umd }")
    public String moduleKind;
    @GradleOption(value=DefaultValues.JsMain.class)
    @Argument(value="main", description="Whether a main function should be called")
    @ValueDescription(value="{call,noCall}")
    @Nullable
    public String main;
    @Argument(value="output-prefix", description="Path to file which will be added to the beginning of output file")
    @ValueDescription(value="<path>")
    public String outputPrefix;
    @Argument(value="output-postfix", description="Path to file which will be added to the end of output file")
    @ValueDescription(value="<path>")
    public String outputPostfix;

    @Override
    @NotNull
    public String executableScriptFileName() {
        if ("kotlinc-js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments", "executableScriptFileName"));
        }
        return "kotlinc-js";
    }
}

