/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsConditional;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsFunctionScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNew;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsParameter;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import org.jetbrains.kotlin.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

class JsDataClassGenerator
extends DataClassMethodGenerator {
    private final TranslationContext context;
    private final List<? super JsPropertyInitializer> output;

    JsDataClassGenerator(KtClassOrObject klass, TranslationContext context, List<? super JsPropertyInitializer> output) {
        super(klass, context.bindingContext());
        this.context = context;
        this.output = output;
    }

    @Override
    public void generateComponentFunction(@NotNull FunctionDescriptor function2, @NotNull ValueParameterDescriptor parameter) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateComponentFunction"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateComponentFunction"));
        }
        PropertyDescriptor propertyDescriptor = this.context.bindingContext().get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
        assert (propertyDescriptor != null) : "Property descriptor is expected to be non-null";
        JsFunction functionObject = this.generateJsMethod(function2);
        JsNameRef returnExpression = JsAstUtils.pureFqn(this.context.getNameForDescriptor(propertyDescriptor), (JsExpression)JsLiteral.THIS);
        functionObject.getBody().getStatements().add(new JsReturn(returnExpression));
    }

    @Override
    public void generateCopyFunction(@NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateCopyFunction"));
        }
        if (constructorParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorParameters", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateCopyFunction"));
        }
        JsFunction functionObj = this.generateJsMethod(function2);
        assert (function2.getValueParameters().size() == constructorParameters.size());
        ArrayList<JsExpression> constructorArguments = new ArrayList<JsExpression>(constructorParameters.size());
        for (int i = 0; i < constructorParameters.size(); ++i) {
            JsExpressionImpl argumentValue;
            KtParameter constructorParam = constructorParameters.get(i);
            ValueParameterDescriptor parameterDescriptor = (ValueParameterDescriptor)BindingContextUtils.getNotNull(this.context.bindingContext(), BindingContext.VALUE_PARAMETER, constructorParam);
            PropertyDescriptor propertyDescriptor = BindingContextUtils.getNotNull(this.context.bindingContext(), BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameterDescriptor);
            JsName fieldName = this.context.getNameForDescriptor(propertyDescriptor);
            JsName paramName = this.context.getNameForDescriptor(parameterDescriptor);
            functionObj.getParameters().add(new JsParameter(paramName));
            JsNameRef parameterValue = new JsNameRef(paramName);
            if (!constructorParam.hasValOrVar()) {
                assert (!DescriptorUtilsKt.hasDefaultValue(function2.getValueParameters().get(i)));
                argumentValue = parameterValue;
            } else {
                JsBinaryOperation defaultCondition = JsAstUtils.equality(new JsNameRef(paramName), Namer.getUndefinedExpression());
                argumentValue = new JsConditional(defaultCondition, new JsNameRef(fieldName, (JsExpression)JsLiteral.THIS), parameterValue);
            }
            constructorArguments.add(argumentValue);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)function2.getContainingDeclaration();
        ClassConstructorDescriptor constructor = classDescriptor.getConstructors().iterator().next();
        JsNameRef constructorRef = this.context.getQualifiedReference(constructor);
        JsNew returnExpression = new JsNew(constructorRef, constructorArguments);
        if (this.context.shouldBeDeferred(constructor)) {
            this.context.deferConstructorCall(constructor, constructorArguments);
        }
        functionObj.getBody().getStatements().add(new JsReturn(returnExpression));
    }

    @Override
    public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateToStringMethod"));
        }
        if (classProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProperties", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateToStringMethod"));
        }
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsProgram jsProgram = this.context.program();
        JsBinaryOperation result2 = null;
        for (int i = 0; i < classProperties.size(); ++i) {
            String printName = classProperties.get(i).getName().asString();
            JsName name2 = this.context.getNameForDescriptor(classProperties.get(i));
            JsStringLiteral literal = jsProgram.getStringLiteral((i == 0 ? this.getClassDescriptor().getName() + "(" : ", ") + printName + "=");
            JsInvocation expr = new JsInvocation((JsExpression)this.context.namer().kotlin("toString"), new JsNameRef(name2, (JsExpression)JsLiteral.THIS));
            JsBinaryOperation component = JsAstUtils.sum(literal, expr);
            result2 = result2 == null ? component : JsAstUtils.sum(result2, component);
        }
        assert (result2 != null);
        result2 = JsAstUtils.sum(result2, jsProgram.getStringLiteral(")"));
        functionObj.getBody().getStatements().add(new JsReturn(result2));
    }

    @Override
    public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateHashCodeMethod"));
        }
        if (classProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProperties", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateHashCodeMethod"));
        }
        JsFunction functionObj = this.generateJsMethod(function2);
        JsProgram jsProgram = this.context.program();
        List<JsStatement> statements = functionObj.getBody().getStatements();
        JsName varName = functionObj.getScope().declareName("result");
        statements.add(new JsVars(new JsVars.JsVar(varName, JsNumberLiteral.ZERO)));
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name2 = this.context.getNameForDescriptor(propertyDescriptor);
            JsInvocation component = new JsInvocation((JsExpression)this.context.namer().kotlin("hashCode"), new JsNameRef(name2, (JsExpression)JsLiteral.THIS));
            JsBinaryOperation newHashValue = JsAstUtils.sum(JsAstUtils.mul(new JsNameRef(varName), jsProgram.getNumberLiteral(31)), component);
            JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(varName), new JsBinaryOperation(JsBinaryOperator.BIT_OR, newHashValue, jsProgram.getNumberLiteral(0)));
            statements.add(assignment.makeStmt());
        }
        statements.add(new JsReturn(new JsNameRef(varName)));
    }

    @Override
    public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateEqualsMethod"));
        }
        if (classProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProperties", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateEqualsMethod"));
        }
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsFunctionScope funScope = functionObj.getScope();
        JsName paramName = funScope.declareName("other");
        functionObj.getParameters().add(new JsParameter(paramName));
        JsBinaryOperation referenceEqual = JsAstUtils.equality(JsLiteral.THIS, new JsNameRef(paramName));
        JsBinaryOperation isNotNull = JsAstUtils.inequality(new JsNameRef(paramName), JsLiteral.NULL);
        JsBinaryOperation otherIsObject = JsAstUtils.typeOfIs(paramName.makeRef(), this.context.program().getStringLiteral("object"));
        JsBinaryOperation prototypeEqual = JsAstUtils.equality(new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), JsLiteral.THIS), new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsNameRef(paramName)));
        JsExpressionImpl fieldChain = null;
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name2 = this.context.getNameForDescriptor(propertyDescriptor);
            JsInvocation next = new JsInvocation((JsExpression)this.context.namer().kotlin("equals"), new JsNameRef(name2, (JsExpression)JsLiteral.THIS), new JsNameRef(name2, (JsExpression)new JsNameRef(paramName)));
            if (fieldChain == null) {
                fieldChain = next;
                continue;
            }
            fieldChain = JsAstUtils.and(fieldChain, next);
        }
        assert (fieldChain != null);
        JsBinaryOperation returnExpression = JsAstUtils.or(referenceEqual, JsAstUtils.and(isNotNull, JsAstUtils.and(otherIsObject, JsAstUtils.and(prototypeEqual, fieldChain))));
        functionObj.getBody().getStatements().add(new JsReturn(returnExpression));
    }

    private JsFunction generateJsMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/js/translate/declaration/JsDataClassGenerator", "generateJsMethod"));
        }
        JsName functionName = this.context.getNameForDescriptor(functionDescriptor);
        JsScope enclosingScope = this.context.scope();
        JsFunction functionObject = JsAstUtils.createFunctionWithEmptyBody(enclosingScope);
        JsPropertyInitializer initializer2 = new JsPropertyInitializer(functionName.makeRef(), functionObject);
        this.output.add(initializer2);
        return functionObject;
    }
}

