/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import javajs.util.JSJSONParser;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.gennbo.NBODialogConfig;
import org.gennbo.NBODialogModel;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBORequest;

abstract class NBODialogRun
extends NBODialogModel {
    protected static boolean ALLOW_SELECT_ALL = false;
    protected static final String[] RUN_KEYWORD_LIST = new String[]{"CMO: Bonding character of canonical MO's", "DIPOLE: Dipole moment analysis", "NBBP: Natural bond-bond polarizability indices", "NBCP: Natural bond critical point analysis", "NCE: Natural coulomb electrostatics analysis", "NCU: Natural cluster unit analysis", "NRT: Natural resonance theory analysis", "PLOT: Write files for orbital plotting", "STERIC: Natural steric analysis"};
    protected Box editBox;
    protected JRadioButton rbLocal;
    protected JRadioButton[] keywordButtons;
    protected JButton btnRun;
    protected JTextField tfJobName;
    JTextPane keywordTextPane;

    protected NBODialogRun(JFrame f) {
        super(f);
    }

    protected JPanel buildRunPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.getNewInputFileHandler(2);
        this.inputFileHandler.setBrowseEnabled(false);
        this.panel.add(NBODialogRun.createTitleBox(" Select Job ", new NBODialogConfig.HelpBtn("run_job_help.htm")));
        Box inputBox = this.createBorderBox(true);
        inputBox.add(this.createSourceBox());
        inputBox.add(this.inputFileHandler);
        inputBox.setMinimumSize(new Dimension(360, 80));
        inputBox.setPreferredSize(new Dimension(360, 80));
        inputBox.setMaximumSize(new Dimension(360, 80));
        this.panel.add(inputBox);
        this.panel.add(NBODialogRun.createTitleBox(" Choose $NBO Keywords ", new NBODialogConfig.HelpBtn("run_keywords_help.htm"))).setVisible(false);
        this.editBox = this.createBorderBox(true);
        this.editBox.setSize(new Dimension(350, 400));
        this.tfJobName = new JTextField();
        this.tfJobName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.doLogJobName(null);
            }
        });
        this.tfJobName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                NBODialogRun.this.doLogJobName(null);
            }
        });
        this.editBox.setVisible(false);
        this.panel.add(this.editBox);
        this.btnRun = new JButton("Run");
        this.btnRun.setFont(runButtonFont);
        this.btnRun.setVisible(false);
        this.btnRun.setEnabled(true);
        this.btnRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.doRunGenNBOJob("");
            }
        });
        this.panel.add(this.btnRun);
        if (this.inputFileHandler.tfExt.getText().equals("47")) {
            this.notifyLoad_r();
        }
        this.inputFileHandler.setBrowseEnabled(true);
        return this.panel;
    }

    private Box createSourceBox() {
        Box box = Box.createHorizontalBox();
        ButtonGroup bg = new ButtonGroup();
        this.rbLocal = new JRadioButton("Local");
        this.rbLocal.setSelected(true);
        this.rbLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.doLocalBtn();
            }
        });
        box.add(this.rbLocal);
        bg.add(this.rbLocal);
        JRadioButton btn = new JRadioButton("NBOrXiv");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.doArchiveButton();
            }
        });
        box.add(btn);
        bg.add(btn);
        btn = new JRadioButton("WebMO");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "http://www.webmo.net/demoserver/cgi-bin/webmo/jobmgr.cgi";
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception e1) {
                    NBODialogRun.this.alertError("Could not open WebMO");
                }
            }
        });
        box.add(btn);
        bg.add(btn);
        return box;
    }

    protected void doArchiveButton() {
        ArchiveViewer aView = new ArchiveViewer(this, "http://nbo6.chem.wisc.edu/jmol_nborxiv/");
        aView.setVisible(true);
    }

    protected void doLocalBtn() {
        this.inputFileHandler.setBrowseEnabled(true);
        if (this.modelOrigin != 4) {
            this.inputFileHandler.doFileBrowsePressed();
        }
    }

    protected void addNBOKeylist() {
        if (this.inputFileHandler.inputFile == null) {
            return;
        }
        Box jobNameOuterBox = Box.createVerticalBox();
        jobNameOuterBox.setSize(new Dimension(250, 75));
        Box selectBox = Box.createHorizontalBox();
        selectBox.setSize(new Dimension(250, 50));
        Box mainBox = Box.createVerticalBox();
        mainBox.setSize(new Dimension(250, 275));
        final JPanel mainMenuOptions = this.addMenuOption();
        mainBox.add(mainMenuOptions);
        final JPanel mainTextEditor = this.addTextOption();
        mainBox.add(mainTextEditor);
        this.editBox.removeAll();
        this.editBox.add(Box.createRigidArea(new Dimension(350, 0)));
        this.editBox.add(jobNameOuterBox);
        this.editBox.add(selectBox);
        this.editBox.add(mainBox);
        Box jobNameInnerBox = Box.createHorizontalBox();
        jobNameInnerBox.add(new JLabel("Jobname ")).setFont(nboFont);
        jobNameInnerBox.add(this.tfJobName).setMaximumSize(new Dimension(150, 30));
        jobNameInnerBox.setAlignmentX(0.5f);
        jobNameOuterBox.add(jobNameInnerBox);
        JLabel lab = new JLabel("(Plot files will be created with this name)");
        lab.setAlignmentX(0.5f);
        jobNameOuterBox.add(lab);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton btnMenuSelect = new JRadioButton("Menu Select");
        bg.add(btnMenuSelect);
        btnMenuSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainTextEditor.setVisible(false);
                mainMenuOptions.setVisible(true);
            }
        });
        JRadioButton btnTextEditor = new JRadioButton("Text Editor");
        btnTextEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mainMenuOptions.setVisible(false);
                NBODialogRun.this.doSetKeywordTextPane(NBODialogRun.this.getKeywordsFromButtons());
                mainTextEditor.setVisible(true);
            }
        });
        bg.add(btnTextEditor);
        selectBox.add(new JLabel("Keywords:  ")).setFont(nboFont);
        selectBox.add(btnMenuSelect);
        selectBox.add(btnTextEditor);
        mainTextEditor.setVisible(false);
        mainMenuOptions.setVisible(true);
        btnMenuSelect.doClick();
    }

    private JPanel addTextOption() {
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setPreferredSize(new Dimension(270, 240));
        textPanel.setMaximumSize(new Dimension(270, 240));
        textPanel.setAlignmentX(0.5f);
        this.keywordTextPane = new JTextPane();
        this.doSetKeywordTextPane(this.cleanNBOKeylist(this.inputFileHandler.read47File(false)[1], true));
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add(this.keywordTextPane);
        textPanel.add((Component)sp, "Center");
        JButton saveBtn = new JButton("Save Changes");
        saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.doRunSaveButton();
            }
        });
        textPanel.add((Component)saveBtn, "South");
        textPanel.setVisible(false);
        return textPanel;
    }

    protected void doRunSaveButton() {
        String[] tokens;
        String s = this.keywordTextPane.getText();
        String keywords = "";
        for (String x : tokens = PT.getTokens(PT.rep(PT.rep(s, "$NBO", ""), "$END", "").trim())) {
            String xuc = x.toUpperCase();
            if (xuc.indexOf("FILE=") < 0) {
                keywords = keywords + xuc + " ";
                continue;
            }
            this.tfJobName.setText(x.substring(x.indexOf("=") + 1));
        }
        String name = this.tfJobName.getText();
        this.inputFileHandler.update47File(name, keywords, false);
        this.addNBOKeylist();
        this.tfJobName.setText(name);
        this.editBox.repaint();
        this.editBox.revalidate();
    }

    private JPanel addMenuOption() {
        JPanel menuPanel = new JPanel();
        menuPanel.setPreferredSize(new Dimension(270, 240));
        menuPanel.setMaximumSize(new Dimension(270, 240));
        menuPanel.setLayout(new BoxLayout(menuPanel, 1));
        menuPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.keywordButtons = new JRadioButton[RUN_KEYWORD_LIST.length];
        String keywords = this.cleanNBOKeylist(this.inputFileHandler.read47File(false)[1], false);
        for (int i = 0; i < this.keywordButtons.length; ++i) {
            this.keywordButtons[i] = new JRadioButton(RUN_KEYWORD_LIST[i]);
            if (keywords.contains(RUN_KEYWORD_LIST[i].split(":")[0])) {
                this.keywordButtons[i].setSelected(true);
            }
            this.keywordButtons[i].setAlignmentX(0.0f);
            menuPanel.add(this.keywordButtons[i]);
            this.keywordButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialogRun.this.doLogKeywords(null);
                }
            });
        }
        JLabel lab2 = new JLabel("(Select one or more)");
        menuPanel.add(lab2);
        menuPanel.setAlignmentX(0.5f);
        menuPanel.setVisible(true);
        return menuPanel;
    }

    protected String cleanNBOKeylist(String params, boolean setJobNameTextField) {
        String[] tokens = PT.getTokens(PT.rep(PT.clean(params), "file=", "FILE="));
        String tmp = "";
        boolean haveJobName = false;
        setJobNameTextField &= this.tfJobName != null;
        for (String s : tokens) {
            if (s.length() <= 0) continue;
            if (s.contains("fILE=")) {
                if (haveJobName) continue;
                if (setJobNameTextField) {
                    this.tfJobName.setText(s.substring(s.indexOf("=") + 1));
                }
                haveJobName = true;
                continue;
            }
            if (tmp.length() + s.length() - tmp.lastIndexOf(sep) >= 80) {
                tmp = tmp + sep + " ";
            }
            tmp = tmp + s.toUpperCase() + " ";
        }
        if (setJobNameTextField && (this.tfJobName.getText().equals("") || !haveJobName)) {
            this.tfJobName.setText(this.inputFileHandler.jobStem);
        }
        return tmp.trim();
    }

    protected void doLogJobName(String name) {
        if (name == null) {
            name = this.tfJobName.getText().trim();
            this.tfJobName.setText(name);
        }
        this.logValue("Job: " + name);
    }

    protected void doLogKeywords(String keywords) {
        if (keywords == null) {
            keywords = this.getKeywordsFromButtons();
        }
        this.logValue("Keywords: " + keywords);
    }

    protected void doSetKeywordTextPane(String keywords) {
        this.keywordTextPane.setText(keywords);
    }

    protected void notifyLoad_r() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.doSetStructure("alpha");
        this.addNBOKeylist();
        for (Component c : this.panel.getComponents()) {
            c.setVisible(true);
        }
        this.editBox.getParent().setVisible(true);
        this.editBox.setVisible(true);
        this.doLogKeywords(null);
        this.repaint();
        this.revalidate();
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            JDialog d = new JDialog(this);
            d.setLayout(new BorderLayout());
            JTextPane tp = new JTextPane();
            d.add((Component)tp, "Center");
            d.setSize(new Dimension(500, 600));
            tp.setText(this.inputFileHandler.getFileData(NBOFileHandler.newNBOFile((File)newFile, (String)"nbo").toString()));
            d.setVisible(true);
        }
    }

    protected String getKeywordsFromButtons() {
        String keywords = " " + this.cleanNBOKeylist(this.cleanNBOKeylist(this.inputFileHandler.read47File(false)[1], false), false) + " ";
        if (this.keywordButtons == null) {
            return keywords;
        }
        for (int i = 0; i < this.keywordButtons.length; ++i) {
            String key = RUN_KEYWORD_LIST[i].substring(0, RUN_KEYWORD_LIST[i].indexOf(":"));
            keywords = PT.rep(keywords, " " + key + " ", " ");
            if (!this.keywordButtons[i].isSelected()) continue;
            keywords = keywords + key + " ";
        }
        return keywords;
    }

    public boolean retrieveFile(String s, String path) {
        int j;
        File f = null;
        if (path == null) {
            path = this.inputFileHandler.fileDir;
        }
        this.logCmd("retrieve " + s);
        String name = s.substring(s.lastIndexOf("/") + 1);
        path = path.endsWith("/") || path.endsWith("\\") ? path + name : path + (path.endsWith("\\") ? "\\" : "/") + name;
        f = new File(path);
        if (f.exists() && (j = JOptionPane.showConfirmDialog(null, "File " + f.getAbsolutePath() + " already exists, do you want to overwrite contents, along with its associated .nn and .nbo files?", "Warning", 0)) == 1) {
            return false;
        }
        try {
            String fileData = this.vwr.getAsciiFileOrNull(s);
            if (fileData == null) {
                this.logError("Error reading " + s);
                return false;
            }
            if (this.inputFileHandler.writeToFile(path, fileData)) {
                this.logInfo(f.getName() + " (" + fileData.length() + " bytes)", 4);
            } else {
                this.logError("Error writing to " + f);
            }
        }
        catch (Throwable e) {
            this.alertError("Error reading " + s + ": " + e);
        }
        this.modelOrigin = 4;
        this.inputFileHandler.setInputFile(f);
        this.modelOrigin = 4;
        this.rbLocal.doClick();
        this.modelOrigin = 3;
        return true;
    }

    protected void doRunGenNBOJob(String requiredKeyword) {
        String[] fileData;
        String jobName;
        if (this.jmolOptionNONBO) {
            this.alertRequiresNBOServe();
            return;
        }
        String newKeywords = this.getKeywordsFromButtons();
        this.inputFileHandler.jobStem = this.inputFileHandler.jobStem.trim();
        if (requiredKeyword.length() > 0 && this.tfJobName != null) {
            this.tfJobName.setText(this.inputFileHandler.jobStem);
        }
        String string = jobName = this.tfJobName == null ? this.inputFileHandler.jobStem : this.tfJobName.getText().trim();
        if (!jobName.equals(this.inputFileHandler.jobStem)) {
            int i = JOptionPane.showConfirmDialog(null, "Note: Plot files are being created with name \"" + jobName + "\", which does not match your file name \"" + this.inputFileHandler.jobStem + "\"\nTo continue, we must create a new .47 file \"" + jobName + ".47\" so that all files related to this job are under the same name. Continue?", "Warning", 0);
            if (i != 0) {
                return;
            }
            this.inputFileHandler.copyAndSwitch47FileTo(jobName);
        }
        for (String x : PT.getTokens(requiredKeyword)) {
            if (newKeywords.contains(" " + x + " ")) continue;
            newKeywords = newKeywords + x + " ";
        }
        if (!newKeywords.contains("PLOT")) {
            newKeywords = newKeywords + "PLOT";
        }
        if ((fileData = this.inputFileHandler.update47File(jobName = jobName.equals("") ? this.inputFileHandler.jobStem : jobName, newKeywords, true)) == null) {
            return;
        }
        SB sb = new SB();
        this.postAddGlobalC(sb, "PATH", this.inputFileHandler.inputFile.getParent());
        this.postAddGlobalC(sb, "JOBSTEM", this.inputFileHandler.jobStem);
        this.postAddGlobalC(sb, "ESS", "gennbo");
        this.postAddGlobalC(sb, "LABEL_1", "FILE=" + jobName);
        this.logCmd("RUN GenNBO FILE=" + jobName + " " + this.cleanNBOKeylist(fileData[1], false));
        this.postNBO_r(sb, 12, "Running GenNBO...");
    }

    private void postNBO_r(SB sb, final int mode, String statusMessage) {
        final NBORequest req = new NBORequest();
        req.set(new Runnable(){

            @Override
            public void run() {
                NBODialogRun.this.processNBO_r(req, mode);
            }
        }, statusMessage, new String[]{"r_cmd.txt", sb.toString()});
        this.nboService.postToNBO(req);
    }

    protected void processNBO_r(NBORequest req, int mode) {
        this.inputFileHandler.setInputFile(this.inputFileHandler.inputFile);
    }

    class ArchiveViewer
    extends JDialog
    implements ActionListener {
        private JScrollPane archivePanel;
        private JButton selectAll;
        private JButton download;
        private JCheckBox[] jcLinks;
        private JTextField tfPath;
        private String baseDir;

        public ArchiveViewer(NBODialogRun d, String url) {
            super((Dialog)d, "NBO Archive Files");
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth() / 2 - 250;
            int height = gd.getDisplayMode().getHeight() / 2 - 120;
            this.setLocation(width, height);
            this.setSize(new Dimension(500, 240));
            this.setLayout(new BorderLayout());
            this.setResizable(false);
            this.archivePanel = new JScrollPane();
            this.archivePanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)this.archivePanel, "Center");
            String[] links = this.getLinks(url);
            this.setLinks(links, null);
            Box bottom = Box.createHorizontalBox();
            this.tfPath = new JTextField(d.inputFileHandler.fileDir);
            bottom.add(new JLabel("  Download to: "));
            bottom.add(this.tfPath);
            if (ALLOW_SELECT_ALL) {
                this.selectAll = new JButton("Select All");
                this.selectAll.addActionListener(this);
                bottom.add(this.selectAll);
            }
            this.download = new JButton("Download");
            this.download.addActionListener(this);
            bottom.add(this.download);
            this.add((Component)bottom, "South");
        }

        private String[] getLinks(String baseDir) {
            String sep;
            String html;
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
            this.baseDir = baseDir;
            String fileList = NBODialogRun.this.inputFileHandler.getFileData(baseDir + "47files.txt");
            if (fileList == null) {
                html = NBODialogRun.this.inputFileHandler.getFileData(baseDir);
                sep = "<a";
            } else {
                if (fileList.indexOf("{") == 0 || fileList.indexOf("[") == 0) {
                    ArrayList list;
                    Map<String, Object> map = new JSJSONParser().parseMap(fileList, true);
                    ArrayList arrayList = list = map == null ? null : (ArrayList)map.get("47files");
                    if (list == null || list.size() == 0) {
                        return new String[0];
                    }
                    String ext = ((String)list.get(0)).indexOf(".47") >= 0 ? "" : ".47";
                    String[] a = list.toArray(new String[0]);
                    for (int i = 0; i < list.size(); ++i) {
                        a[i] = baseDir + (String)list.get(i) + ext;
                    }
                    return a;
                }
                html = PT.rep(fileList, "\r", "");
                sep = "\n";
            }
            ArrayList<String> files = new ArrayList<String>();
            String[] toks = html.split(sep);
            for (int i = 1; i < toks.length; ++i) {
                String file = PT.getQuotedAttribute(toks[i], "href");
                if (file == null || !file.endsWith(".47")) continue;
                files.add(file);
            }
            return files.toArray(new String[0]);
        }

        private void setLinks(String[] links, String startsWith) {
            this.jcLinks = new JCheckBox[links.length];
            JPanel filePanel = new JPanel(new FlowLayout());
            if (startsWith == null) {
                startsWith = "";
            }
            ButtonGroup bg = ALLOW_SELECT_ALL ? null : new ButtonGroup();
            for (int i = 0; i < links.length; i += 6) {
                Box box = Box.createVerticalBox();
                for (int j = 0; j < 6 && i + j < this.jcLinks.length; ++j) {
                    this.jcLinks[i + j] = new JCheckBox(links[i + j]);
                    if (bg != null) {
                        bg.add(this.jcLinks[i + j]);
                    }
                    this.jcLinks[i + j].setBackground(Color.white);
                    box.add(this.jcLinks[i + j]);
                }
                filePanel.add(box);
            }
            filePanel.setBackground(Color.white);
            this.archivePanel.getViewport().add(filePanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.selectAll) {
                int i;
                boolean didCheck = false;
                for (i = 0; i < this.jcLinks.length; ++i) {
                    if (this.jcLinks[i].isSelected()) continue;
                    didCheck = true;
                    this.jcLinks[i].setSelected(true);
                }
                if (!didCheck) {
                    for (i = 0; i < this.jcLinks.length; ++i) {
                        this.jcLinks[i].setSelected(false);
                    }
                }
                this.repaint();
            } else if (e.getSource() == this.download) {
                String s = null;
                for (int i = 0; i < this.jcLinks.length; ++i) {
                    if (!this.jcLinks[i].isSelected()) continue;
                    s = this.baseDir + this.jcLinks[i].getText();
                    break;
                }
                if (s == null) {
                    return;
                }
                this.setVisible(false);
                if (!NBODialogRun.this.retrieveFile(s, this.tfPath.getText())) {
                    this.setVisible(true);
                    return;
                }
                this.dispose();
            }
        }
    }
}

