/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class RelationDialogManager
extends WindowAdapter
implements LayerManager.LayerChangeListener {
    private static RelationDialogManager relationDialogManager;
    private final Map<DialogContext, RelationEditor> openDialogs = new HashMap<DialogContext, RelationEditor>();

    public static RelationDialogManager getRelationDialogManager() {
        if (relationDialogManager == null) {
            relationDialogManager = new RelationDialogManager();
            Main.getLayerManager().addLayerChangeListener(relationDialogManager);
        }
        return relationDialogManager;
    }

    public void register(OsmDataLayer osmDataLayer, Relation relation, RelationEditor relationEditor) {
        this.openDialogs.put(new DialogContext(osmDataLayer, Optional.ofNullable(relation).orElseGet(Relation::new)), relationEditor);
        relationEditor.addWindowListener(this);
    }

    public void updateContext(OsmDataLayer osmDataLayer, Relation relation, RelationEditor relationEditor) {
        Iterator<Map.Entry<DialogContext, RelationEditor>> iterator = this.openDialogs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DialogContext, RelationEditor> entry = iterator.next();
            if (!Objects.equals(entry.getValue(), relationEditor)) continue;
            iterator.remove();
            break;
        }
        this.openDialogs.put(new DialogContext(osmDataLayer, relation), relationEditor);
    }

    public void close(OsmDataLayer osmDataLayer, Relation relation) {
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        RelationEditor relationEditor = this.openDialogs.get(dialogContext);
        if (relationEditor != null) {
            relationEditor.setVisible(false);
        }
    }

    public boolean isOpenInEditor(OsmDataLayer osmDataLayer, Relation relation) {
        if (relation == null) {
            return false;
        }
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        return this.openDialogs.containsKey(dialogContext);
    }

    public RelationEditor getEditorForRelation(OsmDataLayer osmDataLayer, Relation relation) {
        if (relation == null) {
            return null;
        }
        DialogContext dialogContext = new DialogContext(osmDataLayer, relation);
        return this.openDialogs.get(dialogContext);
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        Layer layer = layerRemoveEvent.getRemovedLayer();
        if (!(layer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
        Iterator<Map.Entry<DialogContext, RelationEditor>> iterator = this.openDialogs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DialogContext, RelationEditor> entry = iterator.next();
            if (!entry.getKey().matchesLayer(osmDataLayer)) continue;
            RelationEditor relationEditor = entry.getValue();
            iterator.remove();
            relationEditor.setVisible(false);
            relationEditor.dispose();
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        RelationEditor relationEditor = (RelationEditor)windowEvent.getWindow();
        Iterator<Map.Entry<DialogContext, RelationEditor>> iterator = this.openDialogs.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!relationEditor.equals(iterator.next().getValue())) continue;
            iterator.remove();
            break;
        }
    }

    protected boolean hasEditorWithCloseUpperLeftCorner(Point point, RelationEditor relationEditor) {
        for (RelationEditor relationEditor2 : this.openDialogs.values()) {
            if (relationEditor2 == relationEditor) continue;
            Point point2 = relationEditor2.getLocation();
            if (point.x < point2.x - 5 || point2.x + 5 < point.x || point.y < point2.y - 5 || point2.y + 5 < point.y) continue;
            return true;
        }
        return false;
    }

    public void positionOnScreen(RelationEditor relationEditor) {
        if (relationEditor == null) {
            return;
        }
        if (!this.openDialogs.isEmpty()) {
            Point point = relationEditor.getLocation();
            while (this.hasEditorWithCloseUpperLeftCorner(point, relationEditor)) {
                point.x += 20;
                point.y += 20;
            }
            relationEditor.setLocation(point);
        }
    }

    private static class DialogContext {
        public final Relation relation;
        public final OsmDataLayer layer;

        DialogContext(OsmDataLayer osmDataLayer, Relation relation) {
            this.layer = osmDataLayer;
            this.relation = relation;
        }

        public int hashCode() {
            return Objects.hash(this.relation, this.layer);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DialogContext dialogContext = (DialogContext)object;
            return Objects.equals(this.relation, dialogContext.relation) && Objects.equals(this.layer, dialogContext.layer);
        }

        public boolean matchesLayer(OsmDataLayer osmDataLayer) {
            if (osmDataLayer == null) {
                return false;
            }
            return this.layer.equals(osmDataLayer);
        }

        public String toString() {
            return "[Context: layer=" + this.layer.getName() + ",relation=" + this.relation.getId() + ']';
        }
    }
}

