/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.GlobalVariableStorage;
import org.jruby.truffle.language.globals.WriteGlobalVariableNode;

@GeneratedBy(value=WriteGlobalVariableNode.class)
public final class WriteGlobalVariableNodeGen
extends WriteGlobalVariableNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeWriteAssumeConstant_;
    @Node.Child
    private BaseNode_ specialization_;

    private WriteGlobalVariableNodeGen(String name, RubyNode value) {
        super(name);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static WriteGlobalVariableNode create(String name, RubyNode value) {
        return new WriteGlobalVariableNodeGen(name, value);
    }

    @GeneratedBy(methodName="write(Object, GlobalVariableStorage)", value=WriteGlobalVariableNode.class)
    private static final class WriteNode_
    extends BaseNode_ {
        private final GlobalVariableStorage storage;

        WriteNode_(WriteGlobalVariableNodeGen root, GlobalVariableStorage storage) {
            super(root, 3);
            this.storage = storage;
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            assert (this.root.workaround());
            assert (!this.storage.isAssumeConstant());
            return this.root.write(valueValue, this.storage);
        }

        static BaseNode_ create(WriteGlobalVariableNodeGen root, GlobalVariableStorage storage) {
            return new WriteNode_(root, storage);
        }
    }

    @GeneratedBy(methodName="writeAssumeConstant(Object, GlobalVariableStorage)", value=WriteGlobalVariableNode.class)
    private static final class WriteAssumeConstantNode_
    extends BaseNode_ {
        private final GlobalVariableStorage storage;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        WriteAssumeConstantNode_(WriteGlobalVariableNodeGen root, GlobalVariableStorage storage, Assumption assumption0_) {
            super(root, 2);
            this.storage = storage;
            this.assumption0_ = assumption0_;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            if (newNode.getClass() == WriteNode_.class) {
                this.removeSame("Contained by write(Object, GlobalVariableStorage)");
            }
            return super.merge(newNode, frameValue, valueValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            try {
                WriteAssumeConstantNode_.check(this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return this.removeThis((CharSequence)"Assumption [assumption0] invalidated", (Frame)frameValue, valueValue);
            }
            assert (this.storage.isAssumeConstant());
            return this.root.writeAssumeConstant(valueValue, this.storage);
        }

        static BaseNode_ create(WriteGlobalVariableNodeGen root, GlobalVariableStorage storage, Assumption assumption0_) {
            return new WriteAssumeConstantNode_(root, storage, assumption0_);
        }
    }

    @GeneratedBy(methodName="writeTryToKeepConstant(Object, GlobalVariableStorage, Object)", value=WriteGlobalVariableNode.class)
    private static final class WriteTryToKeepConstantNode_
    extends BaseNode_ {
        private final GlobalVariableStorage storage;
        private final Object previousValue;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        WriteTryToKeepConstantNode_(WriteGlobalVariableNodeGen root, GlobalVariableStorage storage, Object previousValue, Assumption assumption0_) {
            super(root, 1);
            this.storage = storage;
            this.previousValue = previousValue;
            this.assumption0_ = assumption0_;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object valueValue) {
            return this.root.referenceEqualNode.executeReferenceEqual(valueValue, this.previousValue);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            try {
                WriteTryToKeepConstantNode_.check(this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return this.removeThis((CharSequence)"Assumption [assumption0] invalidated", (Frame)frameValue, valueValue);
            }
            if (this.root.referenceEqualNode.executeReferenceEqual(valueValue, this.previousValue)) {
                return this.root.writeTryToKeepConstant(valueValue, this.storage, this.previousValue);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(WriteGlobalVariableNodeGen root, GlobalVariableStorage storage, Object previousValue, Assumption assumption0_) {
            return new WriteTryToKeepConstantNode_(root, storage, previousValue, assumption0_);
        }
    }

    @GeneratedBy(value=WriteGlobalVariableNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(WriteGlobalVariableNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(WriteGlobalVariableNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=WriteGlobalVariableNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(WriteGlobalVariableNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            return this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(WriteGlobalVariableNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=WriteGlobalVariableNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected WriteGlobalVariableNodeGen root;

        BaseNode_(WriteGlobalVariableNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (WriteGlobalVariableNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.execute_((VirtualFrame)frameValue, valueValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.execute_(frameValue, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            Assumption assumption0_2;
            BaseNode_ s;
            Assumption assumption0_1;
            GlobalVariableStorage storage1 = this.root.getStorage();
            Object previousValue1 = storage1.getValue();
            if (this.root.referenceEqualNode.executeReferenceEqual(valueValue, previousValue1) && BaseNode_.isValid(assumption0_1 = storage1.getUnchangedAssumption()) && this.countSame(s = WriteTryToKeepConstantNode_.create(this.root, storage1, previousValue1, assumption0_1)) < 3) {
                return s;
            }
            GlobalVariableStorage storage2 = this.root.getStorage();
            if (storage2.isAssumeConstant() && !this.root.excludeWriteAssumeConstant_ && BaseNode_.isValid(assumption0_2 = storage2.getUnchangedAssumption())) {
                return WriteAssumeConstantNode_.create(this.root, storage2, assumption0_2);
            }
            GlobalVariableStorage storage3 = this.root.getStorage();
            if (this.root.workaround() && !storage3.isAssumeConstant()) {
                this.root.excludeWriteAssumeConstant_ = true;
                return WriteNode_.create(this.root, storage3);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

