/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenEntry;

public class KtWhenExpression
extends KtExpressionImpl {
    public KtWhenExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtWhenExpression", "<init>"));
        }
        super(node);
    }

    @NotNull
    public List<KtWhenEntry> getEntries() {
        List<KtWhenEntry> list2 = this.findChildrenByType(KtNodeTypes.WHEN_ENTRY);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtWhenExpression", "getEntries"));
        }
        return list2;
    }

    @Nullable
    public KtExpression getSubjectExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtWhenExpression", "accept"));
        }
        return visitor2.visitWhenExpression(this, data);
    }

    @NotNull
    public PsiElement getWhenKeyword() {
        Object t = this.findChildByType(KtTokens.WHEN_KEYWORD);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtWhenExpression", "getWhenKeyword"));
        }
        return t;
    }

    @Nullable
    public PsiElement getCloseBrace() {
        return this.findChildByType(KtTokens.RBRACE);
    }

    @Nullable
    public PsiElement getOpenBrace() {
        return this.findChildByType(KtTokens.LBRACE);
    }

    @Nullable
    public PsiElement getLeftParenthesis() {
        return this.findChildByType(KtTokens.LPAR);
    }

    @Nullable
    public PsiElement getRightParenthesis() {
        return this.findChildByType(KtTokens.RPAR);
    }

    @Nullable
    public KtExpression getElseExpression() {
        for (KtWhenEntry entry : this.getEntries()) {
            if (!entry.isElse()) continue;
            return entry.getExpression();
        }
        return null;
    }
}

