// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_FileNode_HeaderFile
#define _OSD_FileNode_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <OSD_Path.hxx>
#include <OSD_Error.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
class OSD_OSDError;
class Standard_ProgramError;
class OSD_Path;
class OSD_Protection;
class Quantity_Date;


//! A class for 'File' and 'Directory' grouping common
//! methods (file/directory manipulation tools).
//! The "file oriented" name means files or directories which are
//! in fact hard coded as files.
class OSD_FileNode 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Gets file name and path.
  Standard_EXPORT   void Path (OSD_Path& Name)  const;
  
  //! Sets file name and path.
  //! If a name is not found, it raises a program error.
  Standard_EXPORT   void SetPath (const OSD_Path& Name) ;
  
  //! Returns TRUE if <me> exists.
  Standard_EXPORT   Standard_Boolean Exists() ;
  
  //! Erases the FileNode from directory
  Standard_EXPORT   void Remove() ;
  
  //! Moves <me> into another directory
  Standard_EXPORT   void Move (const OSD_Path& NewPath) ;
  
  //! Copies <me> to another FileNode
  Standard_EXPORT   void Copy (const OSD_Path& ToPath) ;
  
  //! Returns access mode of <me>.
  Standard_EXPORT   OSD_Protection Protection() ;
  
  //! Changes protection of the FileNode
  Standard_EXPORT   void SetProtection (const OSD_Protection& Prot) ;
  
  //! Returns last write access.
  //! On UNIX, AccessMoment and CreationMoment return the
  //! same value.
  Standard_EXPORT   Quantity_Date AccessMoment() ;
  
  //! Returns creation date.
  //! On UNIX, AccessMoment and CreationMoment return the
  //! same value.
  Standard_EXPORT   Quantity_Date CreationMoment() ;
  
  //! Returns User Identification.
  Standard_EXPORT   Standard_Integer UserId() ;
  
  //! Returns Group Identification.
  Standard_EXPORT   Standard_Integer GroupId() ;
  
  //! Returns TRUE if an error occurs
  Standard_EXPORT   Standard_Boolean Failed()  const;
  
  //! Resets error counter to zero
  Standard_EXPORT   void Reset() ;
  
  //! Raises OSD_Error
  Standard_EXPORT   void Perror() ;
  
  //! Returns error number if 'Failed' is TRUE.
  Standard_EXPORT   Standard_Integer Error()  const;




protected:

  
  //! Creates FileNode object
  //! This is to be used with SetPath .
  //! Allocate space for the file name and initializes this
  //! name to an empty name.
  Standard_EXPORT OSD_FileNode();
  
  //! Instantiates the object FileNode storing its name.
  //! If a name is not found, it raises a program error.
  Standard_EXPORT OSD_FileNode(const OSD_Path& Name);


  OSD_Path myPath;
  OSD_Error myError;


private:





};







#endif // _OSD_FileNode_HeaderFile
