"""
 @file
 @brief This file loads the custom ffmpeg command dialog (i.e create custom presets)
 @author Jonathan Thomas <jonathan@openshot.org>
 @author Olivier Girard <olivier@openshot.org>

 @section LICENSE

 Copyright (c) 2008-2016 OpenShot Studios, LLC
 (http://www.openshotstudios.com). This file is part of
 OpenShot Video Editor (http://www.openshot.org), an open-source project
 dedicated to delivering high quality video editing and animation solutions
 to the world.

 OpenShot Video Editor is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OpenShot Video Editor is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with OpenShot Library.  If not, see <http://www.gnu.org/licenses/>.
 """

import os

from PyQt5.QtWidgets import *

from classes import info, ui_util
from classes.app import get_app


class Presets(QDialog):
    """ Presets Dialog """

    # Path to ui file
    ui_path = os.path.join(info.PATH, 'windows', 'ui', 'presets.ui')

    def __init__(self):
        # Create dialog class
        QDialog.__init__(self)

        # Load UI from designer
        ui_util.load_ui(self, self.ui_path)

        # Init UI
        ui_util.init_ui(self)

        # get translations
        app = get_app()
        _ = app._tr

        ##set even handlers
        self.cmbpresets.activated.connect(self.load_presets_list)
        self.btnclearpreset.clicked.connect(self.delete_preset)
        self.btnsavecurrent.clicked.connect(self.save_current_preset)

    def load_presets_list(self):
        """ Display presets list """
        # log.info('The preset {} has been used'.format(name))
        pass

    def delete_preset(self):
        """ Delete the preset which has been previously created """
        # log.info('The preset {} has been deleted'.format(name))
        pass

    def save_current_preset(self):
        """ Save this new preset """
        # log.info('The preset {} has been created'.format(name))
        pass
