/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.AntBuilder;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDetector;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpecFactory;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.cache.CompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.LocalClassSetAnalysisStore;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarClasspathSnapshotStore;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.cache.CacheRepository;
import org.gradle.internal.Factory;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.platform.base.Platform;
import org.gradle.util.DeprecationLogger;

@ParallelizableTask
@CacheableTask
public class JavaCompile
extends AbstractCompile {
    private File dependencyCacheDir;
    private final CompileOptions compileOptions = new CompileOptions();

    public JavaCompile() {
        this.getOutputs().doNotCacheIf("Use depend is enabled", (Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return (Boolean)DeprecationLogger.whileDisabled((Factory)new Factory<Boolean>(){

                    public Boolean create() {
                        return JavaCompile.this.compileOptions.isUseDepend();
                    }
                });
            }
        });
    }

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public FileTree getSource() {
        return super.getSource();
    }

    @Incubating
    @Inject
    public JavaToolChain getToolChain() {
        throw new UnsupportedOperationException();
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        if (!this.compileOptions.isIncremental()) {
            this.compile();
            return;
        }
        DefaultJavaCompileSpec spec = this.createSpec();
        CompileCaches compileCaches = this.createCompileCaches();
        IncrementalCompilerFactory factory = new IncrementalCompilerFactory(this.getFileOperations(), (FileHasher)this.getCachingFileHasher(), this.getPath(), this.createCompiler(spec), this.source, compileCaches, (IncrementalTaskInputsInternal)inputs, this.getEffectiveAnnotationProcessorPath());
        Compiler<JavaCompileSpec> compiler = factory.createCompiler();
        this.performCompilation(spec, compiler);
    }

    private CompileCaches createCompileCaches() {
        final GeneralCompileCaches generalCaches = this.getGeneralCompileCaches();
        final LocalClassSetAnalysisStore localClassSetAnalysisStore = generalCaches.createLocalClassSetAnalysisStore(this.getPath());
        final LocalJarClasspathSnapshotStore localJarClasspathSnapshotStore = generalCaches.createLocalJarClasspathSnapshotStore(this.getPath());
        return new CompileCaches(){

            @Override
            public ClassAnalysisCache getClassAnalysisCache() {
                return generalCaches.getClassAnalysisCache();
            }

            @Override
            public JarSnapshotCache getJarSnapshotCache() {
                return generalCaches.getJarSnapshotCache();
            }

            @Override
            public LocalJarClasspathSnapshotStore getLocalJarClasspathSnapshotStore() {
                return localJarClasspathSnapshotStore;
            }

            @Override
            public LocalClassSetAnalysisStore getLocalClassSetAnalysisStore() {
                return localClassSetAnalysisStore;
            }
        };
    }

    @Inject
    protected CachingFileHasher getCachingFileHasher() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected GeneralCompileCaches getGeneralCompileCaches() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CacheRepository getCacheRepository() {
        throw new UnsupportedOperationException();
    }

    protected void compile() {
        DefaultJavaCompileSpec spec = this.createSpec();
        this.performCompilation(spec, this.createCompiler(spec));
    }

    @Inject
    protected Factory<AntBuilder> getAntBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    private CleaningJavaCompiler createCompiler(JavaCompileSpec spec) {
        Compiler javaCompiler = CompilerUtil.castCompiler((Compiler)((JavaToolChainInternal)this.getToolChain()).select((Platform)this.getPlatform()).newCompiler(spec.getClass()));
        return new CleaningJavaCompiler((Compiler<JavaCompileSpec>)javaCompiler, this.getAntBuilderFactory(), this.getOutputs());
    }

    @Nested
    protected JavaPlatform getPlatform() {
        return DefaultJavaPlatform.current();
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = compiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private DefaultJavaCompileSpec createSpec() {
        DefaultJavaCompileSpec spec = (DefaultJavaCompileSpec)new DefaultJavaCompileSpecFactory(this.compileOptions).create();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setCompileClasspath((List)ImmutableList.copyOf((Iterable)this.getClasspath()));
        spec.setAnnotationProcessorPath((List<File>)ImmutableList.copyOf((Iterable)this.getEffectiveAnnotationProcessorPath()));
        File dependencyCacheDir = (File)DeprecationLogger.whileDisabled((Factory)new Factory<File>(){

            public File create() {
                return JavaCompile.this.getDependencyCacheDir();
            }
        });
        spec.setDependencyCacheDir(dependencyCacheDir);
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setCompileOptions(this.compileOptions);
        return spec;
    }

    @Internal
    @Deprecated
    public File getDependencyCacheDir() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"JavaCompile.getDependencyCacheDir()");
        return this.dependencyCacheDir;
    }

    @Deprecated
    public void setDependencyCacheDir(File dependencyCacheDir) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"JavaCompile.setDependencyCacheDir()");
        this.dependencyCacheDir = dependencyCacheDir;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return super.getClasspath();
    }

    @Incubating
    @Classpath
    public FileCollection getEffectiveAnnotationProcessorPath() {
        AnnotationProcessorDetector annotationProcessorDetector = (AnnotationProcessorDetector)this.getServices().get(AnnotationProcessorDetector.class);
        return annotationProcessorDetector.getEffectiveAnnotationProcessorClasspath(this.compileOptions, this.getClasspath());
    }
}

