/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import sun.swing.SwingUtilities2;

class ColorChooserDialog
extends JDialog {
    private Color initialColor;
    private JColorChooser chooserPane;
    private JButton cancelButton;

    public ColorChooserDialog(Dialog owner, String title, boolean modal, Component c, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        super(owner, title, modal);
        this.initColorChooserDialog(c, chooserPane, okListener, cancelListener);
    }

    public ColorChooserDialog(Frame owner, String title, boolean modal, Component c, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        super(owner, title, modal);
        this.initColorChooserDialog(c, chooserPane, okListener, cancelListener);
    }

    protected void initColorChooserDialog(Component c, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) {
        boolean supportsWindowDecorations;
        this.chooserPane = chooserPane;
        Locale locale = this.getLocale();
        String okString = UIManager.getString((Object)"ColorChooser.okText", locale);
        String cancelString = UIManager.getString((Object)"ColorChooser.cancelText", locale);
        String resetString = UIManager.getString((Object)"ColorChooser.resetText", locale);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooserPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        JButton okButton = new JButton(okString);
        this.getRootPane().setDefaultButton(okButton);
        okButton.getAccessibleContext().setAccessibleDescription(okString);
        okButton.setActionCommand("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserDialog.this.hide();
            }
        });
        if (okListener != null) {
            okButton.addActionListener(okListener);
        }
        buttonPane.add(okButton);
        this.cancelButton = new JButton(cancelString);
        this.cancelButton.getAccessibleContext().setAccessibleDescription(cancelString);
        AbstractAction cancelKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AbstractButton)e.getSource()).fireActionPerformed(e);
            }
        };
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = this.cancelButton.getInputMap(2);
        ActionMap actionMap = this.cancelButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(cancelKeyStroke, "cancel");
            actionMap.put("cancel", cancelKeyAction);
        }
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserDialog.this.hide();
            }
        });
        if (cancelListener != null) {
            this.cancelButton.addActionListener(cancelListener);
        }
        buttonPane.add(this.cancelButton);
        JButton resetButton = new JButton(resetString);
        resetButton.getAccessibleContext().setAccessibleDescription(resetString);
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorChooserDialog.this.reset();
            }
        });
        int mnemonic = SwingUtilities2.getUIDefaultsInt("ColorChooser.resetMnemonic", locale, -1);
        if (mnemonic != -1) {
            resetButton.setMnemonic(mnemonic);
        }
        buttonPane.add(resetButton);
        contentPane.add((Component)buttonPane, "South");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(5);
        }
        this.applyComponentOrientation((c == null ? this.getRootPane() : c).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(c);
        this.addWindowListener(new Closer());
    }

    @Override
    public void show() {
        this.initialColor = this.chooserPane.getColor();
        super.show();
    }

    public void reset() {
        this.chooserPane.setColor(this.initialColor);
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ColorChooserDialog.this.cancelButton.doClick(0);
            Window w = e.getWindow();
            w.hide();
        }
    }
}

