/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public final class Distribution {
    private Entry allEntry = new Entry(null);
    private HashMap<JavaClass, Entry> map = new HashMap();
    private Set<Instance> counted = new HashSet<Instance>();

    public Set<JavaClass> getClasses() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public boolean isCounted(Instance instance) {
        return this.counted.contains(instance);
    }

    public Entry getResults(JavaClass javaClass) {
        return this.map.get(javaClass);
    }

    public void add(Instance instance) {
        if (!this.counted.add(instance)) {
            return;
        }
        JavaClass javaClass = instance.getJavaClass();
        Entry entry = this.map.get(javaClass);
        if (entry == null) {
            entry = new Entry(javaClass);
            this.map.put(javaClass, entry);
        }
        entry.count(instance);
        this.allEntry.count(instance);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(NbBundle.getMessage(Distribution.class, (String)"FMT_DistEntry", (Object)this.allEntry.getCount(), (Object)this.allEntry.getSize()));
        for (JavaClass javaClass : this.getClasses()) {
            stringBuilder.append("  ").append(this.getResults(javaClass)).append("\n");
        }
        return stringBuilder.toString();
    }

    public static class Entry {
        private JavaClass type;
        private int count;
        private int size;

        private Entry(JavaClass javaClass) {
            this.type = javaClass;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getSize() {
            return this.size;
        }

        public String toString() {
            return Utils.printClass(null, this.type.getName()) + ": " + this.getCount() + "/" + this.getSize() + "B";
        }

        private void count(Instance instance) {
            assert (this.type == null || this.type.equals(instance.getJavaClass()));
            ++this.count;
            this.size = (int)((long)this.size + instance.getSize());
        }
    }
}

