/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.objectweb.asm.commons.GeneratorAdapter;

final class PSubBrace
extends AStoreable {
    private final Definition.Type type;
    private AExpression index;

    PSubBrace(Location location, Definition.Type type, AExpression index) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.index.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.index.expected = Definition.INT_TYPE;
        this.index.analyze(locals);
        this.index = this.index.cast(locals);
        this.actual = Definition.getType(this.type.struct, this.type.dimensions - 1);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.setup(writer, globals);
        this.load(writer, globals);
    }

    @Override
    int accessElementCount() {
        return 2;
    }

    @Override
    boolean isDefOptimized() {
        return false;
    }

    @Override
    void updateActual(Definition.Type actual) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        this.index.write(writer, globals);
        PSubBrace.writeIndexFlip(writer, GeneratorAdapter::arrayLength);
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.arrayLoad(this.actual.type);
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.arrayStore(this.actual.type);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.index);
    }
}

