/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import freemind.common.FreeMindProgressMonitor;
import freemind.main.Resources;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public abstract class FreeMindTask
extends Thread {
    private static final long TIME_TO_DISPLAY_PROGRESS_BAR_IN_MILLIS = 1000L;
    private boolean mInterrupted = false;
    private boolean mFinished = false;
    private int mAmountOfSteps;
    private FreeMindProgressMonitor mProgressMonitor = null;
    private int mRounds;
    protected ProgressDescription mProgressDescription;
    private RootPaneContainer mFrame;
    private JPanel mGlass;
    private Component mOldGlassPane;

    public FreeMindTask(RootPaneContainer pRootPaneContainer, int pAmountOfSteps, String pName) {
        super(pName);
        this.mFrame = pRootPaneContainer;
        this.mAmountOfSteps = pAmountOfSteps;
        this.mProgressMonitor = new FreeMindProgressMonitor(this.getName());
        this.mGlass = new JPanel(new GridLayout(0, 1));
        JLabel padding = new JLabel();
        this.mGlass.setOpaque(false);
        this.mGlass.add(padding);
        this.mGlass.addMouseListener(new MouseAdapter(){});
        this.mGlass.addMouseMotionListener(new MouseMotionAdapter(){});
        this.mGlass.addKeyListener(new KeyAdapter(){});
        this.mGlass.setFocusCycleRoot(true);
        this.mOldGlassPane = pRootPaneContainer.getGlassPane();
        pRootPaneContainer.setGlassPane(this.mGlass);
        this.mGlass.setVisible(true);
        padding.requestFocus();
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        this.mRounds = 0;
        boolean again = true;
        while (again) {
            boolean canceled;
            try {
                again = this.processAction();
                ++this.mRounds;
                if (!again) {
                    this.mRounds = this.mAmountOfSteps;
                }
                if (this.mRounds == this.mAmountOfSteps) {
                    again = false;
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
                again = false;
            }
            if (this.isInterrupted()) {
                again = false;
            }
            if (System.currentTimeMillis() - startTime > 1000L) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FreeMindTask.this.mProgressMonitor.setVisible(true);
                    }
                });
            }
            if (!this.mProgressMonitor.isVisible()) continue;
            ProgressDescription progressDescription = this.mProgressDescription;
            if (this.mProgressDescription == null) {
                progressDescription = new ProgressDescription("FreeMindTask.Default", new Object[]{new Integer(this.mRounds)});
            }
            if (!(canceled = this.mProgressMonitor.showProgress(this.mRounds, this.mAmountOfSteps, progressDescription.mProgressString, progressDescription.mProgressParameters))) continue;
            this.mInterrupted = true;
            again = false;
        }
        this.setFinished(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeMindTask.this.mGlass.setVisible(false);
                FreeMindTask.this.mFrame.setGlassPane(FreeMindTask.this.mOldGlassPane);
                FreeMindTask.this.mProgressMonitor.dismiss();
            }
        });
    }

    protected abstract boolean processAction() throws Exception;

    @Override
    public boolean isInterrupted() {
        return this.mInterrupted;
    }

    public void setInterrupted(boolean pInterrupted) {
        this.mInterrupted = pInterrupted;
    }

    public boolean isFinished() {
        return this.mFinished;
    }

    public void setFinished(boolean pFinished) {
        this.mFinished = pFinished;
    }

    public int getAmountOfSteps() {
        return this.mAmountOfSteps;
    }

    public void setAmountOfSteps(int pAmountOfSteps) {
        this.mAmountOfSteps = pAmountOfSteps;
    }

    public int getRounds() {
        return this.mRounds;
    }

    protected class ProgressDescription {
        public String mProgressString;
        public Object[] mProgressParameters;

        public ProgressDescription(String pProgressString, Object[] pProgressParameters) {
            this.mProgressString = pProgressString;
            this.mProgressParameters = pProgressParameters;
        }
    }
}

