/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayEnsureCapacityNode;
import org.jruby.truffle.core.array.ArrayGeneralizeNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayWriteNormalizedNode.class)
public final class ArrayWriteNormalizedNodeGen
extends ArrayWriteNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayWriteNormalizedNodeGen(RubyNode array, RubyNode index, RubyNode value) {
        this.array_ = array;
        this.index_ = index;
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeWrite(DynamicObject arrayValue, int indexValue, Object valueValue) {
        return this.specialization_.execute1(arrayValue, indexValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayWriteNormalizedNode create(RubyNode array, RubyNode index, RubyNode value) {
        return new ArrayWriteNormalizedNodeGen(array, index, value);
    }

    @GeneratedBy(methodName="writeBeyondObject(DynamicObject, int, Object, ArrayStrategy, ArrayEnsureCapacityNode)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondObjectNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        @Node.Child
        private ArrayEnsureCapacityNode ensureCapacityNode;
        private final Class<?> indexImplicitType;

        WriteBeyondObjectNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy, ArrayEnsureCapacityNode ensureCapacityNode) {
            super(root, 5);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.strategy = strategy;
            this.ensureCapacityNode = ensureCapacityNode;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteBeyondObjectNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                assert (this.strategy.accepts(this.root.nil()));
                return true;
            }
            return false;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (!ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                assert (this.strategy.accepts(this.root.nil()));
                return this.root.writeBeyondObject(arrayValue_, indexValue_, valueValue_, this.strategy, this.ensureCapacityNode);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (!ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue) && this.strategy.matches(arrayValue)) {
                assert (this.strategy.accepts(this.root.nil()));
                return this.root.writeBeyondObject(arrayValue, indexValue, valueValue, this.strategy, this.ensureCapacityNode);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                assert (this.strategy.accepts(this.root.nil()));
                return this.root.writeBeyondObject(arrayValue_, indexValue_, valueValue, this.strategy, this.ensureCapacityNode);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy, ArrayEnsureCapacityNode ensureCapacityNode) {
            return new WriteBeyondObjectNode_(root, indexValue, strategy, ensureCapacityNode);
        }
    }

    @GeneratedBy(methodName="writeBeyondPrimitive(DynamicObject, int, Object, ArrayStrategy, ArrayGeneralizeNode)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondPrimitiveNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        @Node.Child
        private ArrayGeneralizeNode generalizeNode;
        private final Class<?> indexImplicitType;

        WriteBeyondPrimitiveNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy, ArrayGeneralizeNode generalizeNode) {
            super(root, 4);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.strategy = strategy;
            this.generalizeNode = generalizeNode;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteBeyondPrimitiveNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                assert (!this.strategy.accepts(this.root.nil()));
                return true;
            }
            return false;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (!ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                assert (!this.strategy.accepts(this.root.nil()));
                return this.root.writeBeyondPrimitive(arrayValue_, indexValue_, valueValue_, this.strategy, this.generalizeNode);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (!ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue) && this.strategy.matches(arrayValue)) {
                assert (!this.strategy.accepts(this.root.nil()));
                return this.root.writeBeyondPrimitive(arrayValue, indexValue, valueValue, this.strategy, this.generalizeNode);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_)) {
                assert (!this.strategy.accepts(this.root.nil()));
                return this.root.writeBeyondPrimitive(arrayValue_, indexValue_, valueValue, this.strategy, this.generalizeNode);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy, ArrayGeneralizeNode generalizeNode) {
            return new WriteBeyondPrimitiveNode_(root, indexValue, strategy, generalizeNode);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(DynamicObject, int, Object, ArrayAppendOneNode)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOneNode_
    extends BaseNode_ {
        @Node.Child
        private ArrayAppendOneNode appendNode;
        private final Class<?> indexImplicitType;

        WriteExtendByOneNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayAppendOneNode appendNode) {
            super(root, 3);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.appendNode = appendNode;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteExtendByOneNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_, this.appendNode);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeExtendByOne(arrayValue, indexValue, valueValue, this.appendNode);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType))) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue, this.appendNode);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayAppendOneNode appendNode) {
            return new WriteExtendByOneNode_(root, indexValue, appendNode);
        }
    }

    @GeneratedBy(methodName="writeWithinGeneralize(DynamicObject, int, Object, ArrayStrategy, ArrayStrategy, ArrayStrategy)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinGeneralizeNode_
    extends BaseNode_ {
        private final ArrayStrategy currentStrategy;
        private final ArrayStrategy valueStrategy;
        private final ArrayStrategy generalizedStrategy;
        private final Class<?> indexImplicitType;

        WriteWithinGeneralizeNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy currentStrategy, ArrayStrategy valueStrategy, ArrayStrategy generalizedStrategy) {
            super(root, 2);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.currentStrategy = currentStrategy;
            this.valueStrategy = valueStrategy;
            this.generalizedStrategy = generalizedStrategy;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinGeneralizeNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.currentStrategy.matches(arrayValue_) && !this.currentStrategy.accepts(valueValue) && this.valueStrategy.specializesFor(valueValue);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && this.currentStrategy.matches(arrayValue_) && !this.currentStrategy.accepts(valueValue_) && this.valueStrategy.specializesFor(valueValue_)) {
                return this.root.writeWithinGeneralize(arrayValue_, indexValue_, valueValue_, this.currentStrategy, this.valueStrategy, this.generalizedStrategy);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && this.currentStrategy.matches(arrayValue) && !this.currentStrategy.accepts(valueValue) && this.valueStrategy.specializesFor(valueValue)) {
                return this.root.writeWithinGeneralize(arrayValue, indexValue, valueValue, this.currentStrategy, this.valueStrategy, this.generalizedStrategy);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.currentStrategy.matches(arrayValue_) && !this.currentStrategy.accepts(valueValue) && this.valueStrategy.specializesFor(valueValue)) {
                return this.root.writeWithinGeneralize(arrayValue_, indexValue_, valueValue, this.currentStrategy, this.valueStrategy, this.generalizedStrategy);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy currentStrategy, ArrayStrategy valueStrategy, ArrayStrategy generalizedStrategy) {
            return new WriteWithinGeneralizeNode_(root, indexValue, currentStrategy, valueStrategy, generalizedStrategy);
        }
    }

    @GeneratedBy(methodName="writeWithin(DynamicObject, int, Object, ArrayStrategy)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final Class<?> indexImplicitType;

        WriteWithinNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.strategy = strategy;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.strategy.matches(arrayValue_) && this.strategy.accepts(valueValue);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_) && this.strategy.accepts(valueValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_, this.strategy);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && this.strategy.matches(arrayValue) && this.strategy.accepts(valueValue)) {
                return this.root.writeWithin(arrayValue, indexValue, valueValue, this.strategy);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.strategy.matches(arrayValue_) && this.strategy.accepts(valueValue)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue, this.strategy);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            return new WriteWithinNode_(root, indexValue, strategy);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, valueValue));
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            return this.uninitialized((Frame)null, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayWriteNormalizedNodeGen root;

        BaseNode_(ArrayWriteNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayWriteNormalizedNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.execute_(arrayValue, indexValue, valueValue);
        }

        public abstract Object execute_(Object var1, Object var2, Object var3);

        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            return this.execute_(arrayValue, indexValue, valueValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.execute_(arrayValue_, indexValue_, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                ArrayEnsureCapacityNode ensureCapacityNode5;
                BaseNode_ s;
                ArrayGeneralizeNode generalizeNode4;
                BaseNode_ s2;
                ArrayStrategy generalizedStrategy2;
                BaseNode_ s3;
                BaseNode_ s4;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue);
                ArrayStrategy strategy1 = ArrayStrategy.of(arrayValue_);
                if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && strategy1.matches(arrayValue_) && strategy1.accepts(valueValue) && this.countSame(s4 = WriteWithinNode_.create(this.root, indexValue, strategy1)) < 25) {
                    return s4;
                }
                ArrayStrategy currentStrategy2 = ArrayStrategy.of(arrayValue_);
                ArrayStrategy valueStrategy2 = ArrayStrategy.forValue(valueValue);
                if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && currentStrategy2.matches(arrayValue_) && !currentStrategy2.accepts(valueValue) && valueStrategy2.specializesFor(valueValue) && this.countSame(s3 = WriteWithinGeneralizeNode_.create(this.root, indexValue, currentStrategy2, valueStrategy2, generalizedStrategy2 = currentStrategy2.generalize(valueStrategy2))) < 25) {
                    return s3;
                }
                if (ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    ArrayAppendOneNode appendNode3 = ArrayAppendOneNode.create();
                    return WriteExtendByOneNode_.create(this.root, indexValue, appendNode3);
                }
                ArrayStrategy strategy4 = ArrayStrategy.of(arrayValue_);
                if (!ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && strategy4.matches(arrayValue_) && !strategy4.accepts(this.root.nil()) && this.countSame(s2 = WriteBeyondPrimitiveNode_.create(this.root, indexValue, strategy4, generalizeNode4 = ArrayGeneralizeNode.create())) < 25) {
                    return s2;
                }
                ArrayStrategy strategy5 = ArrayStrategy.of(arrayValue_);
                if (!ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_) && strategy5.matches(arrayValue_) && strategy5.accepts(this.root.nil()) && this.countSame(s = WriteBeyondObjectNode_.create(this.root, indexValue, strategy5, ensureCapacityNode5 = ArrayEnsureCapacityNode.create())) < 3) {
                    return s;
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }
    }
}

