/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.function.Supplier;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;

@NodeChild(value="value", type=RubyNode.class)
public abstract class LazyDefaultValueNode
extends RubyNode {
    private final Supplier<Object> defaultValueProducer;
    @CompilerDirectives.CompilationFinal
    private boolean hasDefault;
    @CompilerDirectives.CompilationFinal
    private Object defaultValue;

    public LazyDefaultValueNode(Supplier<Object> defaultValueProducer) {
        this.defaultValueProducer = defaultValueProducer;
    }

    @Specialization
    public Object doDefault(NotProvided value) {
        if (!this.hasDefault) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.defaultValue = this.defaultValueProducer.get();
            this.hasDefault = true;
        }
        return this.defaultValue;
    }

    @Specialization(guards={"wasProvided(value)"})
    public Object doProvided(Object value) {
        return value;
    }
}

