/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;

public class ConcatRope
extends Rope {
    private final Rope left;
    private final Rope right;
    private final boolean balanced;

    public ConcatRope(Rope left, Rope right, Encoding encoding, CodeRange codeRange, boolean singleByteOptimizable, int depth, boolean balanced) {
        this(left, right, encoding, codeRange, singleByteOptimizable, depth, null, balanced);
    }

    private ConcatRope(Rope left, Rope right, Encoding encoding, CodeRange codeRange, boolean singleByteOptimizable, int depth, byte[] bytes, boolean balanced) {
        super(encoding, codeRange, singleByteOptimizable, left.byteLength() + right.byteLength(), left.characterLength() + right.characterLength(), depth, bytes);
        this.left = left;
        this.right = right;
        this.balanced = balanced;
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        return new ConcatRope(this.getLeft(), this.getRight(), newEncoding, newCodeRange, this.isSingleByteOptimizable(), this.depth(), this.getRawBytes(), this.balanced);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte getByteSlow(int index) {
        if (index < this.left.byteLength()) {
            return this.left.getByteSlow(index);
        }
        return this.right.getByteSlow(index - this.left.byteLength());
    }

    public Rope getLeft() {
        return this.left;
    }

    public Rope getRight() {
        return this.right;
    }

    public boolean isBalanced() {
        return this.balanced;
    }

    public String toString() {
        return this.left.toString() + this.right.toString();
    }
}

