/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObject;

public class RubiniusLastStringReadNode
extends RubyNode {
    @Override
    public Object execute(VirtualFrame frame) {
        return this.getLastString();
    }

    @CompilerDirectives.TruffleBoundary
    private Object getLastString() {
        Frame callerFrame = this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
        FrameSlot slot = callerFrame.getFrameDescriptor().findFrameSlot("$_");
        try {
            ThreadLocalObject threadLocalObject = (ThreadLocalObject)callerFrame.getObject(slot);
            return threadLocalObject.get();
        }
        catch (FrameSlotTypeException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

