/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.text.Collator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.office.FontDeclaration;
import writer2latex.office.IndexMark;
import writer2latex.office.ListCounter;
import writer2latex.office.ListStyle;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyle;
import writer2latex.office.PropertySet;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TocReader;
import writer2latex.util.Misc;
import writer2latex.xhtml.AlphabeticalEntry;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.IndexData;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TocEntry;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlStyleMap;

public class TextConverter
extends ConverterHelper {
    private int nSplitAfter = 150000;
    private int nPageBreakSplit = 0;
    private boolean bPendingPageBreak = false;
    private int nExternalTocDepth = 1;
    private int nSplit = 0;
    private int nRepeatLevels = 5;
    private int nLastSplitLevel = 1;
    private int nDontSplitLevel = 0;
    boolean bAfterHeading = false;
    protected Stack<Node> sections = new Stack();
    Element[] currentHeading = new Element[7];
    private int nCharacterCount = 0;
    private ListCounter outlineNumbering;
    private Hashtable<String, ListCounter> listCounters = new Hashtable();
    private String sCurrentListLabel = null;
    private ListStyle currentListStyle = null;
    private int nCurrentListLevel = 0;
    private int nFloatMode;
    private Vector<IndexData> indexes = new Vector();
    Vector<AlphabeticalEntry> index = new Vector();
    private int nIndexIndex = -1;
    private int nAlphabeticalIndex = -1;
    private Vector<TocEntry> tocEntries = new Vector();
    private int nTocFileIndex = -1;
    private Element currentChapter = null;
    private int nTocIndex = -1;
    private ListCounter naturalOutline = new ListCounter();
    private String sFntCitBodyStyle = null;
    private String sFntCitStyle = null;
    private String sEntCitBodyStyle = null;
    private String sEntCitStyle = null;
    private boolean bFootnotesAtPage = true;
    private LinkedList<Node> footnotes = new LinkedList();
    private LinkedList<Node> endnotes = new LinkedList();
    private Node asapNode = null;
    private boolean bInToc = false;
    private boolean bDisplayHiddenText = false;

    public TextConverter(OfficeReader ofr, XhtmlConfig config, Converter converter) {
        super(ofr, config, converter);
        this.nSplitAfter = 1000 * config.splitAfter();
        this.nPageBreakSplit = config.pageBreakSplit();
        this.nSplit = config.getXhtmlSplitLevel();
        this.nRepeatLevels = converter.isOPS() ? 0 : config.getXhtmlRepeatLevels();
        this.nExternalTocDepth = config.externalTocDepth();
        if (this.nExternalTocDepth == 0) {
            this.nExternalTocDepth = Math.max(this.nSplit, 1);
        }
        this.nFloatMode = ofr.isText() && config.xhtmlFloatObjects() ? 1 : 2;
        this.outlineNumbering = new ListCounter(ofr.getOutlineStyle());
        PropertySet notes = ofr.getFootnotesConfiguration();
        if (notes != null) {
            this.sFntCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            this.sFntCitStyle = notes.getProperty("text:citation-style-name");
            boolean bl = this.bFootnotesAtPage = !"document".equals(notes.getProperty("text:footnotes-position"));
        }
        if ((notes = ofr.getEndnotesConfiguration()) != null) {
            this.sEntCitBodyStyle = notes.getProperty("text:citation-body-style-name");
            this.sEntCitStyle = notes.getProperty("text:citation-style-name");
        }
        this.bDisplayHiddenText = config.displayHiddenText();
    }

    public void convertTextContent(Element onode) {
        Element form;
        Element hnode = this.converter.nextOutFile();
        if (this.nSplit == 0 && (form = this.getDrawCv().createForm()) != null) {
            hnode.appendChild(form);
            hnode = form;
        }
        hnode = this.getDrawCv().insertCoverImage(hnode);
        hnode = (Element)this.traverseBlockText(onode, hnode);
        this.insertFootnotes(hnode, true);
        this.insertEndnotes(hnode);
        int nIndexCount = this.indexes.size();
        for (int i = 0; i < nIndexCount; ++i) {
            this.generateToc(this.indexes.get(i));
        }
        this.generateHeaders();
        this.generateFooters();
        this.generatePanels();
    }

    protected int getTocIndex() {
        return this.nTocFileIndex;
    }

    protected int getAlphabeticalIndex() {
        return this.nAlphabeticalIndex;
    }

    private void generateHeaders() {
    }

    private void generateFooters() {
    }

    private void generatePanels() {
        int nLastIndex = this.converter.getOutFileIndex();
        this.bInToc = true;
        boolean bHasFrontMatter = false;
        TocEntry fakeEntry = new TocEntry();
        fakeEntry.nOutlineLevel = 0;
        fakeEntry.nOutlineNumber = new int[11];
        int nLen = this.tocEntries.size();
        for (int nIndex = 0; nIndex <= nLastIndex; ++nIndex) {
            int nMaxLevel;
            this.converter.changeOutFile(nIndex);
            Element panel = this.converter.getPanelNode();
            if (panel == null) continue;
            TocEntry entryCurrent = null;
            for (int i = nLen - 1; i >= 0; --i) {
                TocEntry entry = this.tocEntries.get(i);
                if (!"text:h".equals(entry.onode.getTagName()) || entry.nFileIndex != nIndex || entry.nOutlineLevel > this.nSplit) continue;
                entryCurrent = entry;
                break;
            }
            if (entryCurrent == null) {
                entryCurrent = fakeEntry;
                if (nIndex == 0) {
                    bHasFrontMatter = true;
                }
            }
            if ((nMaxLevel = entryCurrent.nOutlineLevel) < this.nSplit) {
                ++nMaxLevel;
            }
            if (bHasFrontMatter) {
                Element inline = this.createPanelLink(panel, nIndex, 0, 1);
                inline.appendChild(this.converter.createTextNode(this.converter.getL10n().get(7)));
            }
            int nPrevFileIndex = 0;
            for (int i = 0; i < nLen; ++i) {
                boolean bInclude;
                TocEntry entry = this.tocEntries.get(i);
                if (entry.nFileIndex > nPrevFileIndex + 1) {
                    for (int k = nPrevFileIndex + 1; k < entry.nFileIndex; ++k) {
                        this.createIndexLink(panel, nIndex, k);
                    }
                }
                nPrevFileIndex = entry.nFileIndex;
                String sNodeName = entry.onode.getTagName();
                if (!"text:h".equals(sNodeName)) continue;
                boolean bl = bInclude = entry.nOutlineLevel <= nMaxLevel;
                if (bInclude) {
                    int nCompareLevels = entry.nOutlineLevel;
                    for (int j = 1; j < nCompareLevels; ++j) {
                        if (entry.nOutlineNumber[j] == entryCurrent.nOutlineNumber[j]) continue;
                        bInclude = false;
                    }
                }
                if (!bInclude) continue;
                Element inline = this.createPanelLink(panel, nIndex, entry.nFileIndex, entry.nOutlineLevel);
                if (entry.sLabel != null && entry.sLabel.length() > 0) {
                    inline.appendChild(this.converter.createTextNode(entry.sLabel));
                    if (!entry.sLabel.endsWith(" ")) {
                        inline.appendChild(this.converter.createTextNode(" "));
                    }
                }
                this.traverseInlineText(entry.onode, inline);
            }
            if (nPrevFileIndex >= nLastIndex) continue;
            for (int k = nPrevFileIndex + 1; k <= nLastIndex; ++k) {
                this.createIndexLink(panel, nIndex, k);
            }
        }
        this.bInToc = false;
        this.converter.changeOutFile(nLastIndex);
    }

    private void createIndexLink(Element panel, int nIndex, int nFileIndex) {
        if (nFileIndex == this.nTocFileIndex) {
            Element inline = this.createPanelLink(panel, nIndex, this.nTocFileIndex, 1);
            inline.appendChild(this.converter.createTextNode(this.converter.getL10n().get(5)));
        } else if (nFileIndex == this.nAlphabeticalIndex) {
            Element inline = this.createPanelLink(panel, nIndex, this.nAlphabeticalIndex, 1);
            inline.appendChild(this.converter.createTextNode(this.converter.getL10n().get(6)));
        }
    }

    private Element createPanelLink(Element panel, int nCurrentFile, int nLinkFile, int nOutlineLevel) {
        Element inline;
        Element p = this.converter.createElement("p");
        p.setAttribute("class", "level" + nOutlineLevel);
        panel.appendChild(p);
        if (nCurrentFile != nLinkFile) {
            inline = this.converter.createElement("a");
            inline.setAttribute("href", this.converter.getOutFileName(nLinkFile, true));
        } else {
            inline = this.converter.createElement("span");
            inline.setAttribute("class", "nolink");
        }
        p.appendChild(inline);
        return inline;
    }

    public Node traverseBlockText(Node onode, Node hnode) {
        return this.traverseBlockText(onode, 0, null, hnode);
    }

    private Node traverseBlockText(Node onode, int nLevel, String styleName, Node hnode) {
        if (!onode.hasChildNodes()) {
            return hnode;
        }
        this.bAfterHeading = false;
        NodeList nList = onode.getChildNodes();
        int nLen = nList.getLength();
        for (int i = 0; i < nLen; ++i) {
            StyleWithProperties style;
            Node child = nList.item(i);
            if (child.getNodeType() != 1) continue;
            String nodeName = child.getNodeName();
            ++this.nDontSplitLevel;
            if (OfficeReader.isDrawElement(child)) {
                this.getDrawCv().handleDrawElement((Element)child, (Element)hnode, null, this.nFloatMode);
            } else if (nodeName.equals("text:p")) {
                String sDisplayName;
                style = this.ofr.getParStyle(Misc.getAttribute(child, "text:style-name"));
                hnode = this.maybeSplit(hnode, style);
                this.nCharacterCount += OfficeReader.getCharacterCount(child);
                XhtmlStyleMap xpar = this.config.getXParStyleMap();
                String string = sDisplayName = style != null ? style.getDisplayName() : null;
                if (sDisplayName != null && xpar.contains(sDisplayName)) {
                    Node curHnode = hnode;
                    String sBlockElement = xpar.getBlockElement(sDisplayName);
                    String sBlockCss = xpar.getBlockCss(sDisplayName);
                    if (xpar.getBlockElement(sDisplayName).length() > 0) {
                        Element block = this.converter.createElement(xpar.getBlockElement(sDisplayName));
                        if (!"(none)".equals(xpar.getBlockCss(sDisplayName))) {
                            block.setAttribute("class", xpar.getBlockCss(sDisplayName));
                        }
                        hnode.appendChild(block);
                        curHnode = block;
                    }
                    boolean bMoreParagraphs = true;
                    do {
                        String sCurDisplayName;
                        String cnodeName;
                        this.handleParagraph(child, curHnode);
                        bMoreParagraphs = false;
                        if (++i >= nLen || !(cnodeName = (child = nList.item(i)).getNodeName()).equals("text:p") || (sCurDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(child, "text:style-name"))) == null || !xpar.contains(sCurDisplayName) || !sBlockElement.equals(xpar.getBlockElement(sCurDisplayName)) || !sBlockCss.equals(xpar.getBlockCss(sCurDisplayName))) continue;
                        bMoreParagraphs = true;
                    } while (bMoreParagraphs);
                    --i;
                } else {
                    this.handleParagraph(child, hnode);
                }
            } else if (nodeName.equals("text:h")) {
                style = this.ofr.getParStyle(Misc.getAttribute(child, "text:style-name"));
                int nOutlineLevel = this.getOutlineLevel((Element)child);
                Node rememberNode = hnode;
                hnode = this.maybeSplit(hnode, style, nOutlineLevel);
                this.nCharacterCount += OfficeReader.getCharacterCount(child);
                this.handleHeading((Element)child, hnode, rememberNode != hnode);
            } else if (nodeName.equals("text:list") || nodeName.equals("text:unordered-list") || nodeName.equals("text:ordered-list")) {
                hnode = this.maybeSplit(hnode, null);
                if (this.listIsOnlyHeadings(child)) {
                    --this.nDontSplitLevel;
                    hnode = this.handleFakeList(child, nLevel + 1, styleName, hnode);
                    ++this.nDontSplitLevel;
                } else {
                    this.handleList(child, nLevel + 1, styleName, hnode);
                }
            } else if (nodeName.equals("table:table")) {
                style = this.ofr.getTableStyle(Misc.getAttribute(child, "text:style-name"));
                hnode = this.maybeSplit(hnode, style);
                this.getTableCv().handleTable(child, hnode);
            } else if (nodeName.equals("table:sub-table")) {
                this.getTableCv().handleTable(child, hnode);
            } else if (nodeName.equals("text:section")) {
                hnode = this.maybeSplit(hnode, null);
                --this.nDontSplitLevel;
                hnode = this.handleSection(child, hnode);
                ++this.nDontSplitLevel;
            } else if (nodeName.equals("text:table-of-content")) {
                if (!this.ofr.getTocReader((Element)child).isByChapter()) {
                    hnode = this.maybeSplit(hnode, null, 1);
                }
                this.handleTOC(child, hnode);
            } else if (nodeName.equals("text:illustration-index")) {
                this.handleLOF(child, hnode);
            } else if (nodeName.equals("text:table-index")) {
                this.handleLOT(child, hnode);
            } else if (nodeName.equals("text:object-index")) {
                this.handleObjectIndex(child, hnode);
            } else if (nodeName.equals("text:user-index")) {
                this.handleUserIndex(child, hnode);
            } else if (nodeName.equals("text:alphabetical-index")) {
                hnode = this.maybeSplit(hnode, null, 1);
                this.handleAlphabeticalIndex(child, hnode);
            } else if (nodeName.equals("text:bibliography")) {
                hnode = this.maybeSplit(hnode, null, 1);
                this.handleBibliography(child, hnode);
            } else if (nodeName.equals("text:soft-page-break")) {
                if (this.nPageBreakSplit == 3) {
                    this.bPendingPageBreak = true;
                }
            } else if (nodeName.equals("office:annotation")) {
                this.converter.handleOfficeAnnotation(child, hnode);
            } else if (nodeName.equals("text:sequence-decls")) {
                // empty if block
            }
            --this.nDontSplitLevel;
            if (this.nDontSplitLevel != 0) continue;
            this.bAfterHeading = nodeName.equals("text:h");
            hnode = this.getDrawCv().flushFullscreenFrames((Element)hnode);
        }
        return hnode;
    }

    private boolean getPageBreak(StyleWithProperties style) {
        if (style != null && this.nPageBreakSplit > 0) {
            if (style.isAutomatic() && this.nPageBreakSplit < 2) {
                OfficeStyle parentStyle = style.getParentStyle();
                if (parentStyle != null && parentStyle instanceof StyleWithProperties) {
                    style = (StyleWithProperties)parentStyle;
                } else {
                    return false;
                }
            }
            if ("page".equals(style.getProperty("fo:break-before"))) {
                return true;
            }
            if ("page".equals(style.getProperty("fo:break-after"))) {
                this.bPendingPageBreak = true;
                return false;
            }
            String sMasterPage = style.getMasterPageName();
            if (sMasterPage != null && sMasterPage.length() > 0) {
                return true;
            }
        }
        return false;
    }

    private Node maybeSplit(Node node, StyleWithProperties style) {
        return this.maybeSplit(node, style, -1);
    }

    private Node maybeSplit(Node node, StyleWithProperties style, int nLevel) {
        if (this.bPendingPageBreak) {
            return this.doMaybeSplit(node, 0);
        }
        if (this.getPageBreak(style)) {
            return this.doMaybeSplit(node, 0);
        }
        if (this.converter.isOPS() && this.nSplitAfter > 0 && this.nCharacterCount > this.nSplitAfter) {
            return this.doMaybeSplit(node, 0);
        }
        if (nLevel >= 0) {
            return this.doMaybeSplit(node, nLevel);
        }
        return node;
    }

    protected Element doMaybeSplit(Node node, int nLevel) {
        if (this.nDontSplitLevel > 1) {
            return (Element)node;
        }
        if (!this.converter.isOPS() && this.bAfterHeading && nLevel - this.nLastSplitLevel <= this.nRepeatLevels) {
            return (Element)node;
        }
        if (this.nSplit >= nLevel && this.converter.outFileHasContent()) {
            this.nCharacterCount = 0;
            this.bPendingPageBreak = false;
            if (this.converter.getOutFileIndex() >= 0) {
                this.insertFootnotes(node, false);
            }
            return this.converter.nextOutFile();
        }
        return (Element)node;
    }

    private Node handleSection(Node onode, Node hnode) {
        if (!this.bDisplayHiddenText && "none".equals(Misc.getAttribute(onode, "text:display"))) {
            return hnode;
        }
        String sName = Misc.getAttribute(onode, "text:name");
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        this.converter.addTarget(div, sName + "|region");
        StyleInfo sectionInfo = new StyleInfo();
        this.getSectionSc().applyStyle(sStyleName, sectionInfo);
        this.applyStyle(sectionInfo, div);
        this.sections.push(onode);
        Node newhnode = this.traverseBlockText(onode, div);
        this.sections.pop();
        return newhnode.getParentNode();
    }

    private void handleHeading(Element onode, Node hnode, boolean bAfterSplit) {
        int nListLevel = this.getOutlineLevel(onode);
        boolean bUnNumbered = "true".equals(Misc.getAttribute(onode, "text:is-list-header"));
        boolean bRestart = "true".equals(Misc.getAttribute(onode, "text:restart-numbering"));
        int nStartValue = Misc.getPosInteger(Misc.getAttribute(onode, "text:start-value"), 1) - 1;
        this.handleHeading(onode, hnode, bAfterSplit, this.ofr.getOutlineStyle(), nListLevel, bUnNumbered, bRestart, nStartValue);
    }

    private void handleHeading(Element onode, Node hnode, boolean bAfterSplit, ListStyle listStyle, int nListLevel, boolean bUnNumbered, boolean bRestart, int nStartValue) {
        int nLevel = this.getOutlineLevel(onode);
        if (nLevel <= 6) {
            String sStrikeOut;
            String sListStyleName;
            String sStyleName = onode.getAttribute("text:style-name");
            StyleWithProperties style = this.ofr.getParStyle(sStyleName);
            if (!this.bDisplayHiddenText && style != null && "none".equals(style.getProperty("text:display"))) {
                return;
            }
            if (!bUnNumbered && style != null && (sListStyleName = style.getListStyleName()) != null && sListStyleName.length() == 0) {
                bUnNumbered = true;
            }
            ListCounter counter = null;
            String sLabel = "";
            if (!bUnNumbered) {
                counter = this.getListCounter(listStyle);
                if (bRestart) {
                    counter.restart(nListLevel, nStartValue);
                }
                sLabel = counter.step(nListLevel).getLabel();
            }
            boolean bTocOnly = false;
            if (this.converter.isOPS() && style != null && (sStrikeOut = style.getProperty("style:text-line-through-style", true)) != null && !"none".equals(sStrikeOut)) {
                bTocOnly = true;
            }
            if (!bTocOnly) {
                if (nLevel == 1) {
                    this.currentChapter = onode;
                }
                if (bAfterSplit && this.nSplit > 0) {
                    int nFirst = nLevel - this.nRepeatLevels;
                    if (nFirst < 0) {
                        nFirst = 0;
                    }
                    for (int i = nFirst; i < nLevel; ++i) {
                        if (this.currentHeading[i] == null) continue;
                        hnode.appendChild(this.converter.importNode(this.currentHeading[i], true));
                    }
                }
                StyleInfo info = new StyleInfo();
                info.sTagName = "h" + nLevel;
                this.getHeadingSc().applyStyle(nLevel, sStyleName, info);
                Element heading = this.converter.createElement(info.sTagName);
                hnode.appendChild(heading);
                this.applyStyle(info, heading);
                this.traverseFloats(onode, hnode, heading);
                this.prependAsapNode(heading);
                if (!bUnNumbered) {
                    this.insertListLabel(listStyle, nListLevel, "SectionNumber", null, sLabel, heading);
                }
                if (!this.bInToc) {
                    String sTarget = "toc" + ++this.nTocIndex;
                    this.converter.addTarget(heading, sTarget);
                    if (nLevel <= this.nExternalTocDepth) {
                        this.converter.addContentEntry(sLabel + this.converter.getPlainInlineText(onode), nLevel, nLevel > this.nSplit ? sTarget : null);
                    }
                    TocEntry entry = new TocEntry();
                    entry.onode = onode;
                    entry.sLabel = sLabel;
                    entry.nFileIndex = this.converter.getOutFileIndex();
                    entry.nOutlineLevel = nLevel;
                    entry.nOutlineNumber = this.naturalOutline.step(nLevel).getValues();
                    this.tocEntries.add(entry);
                }
                StyleInfo innerInfo = new StyleInfo();
                this.getHeadingSc().applyInnerStyle(nLevel, sStyleName, innerInfo);
                Element content = heading;
                if (innerInfo.sTagName != null && innerInfo.sTagName.length() > 0) {
                    content = this.converter.createElement(innerInfo.sTagName);
                    heading.appendChild(content);
                    this.applyStyle(innerInfo, content);
                }
                this.traverseInlineText(onode, content);
                this.currentHeading[nLevel] = heading;
                for (int i = nLevel + 1; i <= 6; ++i) {
                    this.currentHeading[i] = null;
                }
            } else {
                if (!this.bInToc && nLevel <= this.nExternalTocDepth) {
                    String sTarget = null;
                    if (nLevel > this.nSplit) {
                        Element div = this.converter.createElement("div");
                        hnode.appendChild(div);
                        sTarget = "toc" + ++this.nTocIndex;
                        this.converter.addTarget(div, sTarget);
                    }
                    this.converter.addContentEntry(sLabel + this.converter.getPlainInlineText(onode), nLevel, sTarget);
                }
                this.currentHeading[nLevel] = null;
                for (int i = nLevel + 1; i <= 6; ++i) {
                    this.currentHeading[i] = null;
                }
            }
        } else {
            this.handleParagraph(onode, hnode);
        }
    }

    private void handleParagraph(Node onode, Node hnode) {
        Element par;
        boolean bIsEmpty = OfficeReader.isWhitespaceContent(onode);
        if (this.config.ignoreEmptyParagraphs() && bIsEmpty) {
            return;
        }
        String sStyleName = Misc.getAttribute(onode, "text:style-name");
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (!this.bDisplayHiddenText && style != null && "none".equals(style.getProperty("text:display"))) {
            return;
        }
        if (this.ofr.isSpreadsheet()) {
            par = (Element)hnode;
        } else {
            Element temp = this.converter.createElement("temp");
            par = this.createParagraph(temp, sStyleName);
            this.prependAsapNode(par);
            this.traverseFloats(onode, hnode, par);
            hnode.appendChild(temp.getFirstChild());
        }
        if (this.ofr.isIndexSourceStyle(this.getParSc().getRealParStyleName(sStyleName))) {
            this.converter.addTarget(par, "toc" + ++this.nTocIndex);
            TocEntry entry = new TocEntry();
            entry.onode = (Element)onode;
            entry.sLabel = this.sCurrentListLabel;
            entry.nFileIndex = this.converter.getOutFileIndex();
            this.tocEntries.add(entry);
        }
        if (!bIsEmpty) {
            par = this.createTextBackground(par, sStyleName);
            if (this.config.listFormatting() == 2) {
                this.insertListLabel(this.currentListStyle, this.nCurrentListLevel, "ItemNumber", null, this.sCurrentListLabel, par);
            }
            this.sCurrentListLabel = null;
            this.traverseInlineText(onode, par);
        } else {
            par.appendChild(this.converter.createTextNode("\u00a0"));
            this.sCurrentListLabel = null;
        }
        if (this.converter.isOPS() && !par.hasChildNodes()) {
            hnode.removeChild(par);
        }
    }

    private void prependAsapNode(Node node) {
        if (this.asapNode != null) {
            if (this.asapNode.getOwnerDocument() != node.getOwnerDocument()) {
                this.asapNode = this.converter.importNode(this.asapNode, true);
            }
            node.appendChild(this.asapNode);
            this.asapNode = null;
        }
    }

    private ListCounter getListCounter(ListStyle style) {
        if (style == this.ofr.getOutlineStyle()) {
            return this.outlineNumbering;
        }
        if (style != null) {
            if (this.listCounters.containsKey(style.getName())) {
                return this.listCounters.get(style.getName());
            }
            ListCounter counter = new ListCounter(style);
            this.listCounters.put(style.getName(), counter);
            return counter;
        }
        return new ListCounter();
    }

    private void insertListLabel(ListStyle style, int nLevel, String sDefaultStyle, String sPrefix, String sLabel, Element hnode) {
        if (sLabel != null && sLabel.length() > 0) {
            if (sPrefix != null) {
                Element prefix = this.converter.createElement("span");
                prefix.setAttribute("class", "chapter-name");
                hnode.appendChild(prefix);
                prefix.appendChild(this.converter.createTextNode(sPrefix));
            }
            StyleInfo info = new StyleInfo();
            if (style != null) {
                String sTextStyleName = style.getLevelProperty(nLevel, "text:style-name");
                this.getTextSc().applyStyle(sTextStyleName, info);
            }
            if (info.sTagName == null) {
                info.sTagName = "span";
            }
            if (info.sClass == null) {
                info.sClass = sDefaultStyle;
            }
            Element content = this.converter.createElement(info.sTagName);
            this.getTextSc().applyStyle(info, content);
            hnode.appendChild(content);
            content.appendChild(this.converter.createTextNode(sLabel));
        }
    }

    private boolean hasItems(Node onode) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!Misc.isElement(child, "text:list-item") && !Misc.isElement(child, "text:list-header")) continue;
            return true;
        }
        return false;
    }

    private void handleOL(Node onode, int nLevel, String sStyleName, Node hnode) {
        if (this.hasItems(onode)) {
            Element list = this.converter.createElement("ol");
            StyleInfo listInfo = new StyleInfo();
            this.getListSc().applyStyle(nLevel, sStyleName, listInfo);
            this.applyStyle(listInfo, list);
            hnode.appendChild(list);
            this.traverseList(onode, nLevel, sStyleName, list);
        }
    }

    private void handleUL(Node onode, int nLevel, String sStyleName, Node hnode) {
        if (this.hasItems(onode)) {
            Element list = this.converter.createElement("ul");
            StyleInfo listInfo = new StyleInfo();
            this.getListSc().applyStyle(nLevel, sStyleName, listInfo);
            this.applyStyle(listInfo, list);
            hnode.appendChild(list);
            this.traverseList(onode, nLevel, sStyleName, list);
        }
    }

    private void handleList(Node onode, int nLevel, String sStyleName, Node hnode) {
        ListStyle style;
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        if ((style = this.ofr.getListStyle(sStyleName)) != null && style.isNumber(nLevel)) {
            this.handleOL(onode, nLevel, sStyleName, hnode);
        } else {
            this.handleUL(onode, nLevel, sStyleName, hnode);
        }
    }

    private void traverseList(Node onode, int nLevel, String styleName, Element hnode) {
        ListCounter counter = this.getListCounter(this.ofr.getListStyle(styleName));
        boolean bContinueNumbering = "true".equals(Misc.getAttribute(onode, "text:continue-numbering"));
        if (!bContinueNumbering && counter != null) {
            counter.restart(nLevel);
        }
        if (this.config.listFormatting() == 1 && counter.getValue(nLevel) > 0) {
            hnode.setAttribute("start", Integer.toString(counter.getValue(nLevel) + 1));
        }
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int len = nList.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nList.item(i);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals("text:list-item")) {
                    boolean bIsImmediateNestedList = false;
                    Element child1 = Misc.getFirstChildElement(child);
                    if (child1.getTagName().equals("text:ordered-list") || child1.getTagName().equals("text:unordered-list") || child1.getTagName().equals("text:list")) {
                        bIsImmediateNestedList = true;
                    }
                    if (this.config.listFormatting() == 1 && bIsImmediateNestedList) {
                        this.traverseListItem(child, nLevel, styleName, hnode);
                    } else {
                        this.sCurrentListLabel = counter.step(nLevel).getLabel();
                        this.currentListStyle = this.ofr.getListStyle(styleName);
                        this.nCurrentListLevel = nLevel;
                        Element item = this.converter.createElement("li");
                        StyleInfo info = new StyleInfo();
                        this.getPresentationSc().applyOutlineStyle(nLevel, info);
                        this.applyStyle(info, item);
                        hnode.appendChild(item);
                        if (this.config.listFormatting() == 1) {
                            boolean bRestart = "true".equals(Misc.getAttribute(child, "text:restart-numbering"));
                            int nStartValue = Misc.getPosInteger(Misc.getAttribute(child, "text:start-value"), 1);
                            if (bRestart) {
                                item.setAttribute("value", Integer.toString(nStartValue));
                                this.sCurrentListLabel = counter.restart(nLevel, nStartValue).getLabel();
                            }
                        }
                        this.traverseListItem(child, nLevel, styleName, item);
                    }
                }
                if (!nodeName.equals("text:list-header")) continue;
                Element item = this.converter.createElement("li");
                hnode.appendChild(item);
                item.setAttribute("style", "list-style-type:none");
                this.traverseListItem(child, nLevel, styleName, item);
            }
        }
    }

    private void traverseListItem(Node onode, int nLevel, String styleName, Node hnode) {
        if (this.config.xhtmlFormatting() != 3 && onode.hasChildNodes()) {
            int i;
            NodeList list = onode.getChildNodes();
            int nLen = list.getLength();
            int nParCount = 0;
            boolean bNoPTag = true;
            for (i = 0; i < nLen; ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                if (list.item(i).getNodeName().equals("text:p")) {
                    ++nParCount;
                    if (!bNoPTag) continue;
                    String sDisplayName = this.ofr.getParStyles().getDisplayName(Misc.getAttribute(list.item(0), "text:style-name"));
                    if (!this.config.getXParStyleMap().contains(sDisplayName)) continue;
                    bNoPTag = false;
                    continue;
                }
                bNoPTag = false;
            }
            if (bNoPTag && nParCount <= 1) {
                for (i = 0; i < nLen; ++i) {
                    Node child = list.item(i);
                    if (child.getNodeType() != 1) continue;
                    String nodeName = child.getNodeName();
                    if (nodeName.equals("text:p")) {
                        this.traverseInlineText(child, hnode);
                    }
                    if (nodeName.equals("text:list")) {
                        this.handleList(child, nLevel + 1, styleName, hnode);
                    }
                    if (nodeName.equals("text:ordered-list")) {
                        this.handleOL(child, nLevel + 1, styleName, hnode);
                    }
                    if (!nodeName.equals("text:unordered-list")) continue;
                    this.handleUL(child, nLevel + 1, styleName, hnode);
                }
                return;
            }
        }
        this.traverseBlockText(onode, nLevel, styleName, hnode);
    }

    private boolean listIsOnlyHeadings(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName;
            if (child.getNodeType() != 1 || !((nodeName = child.getNodeName()).equals("text:list-item") ? !this.itemIsOnlyHeadings(child) : nodeName.equals("text:list-header") && !this.itemIsOnlyHeadings(child))) continue;
            return false;
        }
        return true;
    }

    private boolean itemIsOnlyHeadings(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName;
            if (child.getNodeType() != 1 || !((nodeName = child.getNodeName()).equals("text:list") ? !this.listIsOnlyHeadings(child) : (nodeName.equals("text:ordered-list") ? !this.listIsOnlyHeadings(child) : (nodeName.equals("text:unordered-list") ? !this.listIsOnlyHeadings(child) : !nodeName.equals("text:h"))))) continue;
            return false;
        }
        return true;
    }

    private Node handleFakeList(Node onode, int nLevel, String sStyleName, Node hnode) {
        String sStyleName1 = Misc.getAttribute(onode, "text:style-name");
        if (sStyleName1 != null) {
            sStyleName = sStyleName1;
        }
        return this.traverseFakeList(onode, hnode, nLevel, sStyleName);
    }

    private Node traverseFakeList(Node onode, Node hnode, int nLevel, String sStyleName) {
        boolean bContinueNumbering = "true".equals(Misc.getAttribute(onode, "text:continue-numbering"));
        if (!bContinueNumbering) {
            this.getListCounter(this.ofr.getListStyle(sStyleName)).restart(nLevel);
        }
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sNodeName = child.getNodeName();
            if (sNodeName.equals("text:list-item")) {
                boolean bRestart = "true".equals(Misc.getAttribute(child, "text:restart-numbering"));
                int nStartValue = Misc.getPosInteger(Misc.getAttribute(child, "text:start-value"), 1);
                hnode = this.traverseFakeListItem(child, hnode, nLevel, sStyleName, false, bRestart, nStartValue);
                continue;
            }
            if (!sNodeName.equals("text:list-header")) continue;
            hnode = this.traverseFakeListItem(child, hnode, nLevel, sStyleName, true, false, 0);
        }
        return hnode;
    }

    private Node traverseFakeListItem(Node onode, Node hnode, int nLevel, String sStyleName, boolean bUnNumbered, boolean bRestart, int nStartValue) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            String sNodeName = child.getNodeName();
            if (sNodeName.equals("text:h")) {
                ++this.nDontSplitLevel;
                int nOutlineLevel = this.getOutlineLevel((Element)onode);
                Node rememberNode = hnode;
                StyleWithProperties style = this.ofr.getParStyle(Misc.getAttribute(child, "text:style-name"));
                hnode = this.maybeSplit(hnode, style, nOutlineLevel);
                this.handleHeading((Element)child, hnode, rememberNode != hnode, this.ofr.getListStyle(sStyleName), nLevel, bUnNumbered, bRestart, nStartValue);
                --this.nDontSplitLevel;
                if (this.nDontSplitLevel != 0) continue;
                this.bAfterHeading = true;
                continue;
            }
            if (sNodeName.equals("text:p")) continue;
            if (sNodeName.equals("text:list")) {
                return this.traverseFakeList(child, hnode, nLevel + 1, sStyleName);
            }
            if (sNodeName.equals("text:ordered-list")) {
                return this.traverseFakeList(child, hnode, nLevel + 1, sStyleName);
            }
            if (!sNodeName.equals("text:unordered-list")) continue;
            return this.traverseFakeList(child, hnode, nLevel + 1, sStyleName);
        }
        return hnode;
    }

    private void handleTOC(Node onode, Node hnode) {
        if (!this.config.includeToc()) {
            return;
        }
        if (!this.ofr.getTocReader((Element)onode).isByChapter()) {
            this.nTocFileIndex = this.converter.getOutFileIndex();
        }
        this.converter.setTocFile(null);
        Element div = this.converter.createElement("div");
        hnode.appendChild(div);
        IndexData data = new IndexData();
        data.nOutFileIndex = this.converter.getOutFileIndex();
        data.onode = (Element)onode;
        data.chapter = this.currentChapter;
        data.hnode = div;
        this.indexes.add(data);
    }

    private void generateToc(IndexData data) {
        TocEntry entry;
        int i;
        Element title;
        if (!this.config.includeToc()) {
            return;
        }
        Element onode = data.onode;
        Element chapter = data.chapter;
        Element div = data.hnode;
        int nSaveOutFileIndex = this.converter.getOutFileIndex();
        this.converter.changeOutFile(data.nOutFileIndex);
        this.bInToc = true;
        TocReader tocReader = this.ofr.getTocReader(onode);
        StyleInfo sectionInfo = new StyleInfo();
        this.getSectionSc().applyStyle(tocReader.getStyleName(), sectionInfo);
        this.applyStyle(sectionInfo, div);
        if (tocReader.getName() != null) {
            this.converter.addTarget(div, tocReader.getName());
        }
        if ((title = tocReader.getIndexTitleTemplate()) != null) {
            String sStyleName = Misc.getAttribute(title, "text:style-name");
            Element p = this.createParagraph(div, sStyleName);
            this.traversePCDATA(title, p);
        }
        String[] sEntryStyleName = new String[11];
        for (int i2 = 1; i2 <= 10; ++i2) {
            Element entryTemplate = tocReader.getTocEntryTemplate(i2);
            if (entryTemplate == null) continue;
            sEntryStyleName[i2] = Misc.getAttribute(entryTemplate, "text:style-name");
        }
        int nStart = 0;
        int nLen = this.tocEntries.size();
        if (tocReader.isByChapter() && chapter != null) {
            for (i = 0; i < nLen; ++i) {
                entry = this.tocEntries.get(i);
                if (entry.onode != chapter) continue;
                nStart = i;
                break;
            }
        }
        for (i = nStart; i < nLen; ++i) {
            Element a;
            Element p;
            Element a2;
            entry = this.tocEntries.get(i);
            String sNodeName = entry.onode.getTagName();
            if ("text:h".equals(sNodeName)) {
                int nLevel = this.getOutlineLevel(entry.onode);
                if (nLevel == 1 && tocReader.isByChapter() && entry.onode != chapter) break;
                if (tocReader.useOutlineLevel() && nLevel <= tocReader.getOutlineLevel()) {
                    Element p2 = this.createParagraph(div, sEntryStyleName[nLevel]);
                    if (entry.sLabel != null) {
                        Element span = this.converter.createElement("span");
                        p2.appendChild(span);
                        span.setAttribute("class", "SectionNumber");
                        span.appendChild(this.converter.createTextNode(entry.sLabel));
                    }
                    a2 = this.converter.createLink("toc" + i);
                    p2.appendChild(a2);
                    this.traverseInlineText(entry.onode, a2);
                    continue;
                }
                String sStyleName = this.getParSc().getRealParStyleName(entry.onode.getAttribute("text:style-name"));
                nLevel = tocReader.getIndexSourceStyleLevel(sStyleName);
                if (!tocReader.useIndexSourceStyles() || 1 > nLevel || nLevel > tocReader.getOutlineLevel()) continue;
                p = this.createParagraph(div, sEntryStyleName[nLevel]);
                if (entry.sLabel != null) {
                    p.appendChild(this.converter.createTextNode(entry.sLabel));
                }
                a = this.converter.createLink("toc" + i);
                p.appendChild(a);
                this.traverseInlineText(entry.onode, a);
                continue;
            }
            if ("text:p".equals(sNodeName)) {
                String sStyleName = this.getParSc().getRealParStyleName(entry.onode.getAttribute("text:style-name"));
                int nLevel = tocReader.getIndexSourceStyleLevel(sStyleName);
                if (!tocReader.useIndexSourceStyles() || 1 > nLevel || nLevel > tocReader.getOutlineLevel()) continue;
                p = this.createParagraph(div, sEntryStyleName[nLevel]);
                if (entry.sLabel != null) {
                    p.appendChild(this.converter.createTextNode(entry.sLabel));
                }
                a = this.converter.createLink("toc" + i);
                p.appendChild(a);
                this.traverseInlineText(entry.onode, a);
                continue;
            }
            if ("text:toc-mark".equals(sNodeName)) {
                int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
                if (!tocReader.useIndexMarks() || nLevel > tocReader.getOutlineLevel()) continue;
                Element p3 = this.createParagraph(div, sEntryStyleName[nLevel]);
                a2 = this.converter.createLink("toc" + i);
                p3.appendChild(a2);
                a2.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
                continue;
            }
            if (!"text:toc-mark-start".equals(sNodeName)) continue;
            int nLevel = Misc.getPosInteger(entry.onode.getAttribute("text:outline-level"), 1);
            if (!tocReader.useIndexMarks() || nLevel > tocReader.getOutlineLevel()) continue;
            Element p4 = this.createParagraph(div, sEntryStyleName[nLevel]);
            a2 = this.converter.createLink("toc" + i);
            p4.appendChild(a2);
            a2.appendChild(this.converter.createTextNode(IndexMark.getIndexValue(entry.onode)));
        }
        this.bInToc = false;
        this.converter.changeOutFile(nSaveOutFileIndex);
    }

    private void handleLOF(Node onode, Node hnode) {
    }

    private void handleLOT(Node onode, Node hnode) {
    }

    private void handleObjectIndex(Node onode, Node hnode) {
    }

    private void handleUserIndex(Node onode, Node hnode) {
    }

    private void handleAlphabeticalIndex(Node onode, Node hnode) {
        this.nAlphabeticalIndex = this.converter.getOutFileIndex();
        this.converter.setIndexFile(null);
        Element source = Misc.getChildByTagName(onode, "text:alphabetical-index-source");
        if (source != null) {
            Collator collator;
            String sLanguage;
            int i;
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "alphabeticalindex");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(source, "text:index-title-template");
            if (title != null) {
                String sStyleName = Misc.getAttribute((Node)title, "text:style-name");
                Element p = this.createParagraph(div, sStyleName);
                this.traversePCDATA(title, p);
            }
            String sEntryStyleName = null;
            if (source.hasChildNodes()) {
                NodeList nl = source.getChildNodes();
                int nLen = nl.getLength();
                for (i = 0; i < nLen; ++i) {
                    int nLevel;
                    Node child = nl.item(i);
                    if (child.getNodeType() != 1 || !child.getNodeName().equals("text:alphabetical-index-entry-template") || (nLevel = Misc.getPosInteger(Misc.getAttribute(child, "text:outline-level"), 1)) != 1) continue;
                    sEntryStyleName = Misc.getAttribute(child, "text:style-name");
                }
            }
            if ((sLanguage = Misc.getAttribute((Node)source, "fo:language")) == null) {
                collator = Collator.getInstance();
            } else {
                String sCountry = Misc.getAttribute((Node)source, "fo:country");
                if (sCountry == null) {
                    sCountry = "";
                }
                collator = Collator.getInstance(new Locale(sLanguage, sCountry));
            }
            for (i = 0; i <= this.nIndexIndex; ++i) {
                for (int j = i + 1; j <= this.nIndexIndex; ++j) {
                    AlphabeticalEntry entryi = this.index.get(i);
                    AlphabeticalEntry entryj = this.index.get(j);
                    if (collator.compare(entryi.sWord, entryj.sWord) <= 0) continue;
                    this.index.set(i, entryj);
                    this.index.set(j, entryi);
                }
            }
            Element table = this.converter.createElement("table");
            table.setAttribute("style", "width:100%");
            div.appendChild(table);
            Element tr = this.converter.createElement("tr");
            table.appendChild(tr);
            Element[] td = new Element[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                td[i2] = this.converter.createElement("td");
                td[i2].setAttribute("style", "vertical-align:top");
                tr.appendChild(td[i2]);
            }
            int nColEntries = this.nIndexIndex / 4 + 1;
            int nColIndex = -1;
            for (int i3 = 0; i3 <= this.nIndexIndex; ++i3) {
                if (i3 % nColEntries == 0) {
                    ++nColIndex;
                }
                AlphabeticalEntry entry = this.index.get(i3);
                Element p = this.createParagraph(td[nColIndex], sEntryStyleName);
                Element a = this.converter.createLink("idx" + entry.nIndex);
                p.appendChild(a);
                a.appendChild(this.converter.createTextNode(entry.sWord));
            }
        }
    }

    private void handleBibliography(Node onode, Node hnode) {
        Element body = Misc.getChildByTagName(onode, "text:index-body");
        if (body != null) {
            Element div = this.converter.createElement("div");
            this.converter.addTarget(div, "bibliography");
            hnode.appendChild(div);
            Element title = Misc.getChildByTagName(body, "text:index-title");
            if (title != null) {
                this.traverseBlockText(title, div);
            }
            this.traverseBlockText(body, div);
        }
    }

    private void traverseFloats(Node onode, Node hnodeBlock, Node hnodeInline) {
        for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element elm = (Element)child;
            if (OfficeReader.isDrawElement(elm)) {
                elm = this.getDrawCv().getRealDrawElement(elm);
                String sAnchor = elm.getAttribute("text:anchor-type");
                if (Misc.isElement(elm, "draw:frame")) {
                    elm = Misc.getFirstChildElement(elm);
                }
                if (elm == null) continue;
                String sTag = elm.getTagName();
                if (!"as-char".equals(sAnchor)) {
                    this.getDrawCv().handleDrawElement(elm, (Element)hnodeBlock, (Element)hnodeInline, this.nFloatMode);
                    continue;
                }
                if (!"draw:text-box".equals(sTag)) continue;
                this.getDrawCv().handleDrawElement(elm, (Element)hnodeBlock, (Element)hnodeInline, 0);
                continue;
            }
            if (!OfficeReader.isTextElement(elm) || OfficeReader.isNoteElement(elm)) continue;
            this.traverseFloats(elm, hnodeBlock, hnodeInline);
        }
    }

    private void traverseInlineText(Node onode, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nList = onode.getChildNodes();
            int nLen = nList.getLength();
            block4: for (int i = 0; i < nLen; ++i) {
                Node child = nList.item(i);
                short nodeType = child.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = child.getNodeValue();
                        if (s.length() <= 0) continue block4;
                        hnode.appendChild(this.converter.createTextNode(s));
                        continue block4;
                    }
                    case 1: {
                        String sName = child.getNodeName();
                        if (OfficeReader.isDrawElement(child)) {
                            String sAnchor;
                            Element elm = this.getDrawCv().getRealDrawElement((Element)child);
                            if (elm == null || !"as-char".equals(sAnchor = elm.getAttribute("text:anchor-type"))) continue block4;
                            this.getDrawCv().handleDrawElement(elm, null, (Element)hnode, 0);
                            continue block4;
                        }
                        if (child.getNodeName().equals("text:s")) {
                            if (this.config.ignoreDoubleSpaces()) {
                                hnode.appendChild(this.converter.createTextNode(" "));
                                continue block4;
                            }
                            for (int count = Misc.getPosInteger(Misc.getAttribute(child, "text:c"), 1); count > 0; --count) {
                                hnode.appendChild(this.converter.createTextNode("\u00a0"));
                            }
                            continue block4;
                        }
                        if (sName.equals("text:tab-stop")) {
                            this.handleTabStop(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:tab")) {
                            this.handleTabStop(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:line-break")) {
                            if (this.config.ignoreHardLineBreaks()) continue block4;
                            hnode.appendChild(this.converter.createElement("br"));
                            continue block4;
                        }
                        if (sName.equals("text:span")) {
                            this.handleSpan(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:a")) {
                            this.handleAnchor(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:footnote")) {
                            this.handleFootnote(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:endnote")) {
                            this.handleEndnote(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:note")) {
                            if ("endnote".equals(Misc.getAttribute(child, "text:note-class"))) {
                                this.handleEndnote(child, hnode);
                                continue block4;
                            }
                            this.handleFootnote(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:sequence")) {
                            this.handleSequence(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:page-number")) {
                            this.handlePageNumber(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:page-count")) {
                            this.handlePageCount(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:sequence-ref")) {
                            this.handleSequenceRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:footnote-ref")) {
                            this.handleNoteRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:endnote-ref")) {
                            this.handleNoteRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:note-ref")) {
                            this.handleNoteRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.handleReferenceMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.handleReferenceMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:reference-ref")) {
                            this.handleReferenceRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.handleBookmark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.handleBookmark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bookmark-ref")) {
                            this.handleBookmarkRef(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.handleAlphabeticalIndexMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.handleAlphabeticalIndexMarkStart(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:toc-mark")) {
                            this.handleTocMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:toc-mark-start")) {
                            this.handleTocMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:bibliography-mark")) {
                            this.handleBibliographyMark(child, hnode);
                            continue block4;
                        }
                        if (sName.equals("text:soft-page-break")) {
                            if (this.nPageBreakSplit != 3) continue block4;
                            this.bPendingPageBreak = true;
                            continue block4;
                        }
                        if (sName.equals("office:annotation")) {
                            this.converter.handleOfficeAnnotation(child, hnode);
                            continue block4;
                        }
                        if (!sName.startsWith("text:")) continue block4;
                        this.traverseInlineText(child, hnode);
                        continue block4;
                    }
                }
            }
        }
    }

    private void handleTabStop(Node onode, Node hnode) {
        if (this.config.getXhtmlTabstopStyle().length() > 0) {
            Element span = this.converter.createElement("span");
            hnode.appendChild(span);
            span.setAttribute("class", this.config.getXhtmlTabstopStyle());
            span.appendChild(this.converter.createTextNode("\t"));
        } else {
            hnode.appendChild(this.converter.createTextNode("\t"));
        }
    }

    private void handleSpan(Node onode, Node hnode) {
        StyleWithProperties style = this.ofr.getTextStyle(Misc.getAttribute(onode, "text:style-name"));
        if (!this.bDisplayHiddenText && style != null && "none".equals(style.getProperty("text:display"))) {
            return;
        }
        if (!this.bInToc) {
            String sStyleName = Misc.getAttribute(onode, "text:style-name");
            Element span = this.createInline((Element)hnode, sStyleName);
            this.traverseInlineText(onode, span);
        } else {
            this.traverseInlineText(onode, hnode);
        }
    }

    private void traversePCDATA(Node onode, Node hnode) {
        if (onode.hasChildNodes()) {
            NodeList nl = onode.getChildNodes();
            int nLen = nl.getLength();
            for (int i = 0; i < nLen; ++i) {
                if (nl.item(i).getNodeType() != 3) continue;
                hnode.appendChild(this.converter.createTextNode(nl.item(i).getNodeValue()));
            }
        }
    }

    protected void handleAnchor(Node onode, Node hnode) {
        Element anchor = this.converter.createLink((Element)onode);
        hnode.appendChild(anchor);
        this.traverseInlineText(onode, anchor);
    }

    private void handleFootnote(Node onode, Node hnode) {
        String sId = Misc.getAttribute(onode, "text:id");
        Element span = this.createInline((Element)hnode, this.sFntCitBodyStyle);
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:footnote-citation");
        if (citation == null) {
            citation = Misc.getChildByTagName(onode, "text:note-citation");
        }
        this.traversePCDATA(citation, link);
        this.footnotes.add(onode);
    }

    private void insertFootnotes(Node hnode, boolean bFinal) {
        int n = this.footnotes.size();
        if (n > 0) {
            if (this.bFootnotesAtPage) {
                Element rule = this.converter.createElement("hr");
                StyleInfo info = new StyleInfo();
                this.getPageSc().applyFootnoteRuleStyle(info);
                this.getPageSc().applyStyle(info, rule);
                hnode.appendChild(rule);
            } else if (bFinal) {
                if (this.nSplit > 0) {
                    hnode = this.converter.nextOutFile();
                }
                this.insertNoteHeading(hnode, this.config.getFootnotesHeading(), "footnotes");
            }
            if (bFinal || this.bFootnotesAtPage) {
                for (int i = 0; i < n; ++i) {
                    Element body;
                    Node footnote = this.footnotes.get(i);
                    String sId = Misc.getAttribute(footnote, "text:id");
                    Element citation = Misc.getChildByTagName(footnote, "text:footnote-citation");
                    if (citation == null) {
                        citation = Misc.getChildByTagName(footnote, "text:note-citation");
                    }
                    if ((body = Misc.getChildByTagName(footnote, "text:footnote-body")) == null) {
                        body = Misc.getChildByTagName(footnote, "text:note-body");
                    }
                    this.traverseNoteBody(sId, this.sFntCitStyle, citation, body, hnode, this.ofr.getFootnotesConfiguration());
                }
                this.footnotes.clear();
            }
        }
    }

    private void handleEndnote(Node onode, Node hnode) {
        String sId = Misc.getAttribute(onode, "text:id");
        Element span = this.createInline((Element)hnode, this.sEntCitBodyStyle);
        Element link = this.converter.createLink(sId);
        this.converter.addTarget(link, "body" + sId);
        span.appendChild(link);
        Element citation = Misc.getChildByTagName(onode, "text:endnote-citation");
        if (citation == null) {
            citation = Misc.getChildByTagName(onode, "text:note-citation");
        }
        this.traversePCDATA(citation, link);
        this.endnotes.add(onode);
    }

    private void insertEndnotes(Node hnode) {
        int n = this.endnotes.size();
        if (n > 0) {
            if (this.nSplit > 0) {
                hnode = this.converter.nextOutFile();
            }
            this.insertNoteHeading(hnode, this.config.getEndnotesHeading(), "endnotes");
            for (int i = 0; i < n; ++i) {
                Element body;
                Node endnote = this.endnotes.get(i);
                String sId = Misc.getAttribute(endnote, "text:id");
                Element citation = Misc.getChildByTagName(endnote, "text:endnote-citation");
                if (citation == null) {
                    citation = Misc.getChildByTagName(endnote, "text:note-citation");
                }
                if ((body = Misc.getChildByTagName(endnote, "text:endnote-body")) == null) {
                    body = Misc.getChildByTagName(endnote, "text:note-body");
                }
                this.traverseNoteBody(sId, this.sEntCitStyle, citation, body, hnode, this.ofr.getEndnotesConfiguration());
            }
        }
    }

    private void insertNoteHeading(Node hnode, String sHeading, String sTarget) {
        if (sHeading.length() > 0) {
            Element heading = this.converter.createElement("h1");
            hnode.appendChild(heading);
            heading.appendChild(this.converter.createTextNode(sHeading));
            if (this.nSplit > 0) {
                this.converter.addContentEntry(sHeading, 1, null);
            } else {
                this.converter.addTarget(heading, sTarget);
                this.converter.addContentEntry(sHeading, 1, sTarget);
            }
        }
    }

    private void traverseNoteBody(String sId, String sCitStyle, Node citation, Node onode, Node hnode, PropertySet noteConfig) {
        Element link = this.converter.createLink("body" + sId);
        this.converter.addTarget(link, sId);
        StyleInfo linkInfo = new StyleInfo();
        this.getTextSc().applyStyle(sCitStyle, linkInfo);
        this.applyStyle(linkInfo, link);
        String sPrefix = noteConfig.getProperty("style:num-prefix");
        if (sPrefix != null) {
            link.appendChild(this.converter.createTextNode(sPrefix));
        }
        this.traversePCDATA(citation, link);
        String sSuffix = noteConfig.getProperty("style:num-suffix");
        if (sSuffix != null) {
            link.appendChild(this.converter.createTextNode(sSuffix));
        }
        Element span = this.converter.createElement("span");
        span.appendChild(link);
        span.appendChild(this.converter.createTextNode(" "));
        this.asapNode = span;
        this.traverseBlockText(onode, hnode);
    }

    private void handlePageNumber(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page number)"));
    }

    private void handlePageCount(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTextNode("(Page count)"));
    }

    private void handleSequence(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:ref-name");
        if (sName != null && !this.bInToc && this.ofr.hasSequenceRefTo(sName)) {
            Element anchor = this.converter.createTarget("seq" + sName);
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        } else {
            this.traversePCDATA(onode, hnode);
        }
    }

    private void createReference(Node onode, Node hnode, String sPrefix) {
        String sFormat = Misc.getAttribute(onode, "text:reference-format");
        String sName = Misc.getAttribute(onode, "text:ref-name");
        Element anchor = this.converter.createLink(sPrefix + sName);
        hnode.appendChild(anchor);
        if ("page".equals(sFormat)) {
            anchor.appendChild(this.converter.createTextNode("1"));
        } else {
            this.traversePCDATA(onode, anchor);
        }
    }

    private void handleSequenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "seq");
    }

    private void handleNoteRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "");
    }

    private void handleReferenceMark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc && this.ofr.hasReferenceRefTo(sName)) {
            hnode.appendChild(this.converter.createTarget("ref" + sName));
        }
    }

    private void handleReferenceRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "ref");
    }

    private void handleBookmark(Node onode, Node hnode) {
        String sName = Misc.getAttribute(onode, "text:name");
        if (sName != null && !this.bInToc) {
            hnode.appendChild(this.converter.createTarget(sName));
            if (this.ofr.hasBookmarkRefTo(sName)) {
                hnode.appendChild(this.converter.createTarget("bkm" + sName));
            }
        }
    }

    private void handleBookmarkRef(Node onode, Node hnode) {
        this.createReference(onode, hnode, "bkm");
    }

    private void handleAlphabeticalIndexMark(Node onode, Node hnode) {
        if (this.bInToc) {
            return;
        }
        String sWord = Misc.getAttribute(onode, "text:string-value");
        if (sWord == null) {
            return;
        }
        AlphabeticalEntry entry = new AlphabeticalEntry();
        entry.sWord = sWord;
        entry.nIndex = ++this.nIndexIndex;
        this.index.add(entry);
        hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
    }

    private void handleAlphabeticalIndexMarkStart(Node onode, Node hnode) {
        if (this.bInToc) {
            return;
        }
        String sWord = IndexMark.getIndexValue(onode);
        if (sWord == null) {
            return;
        }
        AlphabeticalEntry entry = new AlphabeticalEntry();
        entry.sWord = sWord;
        entry.nIndex = ++this.nIndexIndex;
        this.index.add(entry);
        hnode.appendChild(this.converter.createTarget("idx" + this.nIndexIndex));
    }

    private void handleTocMark(Node onode, Node hnode) {
        hnode.appendChild(this.converter.createTarget("toc" + ++this.nTocIndex));
        TocEntry entry = new TocEntry();
        entry.onode = (Element)onode;
        entry.nFileIndex = this.converter.getOutFileIndex();
        this.tocEntries.add(entry);
    }

    private void handleBibliographyMark(Node onode, Node hnode) {
        if (this.bInToc) {
            this.traversePCDATA(onode, hnode);
        } else {
            Element anchor = this.converter.createLink("bibliography");
            hnode.appendChild(anchor);
            this.traversePCDATA(onode, anchor);
        }
    }

    private boolean isBold(StyleWithProperties style) {
        String s = style.getProperty("fo:font-weight", false);
        return s != null && "bold".equals(s);
    }

    private boolean isItalics(StyleWithProperties style) {
        String s = style.getProperty("fo:font-style", false);
        return s != null && !"normal".equals(s);
    }

    private boolean isFixed(StyleWithProperties style) {
        String s = style.getProperty("style:font-name", false);
        String s2 = null;
        String s3 = null;
        if (s != null) {
            FontDeclaration fd = (FontDeclaration)this.ofr.getFontDeclarations().getStyle(s);
            if (fd != null) {
                s2 = fd.getFontFamilyGeneric();
                s3 = fd.getFontPitch();
            }
        } else {
            s = style.getProperty("fo:font-family", false);
            s2 = style.getProperty("style:font-family-generic", false);
            s3 = style.getProperty("style:font-pitch", false);
        }
        if ("fixed".equals(s3)) {
            return true;
        }
        return "modern".equals(s2);
    }

    private boolean isSuperscript(StyleWithProperties style) {
        String sPos = style.getProperty("style:text-position", false);
        if (sPos == null) {
            return false;
        }
        if (sPos.startsWith("sub")) {
            return false;
        }
        if (sPos.startsWith("-")) {
            return false;
        }
        return !sPos.startsWith("0%");
    }

    private boolean isSubscript(StyleWithProperties style) {
        String sPos = style.getProperty("style:text-position", false);
        if (sPos == null) {
            return false;
        }
        if (sPos.startsWith("sub")) {
            return true;
        }
        return sPos.startsWith("-");
    }

    private boolean isUnderline(StyleWithProperties style) {
        String s = this.ofr.isOpenDocument() ? style.getProperty("style:text-underline-style", false) : style.getProperty("style:text-underline", false);
        return s != null && !"none".equals(s);
    }

    private boolean isOverstrike(StyleWithProperties style) {
        String s = this.ofr.isOpenDocument() ? style.getProperty("style:text-line-through-style", false) : style.getProperty("style:text-crossing-out", false);
        return s != null && !"none".equals(s);
    }

    private Element applyAttributes(Element node, StyleWithProperties style) {
        if (this.config.xhtmlFormatting() == 3 || this.config.xhtmlFormatting() == 1) {
            return node;
        }
        if (style == null) {
            return node;
        }
        if (!style.isAutomatic()) {
            return node;
        }
        node = this.applyAttribute(node, "bold", this.isBold(style));
        node = this.applyAttribute(node, "italics", this.isItalics(style));
        node = this.applyAttribute(node, "fixed", this.isFixed(style));
        node = this.applyAttribute(node, "superscript", this.isSuperscript(style));
        node = this.applyAttribute(node, "subscript", this.isSubscript(style));
        node = this.applyAttribute(node, "underline", this.isUnderline(style));
        node = this.applyAttribute(node, "overstrike", this.isOverstrike(style));
        return node;
    }

    private Element applyAttribute(Element node, String sAttr, boolean bApply) {
        XhtmlStyleMap xattr;
        if (bApply && (xattr = this.config.getXAttrStyleMap()).contains(sAttr) && xattr.getElement(sAttr).length() > 0) {
            Element attr = this.converter.createElement(xattr.getElement(sAttr));
            if (!"(none)".equals(xattr.getCss(sAttr))) {
                attr.setAttribute("class", xattr.getCss(sAttr));
            }
            node.appendChild(attr);
            return attr;
        }
        return node;
    }

    private Element createParagraph(Element node, String sStyleName) {
        StyleInfo info = new StyleInfo();
        this.getParSc().applyStyle(sStyleName, info);
        Element par = this.converter.createElement(info.sTagName);
        node.appendChild(par);
        this.applyStyle(info, par);
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style != null && style.isAutomatic()) {
            return this.applyAttributes(par, style);
        }
        return par;
    }

    private Element createTextBackground(Element node, String sStyleName) {
        if (this.config.xhtmlFormatting() == 0 || this.config.xhtmlFormatting() == 2) {
            return node;
        }
        String sBack = this.getParSc().getTextBackground(sStyleName);
        if (sBack.length() > 0) {
            Element span = this.converter.createElement("span");
            span.setAttribute("style", sBack);
            node.appendChild(span);
            return span;
        }
        return node;
    }

    private Element createInline(Element node, String sStyleName) {
        StyleInfo info = new StyleInfo();
        this.getTextSc().applyStyle(sStyleName, info);
        Element newNode = node;
        if (info.hasAttributes() || !"span".equals(info.sTagName)) {
            newNode = this.converter.createElement(info.sTagName);
            this.applyStyle(info, newNode);
            Node prev = node.getLastChild();
            if (prev != null && Misc.isElement(prev, info.sTagName)) {
                Element prevNode = (Element)prev;
                if (newNode.getAttribute("class").equals(prevNode.getAttribute("class")) && newNode.getAttribute("style").equals(prevNode.getAttribute("style")) && newNode.getAttribute("xml:lang").equals(prevNode.getAttribute("xml:lang")) && newNode.getAttribute("dir").equals(prevNode.getAttribute("dir"))) {
                    return this.applyAttributes(prevNode, this.ofr.getTextStyle(sStyleName));
                }
            }
            node.appendChild(newNode);
        }
        return this.applyAttributes(newNode, this.ofr.getTextStyle(sStyleName));
    }

    private int getOutlineLevel(Element node) {
        return this.ofr.isOpenDocument() ? Misc.getPosInteger(node.getAttribute("text:outline-level"), 1) : Misc.getPosInteger(node.getAttribute("text:level"), 1);
    }
}

