/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.analyzing.AnalyzingQueryParser;
import org.apache.lucene.queryparser.classic.ExistsFieldQueryExtension;
import org.apache.lucene.queryparser.classic.FieldQueryExtension;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserSettings;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.GraphQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.LegacyDateFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MapperQueryParser
extends AnalyzingQueryParser {
    public static final Map<String, FieldQueryExtension> FIELD_QUERY_EXTENSIONS;
    private final QueryShardContext context;
    private QueryParserSettings settings;
    private MappedFieldType currentFieldType;

    public MapperQueryParser(QueryShardContext context) {
        super(null, null);
        this.context = context;
    }

    public void reset(QueryParserSettings settings) {
        this.settings = settings;
        this.field = settings.fieldsAndWeights().isEmpty() ? settings.defaultField() : (settings.fieldsAndWeights().size() == 1 ? settings.fieldsAndWeights().keySet().iterator().next() : null);
        this.setAnalyzer(settings.analyzer());
        this.setMultiTermRewriteMethod(settings.rewriteMethod());
        this.setEnablePositionIncrements(settings.enablePositionIncrements());
        this.setAutoGeneratePhraseQueries(settings.autoGeneratePhraseQueries());
        this.setMaxDeterminizedStates(settings.maxDeterminizedStates());
        this.setAllowLeadingWildcard(settings.allowLeadingWildcard());
        this.setLowercaseExpandedTerms(false);
        this.setPhraseSlop(settings.phraseSlop());
        this.setDefaultOperator(settings.defaultOperator());
        this.setFuzzyPrefixLength(settings.fuzzyPrefixLength());
        this.setSplitOnWhitespace(settings.splitOnWhitespace());
    }

    Query handleBareFuzzy(String qfield, Token fuzzySlop, String termImage) throws ParseException {
        if (fuzzySlop.image.length() == 1) {
            return this.getFuzzyQuery(qfield, termImage, Float.toString(this.settings.fuzziness().asDistance(termImage)));
        }
        return this.getFuzzyQuery(qfield, termImage, fuzzySlop.image.substring(1));
    }

    protected Query newTermQuery(Term term) {
        Query termQuery;
        if (this.currentFieldType != null && (termQuery = this.currentFieldType.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return super.newTermQuery(term);
    }

    protected Query newMatchAllDocsQuery() {
        return Queries.newMatchAllQuery();
    }

    public Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        FieldQueryExtension fieldQueryExtension = FIELD_QUERY_EXTENSIONS.get(field);
        if (fieldQueryExtension != null) {
            return fieldQueryExtension.query(this.context, queryText);
        }
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getFieldQuerySingle(fields.iterator().next(), queryText, quoted);
            }
            if (this.settings.useDisMax()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getFieldQuerySingle(mField, queryText, quoted);
                    if (q == null) continue;
                    added = true;
                    queries.add(this.applyBoost(mField, q));
                }
                if (!added) {
                    return null;
                }
                return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getFieldQuerySingle(mField, queryText, quoted);
                if (q == null) continue;
                clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
            }
            if (clauses.isEmpty()) {
                return null;
            }
            return this.getBooleanQueryCoordDisabled(clauses);
        }
        return this.getFieldQuerySingle(field, queryText, quoted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query getFieldQuerySingle(String field, String queryText, boolean quoted) throws ParseException {
        if (!quoted && queryText.length() > 1) {
            if (queryText.charAt(0) == '>') {
                if (queryText.length() <= 2) return this.getRangeQuerySingle(field, queryText.substring(1), null, false, true, this.context);
                if (queryText.charAt(1) != '=') return this.getRangeQuerySingle(field, queryText.substring(1), null, false, true, this.context);
                return this.getRangeQuerySingle(field, queryText.substring(2), null, true, true, this.context);
            }
            if (queryText.charAt(0) == '<') {
                if (queryText.length() <= 2) return this.getRangeQuerySingle(field, null, queryText.substring(1), true, false, this.context);
                if (queryText.charAt(1) != '=') return this.getRangeQuerySingle(field, null, queryText.substring(1), true, false, this.context);
                return this.getRangeQuerySingle(field, null, queryText.substring(2), true, true, this.context);
            }
        }
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            if (quoted) {
                this.setAnalyzer(this.settings.quoteAnalyzer());
                if (this.settings.quoteFieldSuffix() != null) {
                    this.currentFieldType = this.context.fieldMapper(field + this.settings.quoteFieldSuffix());
                }
            }
            if (this.currentFieldType == null) {
                this.currentFieldType = this.context.fieldMapper(field);
            }
            if (this.currentFieldType != null) {
                if (quoted) {
                    if (!this.settings.forceQuoteAnalyzer()) {
                        this.setAnalyzer(this.context.getSearchQuoteAnalyzer(this.currentFieldType));
                    }
                } else if (!this.settings.forceAnalyzer()) {
                    this.setAnalyzer(this.context.getSearchAnalyzer(this.currentFieldType));
                }
                if (this.currentFieldType != null) {
                    Query query = null;
                    if (!this.currentFieldType.tokenized()) {
                        try {
                            query = this.currentFieldType.termQuery(queryText, this.context);
                        }
                        catch (RuntimeException e) {
                            if (!this.settings.lenient()) throw e;
                            Query query2 = null;
                            this.setAnalyzer(oldAnalyzer);
                            return query2;
                        }
                    }
                    if (query == null) {
                        query = super.getFieldQuery(this.currentFieldType.name(), queryText, quoted);
                    }
                    Query query3 = query;
                    return query3;
                }
            }
            Query query = super.getFieldQuery(field, queryText, quoted);
            return query;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (this.settings.useDisMax()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                boolean added = false;
                for (String mField : fields) {
                    Query q = super.getFieldQuery(mField, queryText, slop);
                    if (q == null) continue;
                    added = true;
                    q = this.applySlop(q, slop);
                    queries.add(this.applyBoost(mField, q));
                }
                if (!added) {
                    return null;
                }
                return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = super.getFieldQuery(mField, queryText, slop);
                if (q == null) continue;
                q = this.applySlop(q, slop);
                clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
            }
            if (clauses.isEmpty()) {
                return null;
            }
            return this.getBooleanQueryCoordDisabled(clauses);
        }
        return super.getFieldQuery(field, queryText, slop);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        Collection<String> fields;
        if ("*".equals(part1)) {
            part1 = null;
        }
        if ("*".equals(part2)) {
            part2 = null;
        }
        if ((fields = this.extractMultiFields(field)) == null) {
            return this.getRangeQuerySingle(field, part1, part2, startInclusive, endInclusive, this.context);
        }
        if (fields.size() == 1) {
            return this.getRangeQuerySingle(fields.iterator().next(), part1, part2, startInclusive, endInclusive, this.context);
        }
        if (this.settings.useDisMax()) {
            ArrayList<Query> queries = new ArrayList<Query>();
            boolean added = false;
            for (String mField : fields) {
                Query q = this.getRangeQuerySingle(mField, part1, part2, startInclusive, endInclusive, this.context);
                if (q == null) continue;
                added = true;
                queries.add(this.applyBoost(mField, q));
            }
            if (!added) {
                return null;
            }
            return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        for (String mField : fields) {
            Query q = this.getRangeQuerySingle(mField, part1, part2, startInclusive, endInclusive, this.context);
            if (q == null) continue;
            clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
        }
        if (clauses.isEmpty()) {
            return null;
        }
        return this.getBooleanQueryCoordDisabled(clauses);
    }

    private Query getRangeQuerySingle(String field, String part1, String part2, boolean startInclusive, boolean endInclusive, QueryShardContext context) {
        this.currentFieldType = context.fieldMapper(field);
        if (this.currentFieldType != null) {
            try {
                Query rangeQuery;
                BytesRef part2Binary;
                BytesRef part1Binary = part1 == null ? null : this.getAnalyzer().normalize(field, part1);
                BytesRef bytesRef = part2Binary = part2 == null ? null : this.getAnalyzer().normalize(field, part2);
                if (this.currentFieldType instanceof LegacyDateFieldMapper.DateFieldType && this.settings.timeZone() != null) {
                    LegacyDateFieldMapper.DateFieldType dateFieldType = (LegacyDateFieldMapper.DateFieldType)this.currentFieldType;
                    rangeQuery = dateFieldType.rangeQuery(part1Binary, part2Binary, startInclusive, endInclusive, this.settings.timeZone(), null, context);
                } else if (this.currentFieldType instanceof DateFieldMapper.DateFieldType && this.settings.timeZone() != null) {
                    DateFieldMapper.DateFieldType dateFieldType = (DateFieldMapper.DateFieldType)this.currentFieldType;
                    rangeQuery = dateFieldType.rangeQuery(part1Binary, part2Binary, startInclusive, endInclusive, this.settings.timeZone(), null, context);
                } else {
                    rangeQuery = this.currentFieldType.rangeQuery(part1Binary, part2Binary, startInclusive, endInclusive, context);
                }
                return rangeQuery;
            }
            catch (RuntimeException e) {
                if (this.settings.lenient()) {
                    return null;
                }
                throw e;
            }
        }
        return this.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    protected Query getFuzzyQuery(String field, String termStr, String minSimilarity) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getFuzzyQuerySingle(fields.iterator().next(), termStr, minSimilarity);
            }
            if (this.settings.useDisMax()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getFuzzyQuerySingle(mField, termStr, minSimilarity);
                    if (q == null) continue;
                    added = true;
                    queries.add(this.applyBoost(mField, q));
                }
                if (!added) {
                    return null;
                }
                return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getFuzzyQuerySingle(mField, termStr, minSimilarity);
                if (q == null) continue;
                clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
            }
            return this.getBooleanQueryCoordDisabled(clauses);
        }
        return this.getFuzzyQuerySingle(field, termStr, minSimilarity);
    }

    private Query getFuzzyQuerySingle(String field, String termStr, String minSimilarity) throws ParseException {
        this.currentFieldType = this.context.fieldMapper(field);
        if (this.currentFieldType != null) {
            try {
                BytesRef term = termStr == null ? null : this.getAnalyzer().normalize(field, termStr);
                return this.currentFieldType.fuzzyQuery(term, Fuzziness.build(minSimilarity), this.getFuzzyPrefixLength(), this.settings.fuzzyMaxExpansions(), true);
            }
            catch (RuntimeException e) {
                if (this.settings.lenient()) {
                    return null;
                }
                throw e;
            }
        }
        return super.getFuzzyQuery(field, termStr, Float.parseFloat(minSimilarity));
    }

    protected Query newFuzzyQuery(Term term, float minimumSimilarity, int prefixLength) {
        String text = term.text();
        int numEdits = FuzzyQuery.floatToEdits((float)minimumSimilarity, (int)text.codePointCount(0, text.length()));
        FuzzyQuery query = new FuzzyQuery(term, numEdits, prefixLength, this.settings.fuzzyMaxExpansions(), true);
        QueryParsers.setRewriteMethod((MultiTermQuery)query, this.settings.fuzzyRewriteMethod());
        return query;
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getPrefixQuerySingle(fields.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getPrefixQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    queries.add(this.applyBoost(mField, q));
                }
                if (!added) {
                    return null;
                }
                return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getPrefixQuerySingle(mField, termStr);
                if (q == null) continue;
                clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
            }
            if (clauses.isEmpty()) {
                return null;
            }
            return this.getBooleanQueryCoordDisabled(clauses);
        }
        return this.getPrefixQuerySingle(field, termStr);
    }

    private Query getPrefixQuerySingle(String field, String termStr) throws ParseException {
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            this.currentFieldType = this.context.fieldMapper(field);
            if (this.currentFieldType != null) {
                if (!this.settings.forceAnalyzer()) {
                    this.setAnalyzer(this.context.getSearchAnalyzer(this.currentFieldType));
                }
                Query query = null;
                if (!(this.currentFieldType instanceof StringFieldType)) {
                    query = this.currentFieldType.prefixQuery(termStr, this.getMultiTermRewriteMethod(), this.context);
                }
                if (query == null) {
                    query = this.getPossiblyAnalyzedPrefixQuery(this.currentFieldType.name(), termStr);
                }
                Query query2 = query;
                return query2;
            }
            Query query = this.getPossiblyAnalyzedPrefixQuery(field, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Query getPossiblyAnalyzedPrefixQuery(String field, String termStr) throws ParseException {
        ArrayList tlist;
        block26: {
            if (!this.settings.analyzeWildcard()) {
                return super.getPrefixQuery(field, termStr);
            }
            TokenStream source = null;
            try {
                try {
                    source = this.getAnalyzer().tokenStream(field, termStr);
                    source.reset();
                }
                catch (IOException e) {
                    Query query = super.getPrefixQuery(field, termStr);
                    if (source != null) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
                    }
                    return query;
                }
            }
            catch (Throwable throwable) {
                if (source != null) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
                }
                throw throwable;
            }
            {
                block25: {
                    tlist = new ArrayList();
                    ArrayList<String> currentPos = new ArrayList<String>();
                    CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
                    PositionIncrementAttribute posAtt = (PositionIncrementAttribute)source.addAttribute(PositionIncrementAttribute.class);
                    while (true) {
                        block24: {
                            try {
                                if (!source.incrementToken()) {
                                }
                                break block24;
                            }
                            catch (IOException e) {}
                            if (!currentPos.isEmpty()) {
                                break;
                            }
                            break block25;
                        }
                        if (!currentPos.isEmpty() && posAtt.getPositionIncrement() > 0) {
                            tlist.add(currentPos);
                            currentPos = new ArrayList();
                        }
                        currentPos.add(termAtt.toString());
                    }
                    tlist.add(currentPos);
                }
                if (source == null) break block26;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{source});
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1 && ((List)tlist.get(0)).size() == 1) {
            return super.getPrefixQuery(field, (String)((List)tlist.get(0)).get(0));
        }
        ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
        int pos = 0;
        while (pos < tlist.size()) {
            Query posQuery;
            boolean isLastPos;
            List plist = (List)tlist.get(pos);
            boolean bl = isLastPos = pos == tlist.size() - 1;
            if (plist.size() == 1) {
                posQuery = isLastPos ? super.getPrefixQuery(field, (String)plist.get(0)) : this.newTermQuery(new Term(field, (String)plist.get(0)));
            } else if (!isLastPos) {
                Term[] terms = new Term[plist.size()];
                for (int i = 0; i < plist.size(); ++i) {
                    terms[i] = new Term(field, (String)plist.get(i));
                }
                posQuery = new SynonymQuery(terms);
            } else {
                ArrayList<BooleanClause> innerClauses = new ArrayList<BooleanClause>();
                for (String token : plist) {
                    innerClauses.add(new BooleanClause(super.getPrefixQuery(field, token), BooleanClause.Occur.SHOULD));
                }
                posQuery = this.getBooleanQueryCoordDisabled(innerClauses);
            }
            clauses.add(new BooleanClause(posQuery, this.getDefaultOperator() == QueryParser.Operator.AND ? BooleanClause.Occur.MUST : BooleanClause.Occur.SHOULD));
            ++pos;
        }
        return this.getBooleanQuery(clauses);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        if (termStr.equals("*") && ("*".equals(field) || Objects.equals(field, this.field))) {
            String actualField = field;
            if (actualField == null) {
                actualField = this.field;
            }
            if (actualField == null) {
                return this.newMatchAllDocsQuery();
            }
            if ("*".equals(actualField) || "_all".equals(actualField)) {
                return this.newMatchAllDocsQuery();
            }
            return FIELD_QUERY_EXTENSIONS.get("_exists_").query(this.context, actualField);
        }
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getWildcardQuerySingle(fields.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getWildcardQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    queries.add(this.applyBoost(mField, q));
                }
                if (!added) {
                    return null;
                }
                return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getWildcardQuerySingle(mField, termStr);
                if (q == null) continue;
                clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
            }
            if (clauses.isEmpty()) {
                return null;
            }
            return this.getBooleanQueryCoordDisabled(clauses);
        }
        return this.getWildcardQuerySingle(field, termStr);
    }

    private Query getWildcardQuerySingle(String field, String termStr) throws ParseException {
        String indexedNameField = field;
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            this.currentFieldType = this.context.fieldMapper(field);
            if (this.currentFieldType != null) {
                if (!this.settings.forceAnalyzer()) {
                    this.setAnalyzer(this.context.getSearchAnalyzer(this.currentFieldType));
                }
                indexedNameField = this.currentFieldType.name();
            }
            Query query = super.getWildcardQuery(indexedNameField, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        Collection<String> fields = this.extractMultiFields(field);
        if (fields != null) {
            if (fields.size() == 1) {
                return this.getRegexpQuerySingle(fields.iterator().next(), termStr);
            }
            if (this.settings.useDisMax()) {
                ArrayList<Query> queries = new ArrayList<Query>();
                boolean added = false;
                for (String mField : fields) {
                    Query q = this.getRegexpQuerySingle(mField, termStr);
                    if (q == null) continue;
                    added = true;
                    queries.add(this.applyBoost(mField, q));
                }
                if (!added) {
                    return null;
                }
                return new DisjunctionMaxQuery(queries, this.settings.tieBreaker());
            }
            ArrayList<BooleanClause> clauses = new ArrayList<BooleanClause>();
            for (String mField : fields) {
                Query q = this.getRegexpQuerySingle(mField, termStr);
                if (q == null) continue;
                clauses.add(new BooleanClause(this.applyBoost(mField, q), BooleanClause.Occur.SHOULD));
            }
            if (clauses.isEmpty()) {
                return null;
            }
            return this.getBooleanQueryCoordDisabled(clauses);
        }
        return this.getRegexpQuerySingle(field, termStr);
    }

    private Query getRegexpQuerySingle(String field, String termStr) throws ParseException {
        this.currentFieldType = null;
        Analyzer oldAnalyzer = this.getAnalyzer();
        try {
            this.currentFieldType = this.context.fieldMapper(field);
            if (this.currentFieldType != null) {
                if (!this.settings.forceAnalyzer()) {
                    this.setAnalyzer(this.context.getSearchAnalyzer(this.currentFieldType));
                }
                Query query = null;
                if (!this.currentFieldType.tokenized()) {
                    query = this.currentFieldType.regexpQuery(termStr, 65535, this.getMaxDeterminizedStates(), this.getMultiTermRewriteMethod(), this.context);
                }
                if (query == null) {
                    query = super.getRegexpQuery(field, termStr);
                }
                Query query2 = query;
                return query2;
            }
            Query query = super.getRegexpQuery(field, termStr);
            return query;
        }
        catch (RuntimeException e) {
            if (this.settings.lenient()) {
                Query query = null;
                return query;
            }
            throw e;
        }
        finally {
            this.setAnalyzer(oldAnalyzer);
        }
    }

    @Deprecated
    protected Query getBooleanQueryCoordDisabled(List<BooleanClause> clauses) throws ParseException {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.setDisableCoord(true);
        for (BooleanClause clause : clauses) {
            builder.add(clause);
        }
        return Queries.fixNegativeQueryIfNeeded((Query)builder.build());
    }

    protected Query getBooleanQuery(List<BooleanClause> clauses) throws ParseException {
        Query q = super.getBooleanQuery(clauses);
        if (q == null) {
            return null;
        }
        return Queries.fixNegativeQueryIfNeeded(q);
    }

    private Query applyBoost(String field, Query q) {
        Float fieldBoost = this.settings.fieldsAndWeights().get(field);
        if (fieldBoost != null && fieldBoost.floatValue() != 1.0f) {
            return new BoostQuery(q, fieldBoost.floatValue());
        }
        return q;
    }

    private Query applySlop(Query q, int slop) {
        if (q instanceof PhraseQuery) {
            assert (!(q instanceof BoostQuery));
            return this.addSlopToPhrase((PhraseQuery)q, slop);
        }
        if (q instanceof MultiPhraseQuery) {
            MultiPhraseQuery.Builder builder = new MultiPhraseQuery.Builder((MultiPhraseQuery)q);
            builder.setSlop(slop);
            return builder.build();
        }
        if (q instanceof GraphQuery && ((GraphQuery)q).hasPhrase()) {
            List oldQueries = ((GraphQuery)q).getQueries();
            Query[] queries = new Query[oldQueries.size()];
            for (int i = 0; i < queries.length; ++i) {
                Query oldQuery = (Query)oldQueries.get(i);
                queries[i] = oldQuery instanceof PhraseQuery ? this.addSlopToPhrase((PhraseQuery)oldQuery, slop) : oldQuery;
            }
            return new GraphQuery(queries);
        }
        return q;
    }

    private PhraseQuery addSlopToPhrase(PhraseQuery query, int slop) {
        PhraseQuery.Builder builder = new PhraseQuery.Builder();
        builder.setSlop(slop);
        Term[] terms = query.getTerms();
        int[] positions = query.getPositions();
        for (int i = 0; i < terms.length; ++i) {
            builder.add(terms[i], positions[i]);
        }
        return builder.build();
    }

    private Collection<String> extractMultiFields(String field) {
        Collection<String> fields = field != null ? this.context.simpleMatchToIndexNames(field) : this.settings.fieldsAndWeights().keySet();
        return fields;
    }

    public Query parse(String query) throws ParseException {
        if (query.trim().isEmpty()) {
            return new MatchNoDocsQuery();
        }
        return super.parse(query);
    }

    static {
        HashMap<String, ExistsFieldQueryExtension> fieldQueryExtensions = new HashMap<String, ExistsFieldQueryExtension>();
        fieldQueryExtensions.put("_exists_", new ExistsFieldQueryExtension());
        FIELD_QUERY_EXTENSIONS = Collections.unmodifiableMap(fieldQueryExtensions);
    }
}

