/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.env.Environment;

public class InternalSettingsPreparer {
    private static final String[] ALLOWED_SUFFIXES = new String[]{".yml", ".yaml", ".json"};
    private static final String PROPERTY_DEFAULTS_PREFIX = "default.";
    private static final Predicate<String> PROPERTY_DEFAULTS_PREDICATE = key -> key.startsWith(PROPERTY_DEFAULTS_PREFIX);
    private static final UnaryOperator<String> STRIP_PROPERTY_DEFAULTS_PREFIX = key -> key.substring(PROPERTY_DEFAULTS_PREFIX.length());
    public static final String SECRET_PROMPT_VALUE = "${prompt.secret}";
    public static final String TEXT_PROMPT_VALUE = "${prompt.text}";

    public static Settings prepareSettings(Settings input) {
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.initializeSettings(output, input, Collections.emptyMap());
        InternalSettingsPreparer.finalizeSettings(output, null);
        return output.build();
    }

    public static Environment prepareEnvironment(Settings input, Terminal terminal) {
        return InternalSettingsPreparer.prepareEnvironment(input, terminal, Collections.emptyMap());
    }

    public static Environment prepareEnvironment(Settings input, Terminal terminal, Map<String, String> properties) {
        Settings.Builder output = Settings.builder();
        InternalSettingsPreparer.initializeSettings(output, input, properties);
        Environment environment = new Environment(output.build());
        output = Settings.builder();
        boolean settingsFileFound = false;
        HashSet<String> foundSuffixes = new HashSet<String>();
        for (String allowedSuffix : ALLOWED_SUFFIXES) {
            Path path = environment.configFile().resolve("elasticsearch" + allowedSuffix);
            if (!Files.exists(path, new LinkOption[0])) continue;
            if (!settingsFileFound) {
                try {
                    output.loadFromPath(path);
                }
                catch (IOException e) {
                    throw new SettingsException("Failed to load settings from " + path.toString(), e);
                }
            }
            settingsFileFound = true;
            foundSuffixes.add(allowedSuffix);
        }
        if (foundSuffixes.size() > 1) {
            throw new SettingsException("multiple settings files found with suffixes: " + Strings.collectionToDelimitedString(foundSuffixes, ","));
        }
        InternalSettingsPreparer.initializeSettings(output, input, properties);
        InternalSettingsPreparer.finalizeSettings(output, terminal);
        environment = new Environment(output.build());
        output.put(Environment.PATH_LOGS_SETTING.getKey(), Strings.cleanPath(environment.logsFile().toAbsolutePath().toString()));
        return new Environment(output.build());
    }

    private static void initializeSettings(Settings.Builder output, Settings input, Map<String, String> esSettings) {
        output.put(input);
        output.putProperties(esSettings, PROPERTY_DEFAULTS_PREDICATE.and(key -> output.get((String)STRIP_PROPERTY_DEFAULTS_PREFIX.apply((String)key)) == null), STRIP_PROPERTY_DEFAULTS_PREFIX);
        output.putProperties(esSettings, PROPERTY_DEFAULTS_PREDICATE.negate(), Function.identity());
        output.replacePropertyPlaceholders();
    }

    private static void finalizeSettings(Settings.Builder output, Terminal terminal) {
        ArrayList<String> forcedSettings = new ArrayList<String>();
        for (String setting : output.internalMap().keySet()) {
            if (!setting.startsWith("force.")) continue;
            forcedSettings.add(setting);
        }
        for (String forcedSetting : forcedSettings) {
            String value = output.remove(forcedSetting);
            output.put(forcedSetting.substring("force.".length()), value);
        }
        output.replacePropertyPlaceholders();
        if (output.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) == null) {
            output.put(ClusterName.CLUSTER_NAME_SETTING.getKey(), ClusterName.CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY).value());
        }
        InternalSettingsPreparer.replacePromptPlaceholders(output, terminal);
    }

    private static void replacePromptPlaceholders(Settings.Builder settings, Terminal terminal) {
        ArrayList<String> secretToPrompt = new ArrayList<String>();
        ArrayList<String> textToPrompt = new ArrayList<String>();
        for (Map.Entry<String, String> entry : settings.internalMap().entrySet()) {
            switch (entry.getValue()) {
                case "${prompt.secret}": {
                    secretToPrompt.add(entry.getKey());
                    break;
                }
                case "${prompt.text}": {
                    textToPrompt.add(entry.getKey());
                }
            }
        }
        for (String setting : secretToPrompt) {
            String secretValue = InternalSettingsPreparer.promptForValue(setting, terminal, true);
            if (Strings.hasLength(secretValue)) {
                settings.put(setting, secretValue);
                continue;
            }
            settings.remove(setting);
        }
        for (String setting : textToPrompt) {
            String textValue = InternalSettingsPreparer.promptForValue(setting, terminal, false);
            if (Strings.hasLength(textValue)) {
                settings.put(setting, textValue);
                continue;
            }
            settings.remove(setting);
        }
    }

    private static String promptForValue(String key, Terminal terminal, boolean secret) {
        if (terminal == null) {
            throw new UnsupportedOperationException("found property [" + key + "] with value [" + (secret ? SECRET_PROMPT_VALUE : TEXT_PROMPT_VALUE) + "]. prompting for property values is only supported when running elasticsearch in the foreground");
        }
        if (secret) {
            return new String(terminal.readSecret("Enter value for [" + key + "]: "));
        }
        return terminal.readText("Enter value for [" + key + "]: ");
    }
}

