define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(e,t,n){"use strict";var r=e("../lib/oop"),s=e("./text_highlight_rules").TextHighlightRules,o=t.constantOtherSymbol={token:"constant.other.symbol.ruby",regex:"[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"},a=(t.qString={token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},t.qqString={token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},t.tString={token:"string",regex:"[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"},t.constantNumericHex={token:"constant.numeric",regex:"0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"}),i=t.constantNumericFloat={token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?\\b"},c=function(){var e="abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|validates_inclusion_of|validates_numericality_of|validates_with|validates_each|authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|cache|expire_fragment|expire_cache_for|observe|cache_sweeper|has_many|has_one|belongs_to|has_and_belongs_to_many",t="alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield",n="true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING",r="$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|$!|root_url|flash|session|cookies|params|request|response|logger|self",s=this.$keywords=this.createKeywordMapper({keyword:t,"constant.language":n,"variable.language":r,"support.function":e,"invalid.deprecated":"debugger"},"identifier");this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"comment",regex:"^=begin(?:$|\\s.*$)",next:"comment"},{token:"string.regexp",regex:"[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"},[{regex:"[{}]",onMatch:function(e,t,n){return this.next="{"==e?this.nextState:"","{"==e&&n.length?(n.unshift("start",t),"paren.lparen"):"}"==e&&n.length&&(n.shift(),this.next=n.shift(),-1!=this.next.indexOf("string"))?"paren.end":"{"==e?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.start",regex:/"/,push:[{token:"constant.language.escape",regex:/\\(?:[nsrtvfbae'"\\]|c.|C-.|M-.(?:\\C-.)?|[0-7]{3}|x[\da-fA-F]{2}|u[\da-fA-F]{4})/},{token:"paren.start",regex:/\#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:/\\(?:[nsrtvfbae'"\\]|c.|C-.|M-.(?:\\C-.)?|[0-7]{3}|x[\da-fA-F]{2}|u[\da-fA-F]{4})/},{token:"paren.start",regex:/\#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/'/,push:[{token:"constant.language.escape",regex:/\\['\\]/},{token:"string.end",regex:/'/,next:"pop"},{defaultToken:"string"}]}],{token:"text",regex:"::"},{token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]+"},o,a,i,{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:s,regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(e,t,n){var r="-"==e[2]?"indentedHeredoc":"heredoc",s=e.split(this.splitRegex);return n.push(r,s[3]),[{type:"constant",value:s[1]},{type:"string",value:s[2]},{type:"support.class",value:s[3]},{type:"string",value:s[4]}]},regex:"(<<-?)(['\"`]?)([\\w]+)(['\"`]?)",rules:{heredoc:[{onMatch:function(e,t,n){return e===n[1]?(n.shift(),n.shift(),this.next=n[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}],indentedHeredoc:[{token:"string",regex:"^ +"},{onMatch:function(e,t,n){return e===n[1]?(n.shift(),n.shift(),this.next=n[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(e,t){return"heredoc"===t[0]||"indentedHeredoc"===t[0]?t[0]:e}},{token:"string.character",regex:"\\B\\?."},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}],comment:[{token:"comment",regex:"^=end(?:$|\\s.*$)",next:"start"},{token:"comment",regex:".+"}]},this.normalizeRules()};r.inherits(c,s),t.RubyHighlightRules=c}),define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(e,t,n){"use strict";var r=e("../range").Range,s=function(){};(function(){this.checkOutdent=function(e,t){return/^\s+$/.test(e)?/^\s*\}/.test(t):!1},this.autoOutdent=function(e,t){var n=e.getLine(t),s=n.match(/^(\s*\})/);if(!s)return 0;var o=s[1].length,a=e.findMatchingBracket({row:t,column:o});if(!a||a.row==t)return 0;var i=this.$getIndent(e.getLine(a.row));e.replace(new r(t,0,t,o-1),i)},this.$getIndent=function(e){return e.match(/^\s*/)[0]}}).call(s.prototype),t.MatchingBraceOutdent=s}),define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(e,t,n){"use strict";var r,s=e("../../lib/oop"),o=e("../behaviour").Behaviour,a=e("../../token_iterator").TokenIterator,i=e("../../lib/lang"),c=["text","paren.rparen","punctuation.operator"],l=["text","paren.rparen","punctuation.operator","comment"],u={},d=function(e){var t=-1;return e.multiSelect&&(t=e.selection.index,u.rangeCount!=e.multiSelect.rangeCount&&(u={rangeCount:e.multiSelect.rangeCount})),u[t]?r=u[t]:void(r=u[t]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""})},g=function(e,t,n,r){var s=e.end.row-e.start.row;return{text:n+t+r,selection:[0,e.start.column+1,s,e.end.column+(s?0:1)]}},_=function(){this.add("braces","insertion",function(e,t,n,s,o){var a=n.getCursorPosition(),c=s.doc.getLine(a.row);if("{"==o){d(n);var l=n.getSelectionRange(),u=s.doc.getTextRange(l);if(""!==u&&"{"!==u&&n.getWrapBehavioursEnabled())return g(l,u,"{","}");if(_.isSaneInsertion(n,s))return/[\]\}\)]/.test(c[a.column])||n.inMultiSelectMode?(_.recordAutoInsert(n,s,"}"),{text:"{}",selection:[1,1]}):(_.recordMaybeInsert(n,s,"{"),{text:"{",selection:[1,1]})}else if("}"==o){d(n);var f=c.substring(a.column,a.column+1);if("}"==f){var h=s.$findOpeningBracket("}",{column:a.column+1,row:a.row});if(null!==h&&_.isAutoInsertedClosing(a,c,o))return _.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}else{if("\n"==o||"\r\n"==o){d(n);var m="";_.isMaybeInsertedClosing(a,c)&&(m=i.stringRepeat("}",r.maybeInsertedBrackets),_.clearMaybeInsertedClosing());var f=c.substring(a.column,a.column+1);if("}"===f){var p=s.findMatchingBracket({row:a.row,column:a.column+1},"}");if(!p)return null;var b=this.$getIndent(s.getLine(p.row))}else{if(!m)return void _.clearMaybeInsertedClosing();var b=this.$getIndent(c)}var x=b+s.getTabString();return{text:"\n"+x+"\n"+b+m,selection:[1,x.length,1,x.length]}}_.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(e,t,n,s,o){var a=s.doc.getTextRange(o);if(!o.isMultiLine()&&"{"==a){d(n);var i=s.doc.getLine(o.start.row),c=i.substring(o.end.column,o.end.column+1);if("}"==c)return o.end.column++,o;r.maybeInsertedBrackets--}}),this.add("parens","insertion",function(e,t,n,r,s){if("("==s){d(n);var o=n.getSelectionRange(),a=r.doc.getTextRange(o);if(""!==a&&n.getWrapBehavioursEnabled())return g(o,a,"(",")");if(_.isSaneInsertion(n,r))return _.recordAutoInsert(n,r,")"),{text:"()",selection:[1,1]}}else if(")"==s){d(n);var i=n.getCursorPosition(),c=r.doc.getLine(i.row),l=c.substring(i.column,i.column+1);if(")"==l){var u=r.$findOpeningBracket(")",{column:i.column+1,row:i.row});if(null!==u&&_.isAutoInsertedClosing(i,c,s))return _.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}}),this.add("parens","deletion",function(e,t,n,r,s){var o=r.doc.getTextRange(s);if(!s.isMultiLine()&&"("==o){d(n);var a=r.doc.getLine(s.start.row),i=a.substring(s.start.column+1,s.start.column+2);if(")"==i)return s.end.column++,s}}),this.add("brackets","insertion",function(e,t,n,r,s){if("["==s){d(n);var o=n.getSelectionRange(),a=r.doc.getTextRange(o);if(""!==a&&n.getWrapBehavioursEnabled())return g(o,a,"[","]");if(_.isSaneInsertion(n,r))return _.recordAutoInsert(n,r,"]"),{text:"[]",selection:[1,1]}}else if("]"==s){d(n);var i=n.getCursorPosition(),c=r.doc.getLine(i.row),l=c.substring(i.column,i.column+1);if("]"==l){var u=r.$findOpeningBracket("]",{column:i.column+1,row:i.row});if(null!==u&&_.isAutoInsertedClosing(i,c,s))return _.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}}),this.add("brackets","deletion",function(e,t,n,r,s){var o=r.doc.getTextRange(s);if(!s.isMultiLine()&&"["==o){d(n);var a=r.doc.getLine(s.start.row),i=a.substring(s.start.column+1,s.start.column+2);if("]"==i)return s.end.column++,s}}),this.add("string_dquotes","insertion",function(e,t,n,r,s){if('"'==s||"'"==s){d(n);var o=s,a=n.getSelectionRange(),i=r.doc.getTextRange(a);if(""!==i&&"'"!==i&&'"'!=i&&n.getWrapBehavioursEnabled())return g(a,i,o,o);if(!i){var c=n.getCursorPosition(),l=r.doc.getLine(c.row),u=l.substring(c.column-1,c.column),_=l.substring(c.column,c.column+1),f=r.getTokenAt(c.row,c.column),h=r.getTokenAt(c.row,c.column+1);if("\\"==u&&f&&/escape/.test(f.type))return null;var m,p=f&&/string|escape/.test(f.type),b=!h||/string|escape/.test(h.type);if(_==o)m=p!==b;else{if(p&&!b)return null;if(p&&b)return null;var x=r.$mode.tokenRe;x.lastIndex=0;var v=x.test(u);x.lastIndex=0;var k=x.test(u);if(v||k)return null;if(_&&!/[\s;,.})\]\\]/.test(_))return null;m=!0}return{text:m?o+o:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(e,t,n,r,s){var o=r.doc.getTextRange(s);if(!s.isMultiLine()&&('"'==o||"'"==o)){d(n);var a=r.doc.getLine(s.start.row),i=a.substring(s.start.column+1,s.start.column+2);if(i==o)return s.end.column++,s}})};_.isSaneInsertion=function(e,t){var n=e.getCursorPosition(),r=new a(t,n.row,n.column);if(!this.$matchTokenType(r.getCurrentToken()||"text",c)){var s=new a(t,n.row,n.column+1);if(!this.$matchTokenType(s.getCurrentToken()||"text",c))return!1}return r.stepForward(),r.getCurrentTokenRow()!==n.row||this.$matchTokenType(r.getCurrentToken()||"text",l)},_.$matchTokenType=function(e,t){return t.indexOf(e.type||e)>-1},_.recordAutoInsert=function(e,t,n){var s=e.getCursorPosition(),o=t.doc.getLine(s.row);this.isAutoInsertedClosing(s,o,r.autoInsertedLineEnd[0])||(r.autoInsertedBrackets=0),r.autoInsertedRow=s.row,r.autoInsertedLineEnd=n+o.substr(s.column),r.autoInsertedBrackets++},_.recordMaybeInsert=function(e,t,n){var s=e.getCursorPosition(),o=t.doc.getLine(s.row);this.isMaybeInsertedClosing(s,o)||(r.maybeInsertedBrackets=0),r.maybeInsertedRow=s.row,r.maybeInsertedLineStart=o.substr(0,s.column)+n,r.maybeInsertedLineEnd=o.substr(s.column),r.maybeInsertedBrackets++},_.isAutoInsertedClosing=function(e,t,n){return r.autoInsertedBrackets>0&&e.row===r.autoInsertedRow&&n===r.autoInsertedLineEnd[0]&&t.substr(e.column)===r.autoInsertedLineEnd},_.isMaybeInsertedClosing=function(e,t){return r.maybeInsertedBrackets>0&&e.row===r.maybeInsertedRow&&t.substr(e.column)===r.maybeInsertedLineEnd&&t.substr(0,e.column)==r.maybeInsertedLineStart},_.popAutoInsertedClosing=function(){r.autoInsertedLineEnd=r.autoInsertedLineEnd.substr(1),r.autoInsertedBrackets--},_.clearMaybeInsertedClosing=function(){r&&(r.maybeInsertedBrackets=0,r.maybeInsertedRow=-1)},s.inherits(_,o),t.CstyleBehaviour=_}),define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(e,t,n){"use strict";var r=e("../../lib/oop"),s=e("./fold_mode").FoldMode,o=e("../../range").Range,a=t.FoldMode=function(){};r.inherits(a,s),function(){this.getFoldWidgetRange=function(e,t,n){var r=this.indentationBlock(e,n);if(r)return r;var s=/\S/,a=e.getLine(n),i=a.search(s);if(-1!=i&&"#"==a[i]){for(var c=a.length,l=e.getLength(),u=n,d=n;++n<l;){a=e.getLine(n);var g=a.search(s);if(-1!=g){if("#"!=a[g])break;d=n}}if(d>u){var _=e.getLine(d).length;return new o(u,c,d,_)}}},this.getFoldWidget=function(e,t,n){var r=e.getLine(n),s=r.search(/\S/),o=e.getLine(n+1),a=e.getLine(n-1),i=a.search(/\S/),c=o.search(/\S/);if(-1==s)return e.foldWidgets[n-1]=-1!=i&&c>i?"start":"","";if(-1==i){if(s==c&&"#"==r[s]&&"#"==o[s])return e.foldWidgets[n-1]="",e.foldWidgets[n+1]="","start"}else if(i==s&&"#"==r[s]&&"#"==a[s]&&-1==e.getLine(n-2).search(/\S/))return e.foldWidgets[n-1]="start",e.foldWidgets[n+1]="","";return-1!=i&&s>i?e.foldWidgets[n-1]="start":e.foldWidgets[n-1]="",c>s?"start":""}}.call(a.prototype)}),define("ace/mode/ruby",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ruby_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/behaviour/cstyle","ace/mode/folding/coffee"],function(e,t,n){"use strict";var r=e("../lib/oop"),s=e("./text").Mode,o=e("./ruby_highlight_rules").RubyHighlightRules,a=e("./matching_brace_outdent").MatchingBraceOutdent,i=e("../range").Range,c=e("./behaviour/cstyle").CstyleBehaviour,l=e("./folding/coffee").FoldMode,u=function(){this.HighlightRules=o,this.$outdent=new a,this.$behaviour=new c,this.foldingRules=new l};r.inherits(u,s),function(){this.lineCommentStart="#",this.getNextLineIndent=function(e,t,n){var r=this.$getIndent(t),s=this.getTokenizer().getLineTokens(t,e),o=s.tokens;if(o.length&&"comment"==o[o.length-1].type)return r;if("start"==e){var a=t.match(/^.*[\{\(\[]\s*$/),i=t.match(/^\s*(class|def|module)\s.*$/),c=t.match(/.*do(\s*|\s+\|.*\|\s*)$/),l=t.match(/^\s*(if|else|when)\s*/);(a||i||c||l)&&(r+=n)}return r},this.checkOutdent=function(e,t,n){return/^\s+(end|else)$/.test(t+n)||this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(e,t,n){var r=t.getLine(n);if(/}/.test(r))return this.$outdent.autoOutdent(t,n);var s=this.$getIndent(r),o=t.getLine(n-1),a=this.$getIndent(o),c=t.getTabString();a.length<=s.length&&s.slice(-c.length)==c&&t.remove(new i(n,s.length-c.length,n,s.length))},this.$id="ace/mode/ruby"}.call(u.prototype),t.Mode=u});