/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements ModifierListener {
    private MouseEvent oldEvent;
    private transient WaySegment oldHighlightedWaySegment;
    private static final HighlightHelper highlightHelper = new HighlightHelper();
    private boolean drawTargetHighlight;

    public DeleteAction() {
        super(I18n.tr("Delete Mode", new Object[0]), "delete", I18n.tr("Delete nodes or ways.", new Object[0]), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete", new Object[0])), 127, 5006), ImageProvider.getCursor("normal", "delete"));
    }

    @Override
    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.keyDetector.addModifierListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.keyDetector.removeModifierListener(this);
        this.removeHighlighting();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        DeleteAction.doActionPerformed(actionEvent);
    }

    public static void doActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        MainLayerManager mainLayerManager = Main.getLayerManager();
        OsmDataLayer osmDataLayer = mainLayerManager.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        boolean bl2 = (actionEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (actionEvent.getModifiers() & 0x28) != 0;
        Command command = bl2 ? DeleteCommand.deleteWithReferences(osmDataLayer, mainLayerManager.getEditDataSet().getSelected()) : DeleteCommand.delete(osmDataLayer, mainLayerManager.getEditDataSet().getSelected(), !bl);
        if (command != null) {
            Main.main.undoRedo.add(command);
            mainLayerManager.getEditDataSet().setSelected(new PrimitiveId[0]);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.oldEvent = mouseEvent;
        this.giveUserFeedback(mouseEvent);
    }

    private void removeHighlighting() {
        highlightHelper.clear();
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet != null) {
            dataSet.clearHighlightedWaySegments();
        }
    }

    private void addHighlighting(MouseEvent mouseEvent, int n) {
        if (!this.drawTargetHighlight) {
            return;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        DeleteParameters deleteParameters = this.getDeleteParameters(mouseEvent, n);
        if (deleteParameters.mode == DeleteMode.segment) {
            this.repaintIfRequired(hashSet, deleteParameters.nearestSegment);
        } else {
            Command command = this.buildDeleteCommands(mouseEvent, n, true);
            if (command != null) {
                for (OsmPrimitive osmPrimitive : command.getParticipatingPrimitives()) {
                    hashSet.add(osmPrimitive);
                }
            }
            this.repaintIfRequired(hashSet, null);
        }
    }

    private void repaintIfRequired(Set<OsmPrimitive> set, WaySegment waySegment) {
        boolean bl = false;
        OsmDataLayer osmDataLayer = this.getLayerManager().getEditLayer();
        if (waySegment == null && this.oldHighlightedWaySegment != null) {
            if (osmDataLayer != null) {
                osmDataLayer.data.clearHighlightedWaySegments();
                bl = true;
            }
            this.oldHighlightedWaySegment = null;
        } else if (waySegment != null && !waySegment.equals(this.oldHighlightedWaySegment)) {
            if (osmDataLayer != null) {
                osmDataLayer.data.setHighlightedWaySegments(Collections.singleton(waySegment));
                bl = true;
            }
            this.oldHighlightedWaySegment = waySegment;
        }
        if ((bl |= highlightHelper.highlightOnly(set)) && osmDataLayer != null) {
            osmDataLayer.invalidate();
        }
    }

    private void updateCursor(MouseEvent mouseEvent, int n) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible() || mouseEvent == null) {
            return;
        }
        DeleteParameters deleteParameters = this.getDeleteParameters(mouseEvent, n);
        Main.map.mapView.setNewCursor(deleteParameters.mode.cursor(), (Object)this);
    }

    private void giveUserFeedback(MouseEvent mouseEvent, int n) {
        this.updateCursor(mouseEvent, n);
        this.addHighlighting(mouseEvent, n);
    }

    private void giveUserFeedback(MouseEvent mouseEvent) {
        this.giveUserFeedback(mouseEvent, mouseEvent.getModifiers());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Command command = this.buildDeleteCommands(mouseEvent, mouseEvent.getModifiers(), false);
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        this.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[0]);
        this.giveUserFeedback(mouseEvent);
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: do not delete unused nodes when deleting a way. Ctrl: delete referring objects.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer osmDataLayer, Relation relation) {
        DeleteAction.deleteRelations(osmDataLayer, Collections.singleton(relation));
    }

    public static void deleteRelations(OsmDataLayer osmDataLayer, Collection<Relation> collection) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        CheckParameterUtil.ensureParameterNotNull(collection, "toDelete");
        Command command = DeleteCommand.delete(osmDataLayer, collection);
        if (command != null) {
            Main.main.undoRedo.add(command);
            for (Relation relation : collection) {
                if (osmDataLayer.data.getSelectedRelations().contains(relation)) {
                    osmDataLayer.data.toggleSelected(relation);
                }
                RelationDialogManager.getRelationDialogManager().close(osmDataLayer, relation);
            }
        }
    }

    private DeleteParameters getDeleteParameters(MouseEvent mouseEvent, int n) {
        this.updateKeyModifiers(n);
        DeleteParameters deleteParameters = new DeleteParameters();
        deleteParameters.nearestNode = Main.map.mapView.getNearestNode(mouseEvent.getPoint(), OsmPrimitive::isSelectable);
        if (deleteParameters.nearestNode == null) {
            deleteParameters.nearestSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive::isSelectable);
            if (deleteParameters.nearestSegment != null) {
                if (this.shift) {
                    deleteParameters.mode = DeleteMode.segment;
                } else if (this.ctrl) {
                    deleteParameters.mode = DeleteMode.way_with_references;
                } else {
                    deleteParameters.mode = this.alt ? DeleteMode.way : DeleteMode.way_with_nodes;
                }
            } else {
                deleteParameters.mode = DeleteMode.none;
            }
        } else if (this.ctrl) {
            deleteParameters.mode = DeleteMode.node_with_references;
        } else {
            deleteParameters.mode = DeleteMode.node;
        }
        return deleteParameters;
    }

    private Command buildDeleteCommands(MouseEvent mouseEvent, int n, boolean bl) {
        DeleteParameters deleteParameters = this.getDeleteParameters(mouseEvent, n);
        OsmDataLayer osmDataLayer = this.getLayerManager().getEditLayer();
        switch (deleteParameters.mode) {
            case node: {
                return DeleteCommand.delete(osmDataLayer, Collections.singleton(deleteParameters.nearestNode), false, bl);
            }
            case node_with_references: {
                return DeleteCommand.deleteWithReferences(osmDataLayer, Collections.singleton(deleteParameters.nearestNode), bl);
            }
            case segment: {
                return DeleteCommand.deleteWaySegment(osmDataLayer, deleteParameters.nearestSegment);
            }
            case way: {
                return DeleteCommand.delete(osmDataLayer, Collections.singleton(((DeleteParameters)deleteParameters).nearestSegment.way), false, bl);
            }
            case way_with_nodes: {
                return DeleteCommand.delete(osmDataLayer, Collections.singleton(((DeleteParameters)deleteParameters).nearestSegment.way), true, bl);
            }
            case way_with_references: {
                return DeleteCommand.deleteWithReferences(osmDataLayer, Collections.singleton(((DeleteParameters)deleteParameters).nearestSegment.way), true);
            }
        }
        return null;
    }

    @Override
    public void modifiersChanged(int n) {
        if (this.oldEvent == null) {
            return;
        }
        this.giveUserFeedback(this.oldEvent, n);
    }

    private static class DeleteParameters {
        private DeleteMode mode;
        private Node nearestNode;
        private WaySegment nearestSegment;

        private DeleteParameters() {
        }
    }

    private static enum DeleteMode {
        none("delete"),
        segment("delete_segment"),
        node("delete_node"),
        node_with_references("delete_node"),
        way("delete_way_only"),
        way_with_references("delete_way_normal"),
        way_with_nodes("delete_way_node_only");

        private final Cursor c;

        private DeleteMode(String string2) {
            this.c = ImageProvider.getCursor("normal", string2);
        }

        public Cursor cursor() {
            return this.c;
        }
    }
}

