/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.lang.reflect.Member;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.backtrace.TraceType;
import org.jruby.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;
    private String providedMessage;
    private boolean nativeException;

    public RaiseException(RubyException actException) {
        this(actException, false);
    }

    public RaiseException(RubyException exception2, IRubyObject backtrace2) {
        super(exception2.getMessageAsJavaString());
        this.setException(exception2, false);
        this.preRaise(exception2.getRuntime().getCurrentContext(), backtrace2);
    }

    public RaiseException(Ruby runtime, RubyClass excptnClass, String msg, boolean nativeException) {
        super(msg);
        if (msg == null) {
            msg = "No message available";
        }
        this.providedMessage = '(' + excptnClass.getName() + ") " + msg;
        this.nativeException = nativeException;
        ThreadContext context = runtime.getCurrentContext();
        this.setException((RubyException)Helpers.invoke(context, (IRubyObject)excptnClass, "new", (IRubyObject)RubyString.newUnicodeString(runtime, msg)), nativeException);
        this.preRaise(context);
    }

    public RaiseException(Ruby runtime, RubyClass excptnClass, String msg, IRubyObject backtrace2, boolean nativeException) {
        super(msg);
        if (msg == null) {
            msg = "No message available";
        }
        this.providedMessage = '(' + excptnClass.getName() + ") " + msg;
        this.nativeException = nativeException;
        ThreadContext context = runtime.getCurrentContext();
        this.setException((RubyException)Helpers.invoke(context, (IRubyObject)excptnClass, "new", (IRubyObject)RubyString.newUnicodeString(runtime, msg)), nativeException);
        this.preRaise(context, backtrace2);
    }

    public RaiseException(RubyException exception2, boolean nativeException) {
        super(exception2.getMessageAsJavaString());
        this.nativeException = nativeException;
        this.setException(exception2, nativeException);
        this.preRaise(exception2.getRuntime().getCurrentContext());
    }

    public RaiseException(Throwable cause2, NativeException nativeException) {
        super(nativeException.getMessageAsJavaString(), cause2);
        this.providedMessage = super.getMessage();
        this.setException(nativeException, true);
        this.preRaise(nativeException.getRuntime().getCurrentContext(), nativeException.getCause().getStackTrace());
        this.setStackTrace(RaiseException.javaTraceFromRubyTrace(this.exception.getBacktraceElements()));
    }

    @Deprecated
    public static RaiseException createNativeRaiseException(Ruby runtime, Throwable cause2) {
        return RaiseException.createNativeRaiseException(runtime, cause2, null);
    }

    @Deprecated
    public static RaiseException createNativeRaiseException(Ruby runtime, Throwable cause2, Member target) {
        NativeException nativeException = new NativeException(runtime, runtime.getNativeException(), cause2);
        return new RaiseException(cause2, nativeException);
    }

    @Override
    public String getMessage() {
        if (this.providedMessage == null) {
            this.providedMessage = '(' + this.exception.getMetaClass().getBaseName() + ") " + this.exception.message(this.exception.getRuntime().getCurrentContext()).asJavaString();
        }
        return this.providedMessage;
    }

    public final RubyException getException() {
        return this.exception;
    }

    private void preRaise(ThreadContext context) {
        this.preRaise(context, (IRubyObject)null);
    }

    private void preRaise(ThreadContext context, StackTraceElement[] javaTrace) {
        context.runtime.incrementExceptionCount();
        this.doSetLastError(context);
        RaiseException.doCallEventHook(context);
        if (RubyInstanceConfig.LOG_EXCEPTIONS) {
            TraceType.logException(this.exception);
        }
        if (this.requiresBacktrace(context)) {
            this.exception.prepareIntegratedBacktrace(context, javaTrace);
        }
    }

    private boolean requiresBacktrace(ThreadContext context) {
        IRubyObject debugMode;
        return context.exceptionRequiresBacktrace || (debugMode = context.runtime.getGlobalVariables().get("$DEBUG")) != null && debugMode.isTrue() || !context.runtime.getStandardError().isInstance(this.exception);
    }

    private void preRaise(ThreadContext context, IRubyObject backtrace2) {
        context.runtime.incrementExceptionCount();
        this.doSetLastError(context);
        RaiseException.doCallEventHook(context);
        if (RubyInstanceConfig.LOG_EXCEPTIONS) {
            TraceType.logException(this.exception);
        }
        if (this.requiresBacktrace(context)) {
            if (backtrace2 == null) {
                this.exception.prepareBacktrace(context, this.nativeException);
            } else {
                this.exception.forceBacktrace(backtrace2);
                if (backtrace2.isNil()) {
                    return;
                }
            }
            if (this.exception instanceof NativeException) {
                this.setStackTrace(((NativeException)this.exception).getCause().getStackTrace());
            } else {
                this.setStackTrace(RaiseException.javaTraceFromRubyTrace(this.exception.getBacktraceElements()));
            }
        }
    }

    private static void doCallEventHook(ThreadContext context) {
        if (context.runtime.hasEventHooks()) {
            context.runtime.callEventHooks(context, RubyEvent.RAISE, context.getFile(), context.getLine(), context.getFrameName(), context.getFrameKlazz());
        }
    }

    private void doSetLastError(ThreadContext context) {
        context.runtime.getGlobalVariables().set("$!", this.exception);
    }

    protected final void setException(RubyException newException, boolean nativeException) {
        this.exception = newException;
        this.nativeException = nativeException;
    }

    public static StackTraceElement[] javaTraceFromRubyTrace(RubyStackTraceElement[] trace) {
        StackTraceElement[] newTrace = new StackTraceElement[trace.length];
        for (int i2 = 0; i2 < newTrace.length; ++i2) {
            newTrace[i2] = trace[i2].asStackTraceElement();
        }
        return newTrace;
    }
}

