/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.executable.ScriptAndCode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRTranslator;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningClassLoader;

public class Compiler
extends IRTranslator<ScriptAndCode, ClassDefiningClassLoader> {
    private Compiler() {
    }

    public static Compiler getInstance() {
        return CompilerHolder.instance;
    }

    @Override
    protected ScriptAndCode execute(Ruby runtime, IRScriptBody scope, ClassDefiningClassLoader classLoader) {
        MethodHandle _compiledHandle;
        byte[] bytecode;
        try {
            JVMVisitor visitor = new JVMVisitor();
            JVMVisitorMethodContext context = new JVMVisitorMethodContext();
            bytecode = visitor.compileToBytecode(scope, context);
            Class compiled = visitor.defineFromBytecode(scope, bytecode, classLoader);
            Method compiledMethod = compiled.getMethod("RUBY$script", ThreadContext.class, StaticScope.class, IRubyObject.class, IRubyObject[].class, Block.class, RubyModule.class, String.class);
            _compiledHandle = MethodHandles.publicLookup().unreflect(compiledMethod);
        }
        catch (NotCompilableException nce) {
            throw nce;
        }
        catch (Throwable t) {
            throw new NotCompilableException("failed to compile script " + scope.getName(), t);
        }
        final MethodHandle compiledHandle = _compiledHandle;
        final StaticScope staticScope = scope.getStaticScope();
        AbstractScript script = new AbstractScript(){

            @Override
            public IRubyObject __file__(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
                try {
                    return (IRubyObject)compiledHandle.invokeWithArguments(context, staticScope, self2, IRubyObject.NULL_ARRAY, block, self2.getMetaClass(), "(root)");
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IRubyObject load(ThreadContext context, IRubyObject self2, boolean wrap2) {
                RubyModule currModule = staticScope.getModule();
                staticScope.setModule(currModule);
                context.setCurrentVisibility(Visibility.PRIVATE);
                try {
                    return (IRubyObject)compiledHandle.invokeWithArguments(context, staticScope, self2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK, currModule, "(root)");
                }
                catch (IRBreakJump bj) {
                    throw IRException.BREAK_LocalJumpError.getException(context.runtime);
                }
                catch (Throwable t) {
                    Helpers.throwException(t);
                    return null;
                }
            }
        };
        return new ScriptAndCode(bytecode, script);
    }

    private static class CompilerHolder {
        public static final Compiler instance = new Compiler();

        private CompilerHolder() {
        }
    }
}

