/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;

public class WriteClassVariableNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;
    @Node.Child
    private RubyNode rhs;

    public WriteClassVariableNode(LexicalScope lexicalScope, String name, RubyNode rhs) {
        this.lexicalScope = lexicalScope;
        this.name = name;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object rhsValue = this.rhs.execute(frame);
        DynamicObject module = this.lexicalScope.resolveTargetModuleForClassVariables();
        ModuleOperations.setClassVariable(this.getContext(), module, this.name, rhsValue, this);
        return rhsValue;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().ASSIGNMENT.createInstance();
    }
}

