/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.tools.callgraph;

import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.tools.callgraph.CallGraph;
import org.jruby.truffle.tools.callgraph.CallSite;
import org.jruby.truffle.tools.callgraph.CallSiteVersion;
import org.jruby.truffle.tools.callgraph.Calls;
import org.jruby.truffle.tools.callgraph.CallsForeign;
import org.jruby.truffle.tools.callgraph.CallsMegamorphic;
import org.jruby.truffle.tools.callgraph.CallsMethod;
import org.jruby.truffle.tools.callgraph.IdProvider;
import org.jruby.truffle.tools.callgraph.Method;
import org.jruby.truffle.tools.callgraph.MethodVersion;

public class SimpleWriter {
    private final CallGraph callGraph;
    private final PrintStream stream;
    private final IdProvider ids = new IdProvider();

    public SimpleWriter(CallGraph callGraph, PrintStream stream) {
        this.callGraph = callGraph;
        this.stream = stream;
    }

    public void write() {
        for (Method method : this.callGraph.getMethods()) {
            this.write(method);
        }
    }

    private void write(Method method) {
        SharedMethodInfo sharedInfo = method.getSharedInfo();
        SourceSection sourceSection = method.getVersions().get(0).getRootNode().getSourceSection();
        String sourceName = sourceSection == null || sourceSection.getSource() == null ? "(unknown)" : sourceSection.getSource().getPath();
        int startLine = sourceSection == null ? -1 : sourceSection.getStartLine();
        int endLine = sourceSection == null ? -1 : (sourceSection.getSource() == null ? sourceSection.getStartLine() : sourceSection.getEndLine());
        this.stream.printf("method %d %s %s %d %d%n", this.ids.getId(method), sharedInfo.getName(), sourceName, startLine, endLine);
        for (CallSite callSite : method.getCallSites().values()) {
            this.write(callSite);
        }
        for (MethodVersion version : method.getVersions()) {
            this.write(version);
        }
    }

    private void write(MethodVersion version) {
        this.stream.printf("method-version %d %d%n", this.ids.getId(version.getMethod()), this.ids.getId(version));
        for (String string : version.getEvalCode()) {
            this.stream.printf("eval %d %s%n", this.ids.getId(version), string);
        }
        for (CallSiteVersion callSiteVersion : version.getCallSiteVersions().values()) {
            this.write(callSiteVersion);
        }
        for (Map.Entry entry : this.callGraph.getLocalTypes(version.getRootNode()).entrySet()) {
            String name = (String)entry.getKey();
            for (String type : (Set)entry.getValue()) {
                this.stream.printf("local %d %s %s%n", this.ids.getId(version), name, type);
            }
        }
    }

    private void write(CallSite callSite) {
        this.stream.printf("callsite %d %d %d%n", this.ids.getId(callSite.getMethod()), this.ids.getId(callSite), callSite.getSourceSection().getStartLine());
    }

    private void write(CallSiteVersion version) {
        this.stream.printf("callsite-version %d %d %d%n", this.ids.getId(version.getCallSite()), this.ids.getId(version.getMethodVersion()), this.ids.getId(version));
        for (Calls calls : version.getCalls()) {
            this.write(version, calls);
        }
    }

    private void write(CallSiteVersion callSiteVersion, Calls calls) {
        if (calls instanceof CallsMegamorphic) {
            this.stream.printf("calls %d mega%n", this.ids.getId(callSiteVersion));
        } else if (calls instanceof CallsForeign) {
            this.stream.printf("calls %d foreign%n", this.ids.getId(callSiteVersion));
        } else {
            CallsMethod callsMethod = (CallsMethod)calls;
            this.stream.printf("calls %d %d%n", this.ids.getId(callSiteVersion), this.ids.getId(callsMethod.getMethodVersion()));
        }
    }
}

