/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class LocalVarRemapper {
    private final Parameters params;
    private final int actualParamsSize;
    private final StackValue[] remapValues;
    private final int additionalShift;

    public LocalVarRemapper(@NotNull Parameters params, int additionalShift) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "<init>"));
        }
        this.additionalShift = additionalShift;
        this.params = params;
        this.remapValues = new StackValue[params.getArgsSizeOnStack()];
        int realSize = 0;
        for (ParameterInfo info : params) {
            Integer shift = params.getDeclarationSlot(info);
            if (!info.isSkippedOrRemapped()) {
                this.remapValues[shift.intValue()] = StackValue.local(realSize, AsmTypes.OBJECT_TYPE);
                realSize += info.getType().getSize();
                continue;
            }
            StackValue stackValue = this.remapValues[shift.intValue()] = info.isRemapped() ? info.getRemapValue() : null;
            if (!CapturedParamInfo.isSynthetic(info)) continue;
            realSize += info.getType().getSize();
        }
        this.actualParamsSize = realSize;
    }

    @NotNull
    private RemapInfo doRemap(int index2) {
        int remappedIndex;
        if (index2 < this.params.getArgsSizeOnStack()) {
            ParameterInfo info = this.params.getParameterByDeclarationSlot(index2);
            StackValue remapped = this.remapValues[index2];
            if (info.isSkipped || remapped == null) {
                RemapInfo remapInfo = new RemapInfo(info);
                if (remapInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "doRemap"));
                }
                return remapInfo;
            }
            if (info.isRemapped()) {
                RemapInfo remapInfo = new RemapInfo(remapped, info, RemapStatus.REMAPPED);
                if (remapInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "doRemap"));
                }
                return remapInfo;
            }
            remappedIndex = ((StackValue.Local)remapped).index;
        } else {
            remappedIndex = this.actualParamsSize - this.params.getArgsSizeOnStack() + index2;
        }
        RemapInfo remapInfo = new RemapInfo(StackValue.local(remappedIndex + this.additionalShift, AsmTypes.OBJECT_TYPE), null, RemapStatus.SHIFT);
        if (remapInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "doRemap"));
        }
        return remapInfo;
    }

    @NotNull
    public RemapInfo remap(int index2) {
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.FAIL == info.status) {
            assert (info.parameterInfo != null) : "Parameter info should be not null";
            throw new RuntimeException("Trying to access skipped parameter: " + info.parameterInfo.type + " at " + index2);
        }
        RemapInfo remapInfo = info;
        if (remapInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "remap"));
        }
        return remapInfo;
    }

    public void visitIincInsn(int var, int increment, @NotNull MethodVisitor mv) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "visitIincInsn"));
        }
        RemapInfo remap = this.remap(var);
        assert (remap.value instanceof StackValue.Local) : "Remapped value should be a local: " + remap.value;
        mv.visitIincInsn(((StackValue.Local)remap.value).index, increment);
    }

    public void visitLocalVariable(@NotNull String name2, @NotNull String desc, @Nullable String signature, @NotNull Label start, @NotNull Label end, int index2, MethodVisitor mv) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "visitLocalVariable"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "visitLocalVariable"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "visitLocalVariable"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "visitLocalVariable"));
        }
        RemapInfo info = this.doRemap(index2);
        if (RemapStatus.SHIFT == info.status) {
            mv.visitLocalVariable(name2, desc, signature, start, end, ((StackValue.Local)info.value).index);
        }
    }

    public void visitVarInsn(int opcode, int var, @NotNull InstructionAdapter mv) {
        if (mv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mv", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper", "visitVarInsn"));
        }
        RemapInfo remapInfo = this.remap(var);
        StackValue value = remapInfo.value;
        if (value instanceof StackValue.Local) {
            boolean isStore = InlineCodegenUtil.isStoreInstruction(opcode);
            if (remapInfo.parameterInfo != null) {
                opcode = value.type.getOpcode(isStore ? 54 : 21);
            }
            mv.visitVarInsn(opcode, ((StackValue.Local)value).index);
            if (remapInfo.parameterInfo != null && !isStore) {
                StackValue.coerce(value.type, remapInfo.parameterInfo.type, mv);
            }
        } else {
            assert (remapInfo.parameterInfo != null) : "Non local value should have parameter info";
            value.put(remapInfo.parameterInfo.type, mv);
        }
    }

    public static class RemapInfo {
        public final StackValue value;
        public final ParameterInfo parameterInfo;
        public final RemapStatus status;

        public RemapInfo(@NotNull StackValue value, @Nullable ParameterInfo parameterInfo, @NotNull RemapStatus remapStatus) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            if (remapStatus == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remapStatus", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            this.value = value;
            this.parameterInfo = parameterInfo;
            this.status = remapStatus;
        }

        public RemapInfo(@NotNull ParameterInfo parameterInfo) {
            if (parameterInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterInfo", "org/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo", "<init>"));
            }
            this.value = null;
            this.parameterInfo = parameterInfo;
            this.status = RemapStatus.FAIL;
        }
    }

    public static enum RemapStatus {
        SHIFT,
        REMAPPED,
        FAIL;

    }
}

