/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class OsmLinkPaster
extends AbstractOsmDataPaster {
    private static final String OSM_SERVER = "^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/";

    public OsmLinkPaster() {
        super(DataFlavor.stringFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport, OsmDataLayer osmDataLayer, EastNorth eastNorth) throws UnsupportedFlavorException, IOException {
        Component component;
        if (!this.supports(transferSupport)) {
            throw new UnsupportedFlavorException(this.df);
        }
        String string = (String)transferSupport.getTransferable().getTransferData(this.df);
        if (new NoWarnOpenLocationAction().openUrl(string)) {
            return true;
        }
        LatLon latLon = OsmLinkPaster.parseLatLon(string);
        if (latLon != null && (component = transferSupport.getComponent()) instanceof MapView) {
            ((MapView)component).zoomTo(latLon);
        }
        return false;
    }

    static LatLon parseLatLon(String string) {
        Matcher matcher = Pattern.compile("^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/#map=(?<zoom>\\d+)/(?<lat>-?\\d+\\.\\d+)/(?<lon>-?\\d+\\.\\d+)$").matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return new LatLon(Double.parseDouble(matcher.group("lat")), Double.parseDouble(matcher.group("lon")));
    }

    static final class NoWarnOpenLocationAction
    extends OpenLocationAction {
        NoWarnOpenLocationAction() {
        }

        @Override
        protected void warnNoSuitableTasks(String string) {
        }
    }
}

