/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.InvokeNodeSubNodeGen;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

abstract class InvokeNodeSub
extends JavaObjectMessageResolution.InvokeNode {
    InvokeNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, JavaObject object, String name, Object[] args) {
        return this.access(frame, object, name, args);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new INVOKERootNode(language);
    }

    private static final class INVOKERootNode
    extends RootNode {
        @Node.Child
        private InvokeNodeSub node = InvokeNodeSubNodeGen.create();

        protected INVOKERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            try {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                List<Object> arguments = ForeignAccess.getArguments(frame);
                Object identifier = arguments.get(0);
                Object[] args = new Object[arguments.size() - 1];
                for (int i = 0; i < arguments.size() - 1; ++i) {
                    args[i] = arguments.get(i + 1);
                }
                return this.node.executeWithTarget(frame, receiver, identifier, args);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof InvokeNodeSub) {
                    throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

