/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RetryException;
import org.jruby.truffle.language.control.ReturnException;
import org.jruby.truffle.language.control.ReturnID;

public class CatchForMethodNode
extends RubyNode {
    private final ReturnID returnID;
    @Node.Child
    private RubyNode body;
    private final ConditionProfile matchingReturnProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile retryProfile = BranchProfile.create();

    public CatchForMethodNode(ReturnID returnID, RubyNode body) {
        this.returnID = returnID;
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (ReturnException e) {
            if (this.matchingReturnProfile.profile(e.getReturnID() == this.returnID)) {
                return e.getValue();
            }
            throw e;
        }
        catch (RetryException e) {
            this.retryProfile.enter();
            throw new RaiseException(this.coreExceptions().syntaxErrorInvalidRetry(this));
        }
    }
}

