/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.options;

import com.oracle.truffle.api.TruffleOptions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jruby.truffle.core.string.KCode;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.options.ArgumentProcessor;
import org.jruby.truffle.options.Verbosity;

public class RubyInstanceConfig {
    private boolean xFlag = false;
    private PrintStream output = System.out;
    private PrintStream error = System.err;
    private String currentDirectory;
    private Map<String, String> environment;
    private String[] argv = new String[0];
    private String internalEncoding = null;
    private String externalEncoding = null;
    private List<String> loadPaths = new ArrayList<String>();
    private StringBuffer inlineScript = new StringBuffer();
    private boolean hasInlineScript = false;
    private boolean usePathScript = false;
    private String scriptFileName = null;
    private Collection<String> requiredLibraries = new LinkedHashSet<String>();
    private boolean argvGlobalsOn = false;
    private boolean assumeLoop = false;
    private boolean assumePrinting = false;
    private Map<String, String> optionGlobals = new HashMap<String, String>();
    private boolean processLineEnds = false;
    private boolean split = false;
    private Verbosity verbosity = Verbosity.FALSE;
    private boolean debug = false;
    private boolean showVersion = false;
    private boolean showCopyright = false;
    private boolean shouldRunInterpreter = true;
    private boolean shouldPrintUsage = false;
    private boolean shouldPrintProperties = false;
    private boolean shouldCheckSyntax = false;
    private String inputFieldSeparator = null;
    private String inPlaceBackupExtension = null;
    private boolean disableGems = false;
    private boolean hasScriptArgv = false;
    private boolean frozenStringLiteral = false;
    private KCode kcode;
    private String sourceEncoding;
    private boolean forceStdin = false;

    public RubyInstanceConfig() {
        this.currentDirectory = System.getProperty("user.dir", "/");
        this.environment = new HashMap<String, String>();
        this.environment.putAll(System.getenv());
    }

    public void processArguments(String[] arguments) {
        ArgumentProcessor processor = new ArgumentProcessor(arguments, this);
        processor.processArguments();
        this.processArgumentsWithRubyopts();
        if (!(TruffleOptions.AOT || this.hasScriptArgv || this.usePathScript || System.console() == null)) {
            this.setUsePathScript("irb");
        }
    }

    public void processArgumentsWithRubyopts() {
        String rubyopt;
        String rubyoptObj = this.environment.get("RUBYOPT");
        String string = rubyopt = rubyoptObj == null ? null : rubyoptObj.toString();
        if (rubyopt == null || rubyopt.length() == 0) {
            return;
        }
        String[] rubyoptArgs = rubyopt.split("\\s+");
        if (rubyoptArgs.length != 0) {
            new ArgumentProcessor(rubyoptArgs, false, true, true, this).processArguments();
        }
    }

    public byte[] inlineScript() {
        return this.inlineScript.toString().getBytes();
    }

    public InputStream getScriptSource() {
        try {
            if (this.hasInlineScript) {
                return new ByteArrayInputStream(this.inlineScript());
            }
            if (this.isForceStdin() || this.getScriptFileName() == null) {
                return System.in;
            }
            String script = this.getScriptFileName();
            return new FileInputStream(script);
        }
        catch (IOException e) {
            throw new JavaException(e);
        }
    }

    public String displayedFileName() {
        if (this.hasInlineScript) {
            if (this.scriptFileName != null) {
                return this.scriptFileName;
            }
            return "-e";
        }
        if (this.usePathScript) {
            return "-S";
        }
        if (this.isForceStdin() || this.getScriptFileName() == null) {
            return "-";
        }
        return this.getScriptFileName();
    }

    public PrintStream getOutput() {
        return this.output;
    }

    public PrintStream getError() {
        return this.error;
    }

    public void setCurrentDirectory(String newCurrentDirectory) {
        this.currentDirectory = newCurrentDirectory;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String[] getArgv() {
        return this.argv;
    }

    public void setArgv(String[] argv) {
        this.argv = argv;
    }

    public StringBuffer getInlineScript() {
        return this.inlineScript;
    }

    public void setHasInlineScript(boolean hasInlineScript) {
        this.hasScriptArgv = true;
        this.hasInlineScript = hasInlineScript;
    }

    public Collection<String> getRequiredLibraries() {
        return this.requiredLibraries;
    }

    public List<String> getLoadPaths() {
        return this.loadPaths;
    }

    public void setShouldPrintUsage(boolean shouldPrintUsage) {
        this.shouldPrintUsage = shouldPrintUsage;
    }

    public boolean getShouldPrintUsage() {
        return this.shouldPrintUsage;
    }

    public boolean isInlineScript() {
        return this.hasInlineScript;
    }

    public boolean isForceStdin() {
        return this.forceStdin;
    }

    public void setForceStdin(boolean forceStdin) {
        this.forceStdin = forceStdin;
    }

    public void setScriptFileName(String scriptFileName) {
        this.hasScriptArgv = true;
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public void setAssumeLoop(boolean assumeLoop) {
        this.assumeLoop = assumeLoop;
    }

    public void setAssumePrinting(boolean assumePrinting) {
        this.assumePrinting = assumePrinting;
    }

    public void setProcessLineEnds(boolean processLineEnds) {
        this.processLineEnds = processLineEnds;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public boolean isVerbose() {
        return this.verbosity == Verbosity.TRUE;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowCopyright(boolean showCopyright) {
        this.showCopyright = showCopyright;
    }

    public boolean isShowCopyright() {
        return this.showCopyright;
    }

    public void setShouldRunInterpreter(boolean shouldRunInterpreter) {
        this.shouldRunInterpreter = shouldRunInterpreter;
    }

    public boolean getShouldRunInterpreter() {
        return this.shouldRunInterpreter && (this.hasScriptArgv || !this.showVersion);
    }

    public void setShouldCheckSyntax(boolean shouldSetSyntax) {
        this.shouldCheckSyntax = shouldSetSyntax;
    }

    public boolean getShouldCheckSyntax() {
        return this.shouldCheckSyntax;
    }

    public void setInputFieldSeparator(String inputFieldSeparator) {
        this.inputFieldSeparator = inputFieldSeparator;
    }

    public void setInternalEncoding(String internalEncoding) {
        this.internalEncoding = internalEncoding;
    }

    public String getInternalEncoding() {
        return this.internalEncoding;
    }

    public void setExternalEncoding(String externalEncoding) {
        this.externalEncoding = externalEncoding;
    }

    public String getExternalEncoding() {
        return this.externalEncoding;
    }

    public void setInPlaceBackupExtension(String inPlaceBackupExtension) {
        this.inPlaceBackupExtension = inPlaceBackupExtension;
    }

    public String getInPlaceBackupExtension() {
        return this.inPlaceBackupExtension;
    }

    public Map<String, String> getOptionGlobals() {
        return this.optionGlobals;
    }

    public boolean isArgvGlobalsOn() {
        return this.argvGlobalsOn;
    }

    public void setArgvGlobalsOn(boolean argvGlobalsOn) {
        this.argvGlobalsOn = argvGlobalsOn;
    }

    public boolean isDisableGems() {
        return this.disableGems;
    }

    public void setDisableGems(boolean dg) {
        this.disableGems = dg;
    }

    public void setXFlag(boolean xFlag) {
        this.xFlag = xFlag;
    }

    public boolean isXFlag() {
        return this.xFlag;
    }

    public boolean isFrozenStringLiteral() {
        return this.frozenStringLiteral;
    }

    public void setFrozenStringLiteral(boolean frozenStringLiteral) {
        this.frozenStringLiteral = frozenStringLiteral;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public void setKCode(KCode kcode) {
        this.kcode = kcode;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setUsePathScript(String name) {
        this.scriptFileName = name;
        this.usePathScript = true;
    }

    public boolean shouldUsePathScript() {
        return this.usePathScript;
    }
}

