/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.UndoManager;
import CH.ifa.draw.util.Undoable;

public class RedoCommand
extends AbstractCommand {
    public RedoCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        UndoManager um = this.getDrawingEditor().getUndoManager();
        if (um == null || !um.isRedoable()) {
            return;
        }
        Undoable lastRedoable = um.popRedo();
        boolean hasBeenUndone = lastRedoable.redo();
        if (hasBeenUndone && lastRedoable.isUndoable()) {
            um.pushUndo(lastRedoable);
        }
        lastRedoable.getDrawingView().checkDamage();
        this.getDrawingEditor().figureSelectionChanged(lastRedoable.getDrawingView());
    }

    public boolean isExecutableWithView() {
        UndoManager um = this.getDrawingEditor().getUndoManager();
        return um != null && um.getRedoSize() > 0;
    }
}

