/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view.tree;

import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.tree.AutoScrollingTree;
import ch.softenvironment.view.tree.TransferableTreeNode;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class TreeDragSource
implements DragSourceListener,
DragGestureListener {
    private DragSource source = null;
    private AutoScrollingTree sourceTree = null;
    private TransferableTreeNode transferable = null;

    public TreeDragSource(AutoScrollingTree tree, int actions) {
        this.sourceTree = tree;
        this.source = new DragSource();
        this.source.createDefaultDragGestureRecognizer(this.sourceTree, actions, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.sourceTree.getSelectionPath();
        if (path == null || path.getPathCount() <= 1) {
            return;
        }
        this.transferable = new TransferableTreeNode(path);
        this.source.startDrag(dge, DragSource.DefaultMoveDrop, this.transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.transferable = null;
    }

    private boolean isDropAcceptable(DragSourceDragEvent dsde) {
        try {
            Point p = dsde.getLocation();
            DragSourceContext dtc = dsde.getDragSourceContext();
            JTree tree = (JTree)dtc.getComponent();
            TreePath path = tree.getClosestPathForLocation(p.x, p.y);
            Object dropTargetNode = path.getLastPathComponent();
            Object source = ((TreePath)this.transferable.getTransferData(TransferableTreeNode.TREE_PATH_FLAVOR)).getLastPathComponent();
            String msg = this.sourceTree.getUtility().isAddable(source, dropTargetNode);
            if (msg == null) {
                return true;
            }
            Tracer.getInstance().debug("isDropAcceptable()->false: " + msg);
            return false;
        }
        catch (Throwable e) {
            Tracer.getInstance().developerWarning(e.getLocalizedMessage());
            return false;
        }
    }

    private void setDragDropCursor(DragSourceDragEvent dsde) {
        DragSourceContext dsc = dsde.getDragSourceContext();
        if (this.isDropAcceptable(dsde)) {
            dsc.setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsc.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }
}

