/*
 * Decompiled with CFR 0.152.
 */
package dguitar.players.sound.midi;

import dguitar.adaptors.song.SongEvent;
import dguitar.adaptors.song.SongTrack;
import dguitar.adaptors.song.Tempo;
import dguitar.adaptors.song.TimeSignature;
import dguitar.adaptors.song.impl.SongDeviceImpl;
import dguitar.players.sound.EventStream;
import dguitar.players.sound.Performance;
import dguitar.players.sound.PerformanceEvent;
import dguitar.players.sound.PerformanceNoteEvent;
import dguitar.players.sound.midi.EventFactory;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public abstract class PerformanceCore
extends Sequence
implements Performance {
    private static String className;
    private static Logger logger;
    Tempo tempo;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("dguitar.players.sound.midi.PerformanceCore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.toString();
        logger = Logger.getLogger(className);
    }

    public PerformanceCore(int tracks, Tempo tempo, int resolution) throws InvalidMidiDataException {
        super(0.0f, resolution, tracks);
        this.setTempo(tempo);
    }

    private void makeEvent(int track, long time, MidiMessage mm) {
        Track[] tracksB = this.getTracks();
        Track target = tracksB[track];
        MidiEvent me = new MidiEvent(mm, time);
        target.add(me);
    }

    private void makeEvent(int track, long time, int status, int data1, int data2) {
        ShortMessage sm = new ShortMessage();
        try {
            sm.setMessage(status, data1, data2);
            this.makeEvent(track, time, sm);
        }
        catch (InvalidMidiDataException e) {
            logger.warning("Invalid midi data exception " + status + " " + data1 + " " + data2);
        }
    }

    private void setTempo(Tempo tempo) throws InvalidMidiDataException {
        this.tempo = tempo;
        int usq = (int)tempo.getUSQ();
        MetaMessage mm = new MetaMessage();
        byte[] data = new byte[]{(byte)(usq >> 16 & 0xFF), (byte)(usq >> 8 & 0xFF), (byte)(usq & 0xFF)};
        mm.setMessage(81, data, 3);
        this.makeEvent(0, 0L, mm);
    }

    public Tempo getTempo() {
        return this.tempo;
    }

    public void initializeTrack(SongTrack track) {
        int index = track.getIndex();
        SongDeviceImpl device = (SongDeviceImpl)track.getPrimaryDevice();
        int channel = device.getChannel();
        int sensitivity = track.getBendSensitivity();
        this.makeEvent(index, 0L, 176 + (channel - 1), 100, 0);
        this.makeEvent(index, 0L, 176 + (channel - 1), 101, 0);
        this.makeEvent(index, 0L, 176 + (channel - 1), 6, sensitivity);
        this.makeEvent(index, 0L, 224 + (channel - 1), 0, 64);
        int program = track.getProgram();
        this.makeEvent(index, 0L, 192 + (channel - 1), program, 0);
        int volume = track.getVolume();
        this.makeEvent(index, 0L, 176 + (channel - 1), 7, volume);
        int pan = track.getPan();
        this.makeEvent(index, 0L, 176 + (channel - 1), 10, pan);
        int chorus = track.getChorus();
        this.makeEvent(index, 0L, 176 + (channel - 1), 93, chorus);
        int reverb = track.getReverb();
        this.makeEvent(index, 0L, 176 + (channel - 1), 91, reverb);
        int tremolo = track.getTremolo();
        this.makeEvent(index, 0L, 176 + (channel - 1), 92, tremolo);
        int phaser = track.getPhaser();
        this.makeEvent(index, 0L, 176 + (channel - 1), 95, phaser);
    }

    public void addMusicalEvents(EventStream events) {
        SongTrack track = events.getTrack();
        SongDeviceImpl device = (SongDeviceImpl)track.getPrimaryDevice();
        int channel = device.getChannel();
        int index = track.getIndex();
        Track[] midiTracks = this.getTracks();
        Track midiTrack = midiTracks[index];
        PerformanceEvent event = events.getFirst();
        while (event != null) {
            PerformanceNoteEvent noteEvent = (PerformanceNoteEvent)event;
            SongEvent songEvent = noteEvent.getEvent();
            int offset = event.getOffset();
            EventFactory.generateEvents(midiTrack, offset, songEvent.getMessage(), channel);
            this.recordPerformanceEvent(event);
            event = event.getNext();
        }
    }

    protected abstract void recordPerformanceEvent(PerformanceEvent var1);

    public void setTimeSignature(int location, TimeSignature timeSignature) {
        MetaMessage mm = new MetaMessage();
        byte[] data = new byte[4];
        int numerator = timeSignature.getNumerator();
        int denominator = timeSignature.getDenominator();
        data[0] = (byte)numerator;
        switch (denominator) {
            case 1: {
                data[1] = 0;
                break;
            }
            case 2: {
                data[1] = 1;
                break;
            }
            case 4: {
                data[1] = 2;
                break;
            }
            case 8: {
                data[1] = 3;
                break;
            }
            case 16: {
                data[1] = 4;
                break;
            }
            case 32: {
                data[1] = 5;
                break;
            }
            default: {
                logger.severe("Time signature denominator " + denominator + " is not supported");
            }
        }
        data[2] = (byte)(96 / denominator);
        data[3] = 8;
        try {
            mm.setMessage(88, data, 4);
            this.makeEvent(0, location, mm);
        }
        catch (InvalidMidiDataException e) {
            logger.severe("Invalid time signature MIDI data");
        }
    }
}

