/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.GccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.tools.DefaultGccCommandLineToolConfiguration;
import org.gradle.nativeplatform.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolRegistry;

public class DefaultGccPlatformToolChain
implements GccPlatformToolChain,
ToolRegistry {
    private final NativePlatform platform;
    private boolean canUseCommandFile = true;
    private List<String> compilerProbeArgs = new ArrayList<String>();
    private final Map<ToolType, GccCommandLineToolConfigurationInternal> tools = new HashMap<ToolType, GccCommandLineToolConfigurationInternal>();

    public DefaultGccPlatformToolChain(NativePlatform platform) {
        this.platform = platform;
    }

    public boolean isCanUseCommandFile() {
        return this.canUseCommandFile;
    }

    public void setCanUseCommandFile(boolean canUseCommandFile) {
        this.canUseCommandFile = canUseCommandFile;
    }

    public List<String> getCompilerProbeArgs() {
        return this.compilerProbeArgs;
    }

    public void compilerProbeArgs(String ... args) {
        this.compilerProbeArgs.addAll(Arrays.asList(args));
    }

    @Override
    public GccCommandLineToolConfigurationInternal getTool(ToolType toolType) {
        return this.tools.get((Object)toolType);
    }

    public Collection<GccCommandLineToolConfigurationInternal> getTools() {
        return this.tools.values();
    }

    public Collection<GccCommandLineToolConfigurationInternal> getCompilers() {
        return Arrays.asList(this.tools.get((Object)ToolType.C_COMPILER), this.tools.get((Object)ToolType.CPP_COMPILER), this.tools.get((Object)ToolType.OBJECTIVEC_COMPILER), this.tools.get((Object)ToolType.OBJECTIVECPP_COMPILER));
    }

    public void add(DefaultGccCommandLineToolConfiguration tool) {
        this.tools.put(tool.getToolType(), tool);
    }

    @Override
    public NativePlatform getPlatform() {
        return this.platform;
    }

    @Override
    public GccCommandLineToolConfigurationInternal getcCompiler() {
        return this.tools.get((Object)ToolType.C_COMPILER);
    }

    @Override
    public GccCommandLineToolConfigurationInternal getCppCompiler() {
        return this.tools.get((Object)ToolType.CPP_COMPILER);
    }

    @Override
    public GccCommandLineToolConfigurationInternal getObjcCompiler() {
        return this.tools.get((Object)ToolType.OBJECTIVEC_COMPILER);
    }

    @Override
    public GccCommandLineToolConfigurationInternal getObjcppCompiler() {
        return this.tools.get((Object)ToolType.OBJECTIVECPP_COMPILER);
    }

    @Override
    public GccCommandLineToolConfigurationInternal getAssembler() {
        return this.tools.get((Object)ToolType.ASSEMBLER);
    }

    @Override
    public GccCommandLineToolConfigurationInternal getLinker() {
        return this.tools.get((Object)ToolType.LINKER);
    }

    @Override
    public GccCommandLineToolConfigurationInternal getStaticLibArchiver() {
        return this.tools.get((Object)ToolType.STATIC_LIB_ARCHIVER);
    }
}

