/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.File;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FacadePartWithSourceFile;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.RootContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isAnnotationOrJvm6Interface(@NotNull DeclarationDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isAnnotationOrJvm6Interface"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isAnnotationOrJvm6Interface"));
        }
        return JvmCodegenUtil.isAnnotationOrJvm6Interface(descriptor2, state2.isJvm8Target());
    }

    public static boolean isAnnotationOrJvm6Interface(@NotNull DeclarationDescriptor descriptor2, boolean isJvm8Target) {
        SourceElement source;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isAnnotationOrJvm6Interface"));
        }
        if (!JvmCodegenUtil.isJvmInterface(descriptor2)) {
            return false;
        }
        if (ClassKind.ANNOTATION_CLASS == ((ClassDescriptor)descriptor2).getKind()) {
            return true;
        }
        if (descriptor2 instanceof DeserializedClassDescriptor && (source = ((DeserializedClassDescriptor)descriptor2).getSource()) instanceof KotlinJvmBinarySourceElement) {
            KotlinJvmBinaryClass binaryClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            assert (binaryClass instanceof FileBasedKotlinClass) : "KotlinJvmBinaryClass should be subclass of FileBasedKotlinClass, but " + binaryClass;
            return ((FileBasedKotlinClass)binaryClass).getClassVersion() == 50;
        }
        return !isJvm8Target;
    }

    public static boolean isJvm8Interface(@NotNull DeclarationDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isJvm8Interface"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isJvm8Interface"));
        }
        return JvmCodegenUtil.isJvm8Interface(descriptor2, state2.isJvm8Target());
    }

    public static boolean isJvm8Interface(@NotNull DeclarationDescriptor descriptor2, boolean isJvm8Target) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isJvm8Interface"));
        }
        return DescriptorUtils.isInterface(descriptor2) && !JvmCodegenUtil.isAnnotationOrJvm6Interface(descriptor2, isJvm8Target);
    }

    public static boolean isJvm8InterfaceMember(@NotNull CallableMemberDescriptor descriptor2, @NotNull GenerationState state2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isJvm8InterfaceMember"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isJvm8InterfaceMember"));
        }
        DeclarationDescriptor declaration = descriptor2.getContainingDeclaration();
        return JvmCodegenUtil.isJvm8Interface(declaration, state2);
    }

    public static boolean isJvmInterface(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isConst"));
        }
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty() && !closure.isCoroutine();
    }

    private static boolean isCallInsideSameClassAsDeclared(@NotNull CallableMemberDescriptor descriptor2, @NotNull CodegenContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameClassAsDeclared"));
        }
        boolean isFakeOverride = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof FacadePartWithSourceFile && JvmCodegenUtil.isWithinSameFile(((FacadePartWithSourceFile)((Object)context.getParentContext())).getSourceFile(), descriptor2)) && context.getContextKind() != OwnerKind.DEFAULT_IMPLS;
    }

    private static boolean isWithinSameFile(@Nullable KtFile callerFile, @NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isWithinSameFile"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            PsiElement calleeElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            PsiFile calleeFile = calleeElement != null ? calleeElement.getContainingFile() : null;
            return callerFile != null && callerFile != SourceFile.NO_SOURCE_FILE && calleeFile == callerFile;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context, @Nullable File outDirectory) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isCallInsideSameModuleAsDeclared"));
        }
        if (context instanceof RootContext) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(directMember, outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "hasAbstractMembers"));
        }
        return CollectionsKt.any(DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope()), new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean isConstOrHasJvmFieldAnnotation(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isConstOrHasJvmFieldAnnotation"));
        }
        return propertyDescriptor.isConst() || AnnotationUtilKt.hasJvmFieldAnnotation(propertyDescriptor);
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property, boolean forGetter, boolean isDelegated, @NotNull MethodContext contextBeforeInline) {
        PropertyAccessorDescriptor accessor;
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (contextBeforeInline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextBeforeInline", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (KotlinTypeMapper.isAccessor(property)) {
            return false;
        }
        CodegenContext context = contextBeforeInline.getFirstCrossInlineOrNonInlineContext();
        if (context.isInlineMethodContext()) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsDeclared(property, context)) {
            if (!JvmCodegenUtil.isDebuggerContext(context)) {
                return false;
            }
            for (PropertyAccessorDescriptor accessorDescriptor : property.getAccessors()) {
                if (accessorDescriptor.isDefault() || forGetter != accessorDescriptor instanceof PropertyGetterDescriptor) continue;
                return false;
            }
            if (!property.getOverriddenDescriptors().isEmpty()) {
                return false;
            }
        }
        if (isDelegated || property.getExtensionReceiverParameter() != null) {
            return false;
        }
        if (DescriptorUtils.isCompanionObject(property.getContainingDeclaration())) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property.getGetter() : property.getSetter();
        if (accessor == null) {
            return true;
        }
        if (DescriptorPsiUtilsKt.hasBody(accessor)) {
            return false;
        }
        return Visibilities.isPrivate(property.getVisibility()) || accessor.getModality() == Modality.FINAL;
    }

    private static boolean isDebuggerContext(@NotNull CodegenContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isDebuggerContext"));
        }
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(context.getContextDescriptor());
        return file2 != null && CodeFragmentUtilKt.getSuppressDiagnosticsInDebugMode(file2);
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor2, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getDispatchReceiverParameterForConstructorCall"));
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (dispatchReceiver != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        CallableMemberDescriptor callableMemberDescriptor = descriptor2 instanceof PropertyAccessorDescriptor ? ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty() : descriptor2;
        if (callableMemberDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getDirectMember"));
        }
        return callableMemberDescriptor;
    }

    public static boolean isArgumentWhichWillBeInlined(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor2) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isArgumentWhichWillBeInlined"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "isArgumentWhichWillBeInlined"));
        }
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        return InlineUtil.canBeInlineArgument(declaration) && InlineUtil.isInlinedArgument((KtFunction)declaration, bindingContext, false);
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module) {
        String string = StringsKt.removeSurrounding(module.getName().asString(), (CharSequence)"<", (CharSequence)">");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getModuleName"));
        }
        return string;
    }

    @NotNull
    public static String getMappingFileName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getMappingFileName"));
        }
        String string = "META-INF/" + moduleName + "." + "kotlin_module";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getMappingFileName"));
        }
        return string;
    }

    public static boolean isInlinedJavaConstProperty(VariableDescriptor descriptor2) {
        if (!(descriptor2 instanceof JavaPropertyDescriptor)) {
            return false;
        }
        return descriptor2.isConst();
    }

    @Nullable
    public static KotlinType getPropertyDelegateType(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        Call call;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getPropertyDelegateType"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/JvmCodegenUtil", "getPropertyDelegateType"));
        }
        VariableAccessorDescriptor getter = descriptor2.getGetter();
        if (getter != null && (call = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, getter)) != null) {
            assert (call.getExplicitReceiver() != null) : "No explicit receiver for call:" + call;
            return ((ReceiverValue)call.getExplicitReceiver()).getType();
        }
        return null;
    }
}

